/*
SRDownloadHistoryItem.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

typedef enum _SRDownloadItemStatus {
    SRDownloadStatusActive = 0, 
    SRDownloadStatusPaused, 
    SRDownloadStatusCompleted, 
    SRDownloadStatusUnknown, 
} SRDownloadItemStatus;

@interface SRDownloadHistoryItem : NSObject
{
    NSMutableDictionary*    _infoDict;
}

// Initialize
- (id)initWithHistoryDictionary:(NSDictionary*)dict;

// Download information
- (void)setDownload:(NSURLDownload*)download;
- (NSURLDownload*)download;

- (void)setRequest:(NSURLRequest*)request;
- (void)setResponse:(NSURLResponse*)response;
- (NSString*)URLString;
- (NSString*)fileName;
- (NSString*)relatedURLString;
- (NSImage*)icon;

- (NSString*)downloadedFilePath;
- (void)setDownloadedFilePath:(NSString*)path;
- (NSString*)downloadedFileName;

- (long long)expectedLength;
- (long long)downloadedLength;
- (void)setDownloadedLength:(long long)length;
- (void)increaseDownloadedLength:(long long)length;
- (void)resetLength;

- (NSDate*)startTime;
- (void)setStartTime:(NSDate*)date;

// Download resume information
- (NSDictionary*)resumeInfo;
- (void)setResumeInfo:(NSDictionary*)resumeInfo;

// Status
- (SRDownloadItemStatus)status;
- (void)setStatus:(SRDownloadItemStatus)status;

// Persistence
- (NSDictionary*)historyDictionary;

@end
