/*
SRURLComboBox.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

enum{
	_mouseDownPoint_nowhere=0,
	_mouseDownPoint_leftImage=1,
};
@class SRURLAutoCompleteDataSource;

@interface SRURLComboBox : NSComboBox
{
	int								_mouseDownPoint;
    SRURLAutoCompleteDataSource*    _completeDataSource;
    
    NSMutableArray*                 _buttons;
}

// Working with image
- (void)setImage:(NSImage*)image;
- (NSImage*)image;

// Working wiht buttons
- (NSArray*)buttons;
- (NSButton*)addButtonWithSize:(NSSize)size;
- (NSButton*)buttonWithTag:(int)tag;
- (void)removeButton:(NSButton*)button;
- (NSRect)buttonFrame;

- (NSString*)absoluteURLStringOfCompletedString:(NSString*)completedString;

@end
