/*
SRSBPageHolder.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

extern NSString*    SRSBPageHolderEnableToAdd;
extern NSString*    SRSBPageHolderEnableToRemove;
extern NSString*    SRSBPageHolderEnableToReload;
extern NSString*    SRSBPageHolderEnableToStop;
extern NSString*    SRSBPageHolderEnableToMakeTextSmaller;
extern NSString*    SRSBPageHolderEnableToMakeTextStandard;
extern NSString*    SRSBPageHolderEnableToMakeTextLarger;

@class SRMainWindowController;
@class SRSideBarController;

@interface SRSBPageHolderController : NSResponder
{
    SRMainWindowController* _mainWindowController;
    SRSideBarController*    _sideBarController;
    
    IBOutlet id _pageHolderView;
    IBOutlet id _tabView;
    IBOutlet id _tabContentView;
    
    IBOutlet id _content;
    IBOutlet id _objectController;
}

// Initialize
- (id)initWithMainWindowController:(SRMainWindowController*)mainWindowController 
        sideBarController:(SRSideBarController*)sideBarController;

// Controller
- (SRMainWindowController*)mainWindowController;
- (void)setMainWindowController:(SRMainWindowController*)mainWindowController;
- (SRSideBarController*)sideBarController;
- (void)setSidebarController:(SRSideBarController*)sideBarController;

// View
- (NSView*)view;

// Actions
- (void)addPageAction:(id)sender;
- (void)removePageAction:(id)sender;
- (void)reloadAction:(id)sender;
- (void)stopAction:(id)sender;
- (void)makeTextSmallerAction:(id)sender;
- (void)makeTextLargerAction:(id)sender;
- (void)makeTextStandardAction:(id)sender;

@end
