/*
SRPreferencesController.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

extern NSString*    SRWebPreferencesIdentifier;

@interface SRPreferencesController : NSObject
{
	int                 _fontButtonTag;
    id<NSMenuItem>      _defaultFontSizeOtherItem;
    id<NSMenuItem>      _fixedFontSizeOtherItem;
    id<NSMenuItem>      _minFontSizeOtherItem;
    
    // Properties
    NSString*           _iconDisplayName;
    NSMutableArray*     _browsers;
    NSMutableArray*     _isUsing;
    NSMutableArray*     _localizedBrowserNames;
    NSMutableArray*     _browserIcons;
    
    IBOutlet id _generalView;
    IBOutlet id _appearanceView;
    IBOutlet id _bookmarksView;
    IBOutlet id _tabsView;
    IBOutlet id _securityView;
    IBOutlet id _advancedView;
    IBOutlet id _iconView;
    IBOutlet id _sourceView;
    IBOutlet id _sidebarPrefView;
    IBOutlet id _RSSPrefView;
    
    IBOutlet id _preferencesController;
    IBOutlet id _preferencesPanel;
    IBOutlet id _preferencesTab;
    IBOutlet id _prefInfoController;
    
    IBOutlet id _homeTextField;
    IBOutlet id _downloadPathPopup;
    
    IBOutlet id _defaultFontSizePopup;
    IBOutlet id _fixedFontSizePopup;
    IBOutlet id _minFontSizePopup;
    IBOutlet id _fontSizePanel;
    IBOutlet id _fontSizeTextField;
    IBOutlet id _transitionEffectCheckBox;
    IBOutlet id _transitionEffectLabel;
    
    IBOutlet id _bookmarksBarPopup;
    IBOutlet id _bookmarksTableView;
    
    IBOutlet id _cookieStorageController;
    IBOutlet id _cookiesController;
    IBOutlet id _cookiePanel;
    
    IBOutlet id _styleSheetPopup;
    
    IBOutlet id _userAgentPanel;
    IBOutlet id _userAgentPopup;
    IBOutlet id _userAgentTextField;
    
    IBOutlet id _soundPageLoadDonePopup;
    IBOutlet id _soundPageLoadErrorPopup;
    
    IBOutlet id _encodings;
    
    IBOutlet id _unifiedToolbarCheckBox;
    IBOutlet id _iconCheckBoxMatrix;
    IBOutlet id _iconPopup;
    IBOutlet id _iconMatrix;
    IBOutlet id _iconDeleteButton;
    
    IBOutlet id _faviconController;
    IBOutlet id _faviconPanel;
    
    IBOutlet id _sourceFontSizePopup;
    
    IBOutlet id _RSSUpdateMinutesTextField;
    IBOutlet id _RSSUpdateMinutesLabel;
}

// WebPreferences
+ (WebPreferences*)defaultWebPreferences;

// Managing panel
- (NSView*)viewForIdentifier:(NSString*)identifier;
- (void)showPreferences;

- (NSString*)homeURLString;

// Actions
- (IBAction)setToCurrentPageAction:(id)sender;
- (IBAction)showFontPanelAction:(id)sender;

- (void)_popup:(NSPopUpButton*)popup 
        selectItemWithTag:(int)selectTag 
        replaceMenuItem:(id<NSMenuItem>*)menuItem 
        withTitle:(NSString*)title 
        aboveTag:(int)tag;
- (IBAction)setDefaultFontSizeAction:(id)sender;
- (IBAction)setFixedFontSizeAction:(id)sender;
- (IBAction)setMinFontSizeAction:(id)sender;

- (IBAction)showCookiePanelAction:(id)sender;
- (IBAction)closeCookiePanelAction:(id)sender;
- (IBAction)removeCookieAction:(id)sender;
- (IBAction)removeAllCookiesAction:(id)sender;

- (IBAction)showStyleSheetOpenPanelAction:(id)sender;

- (IBAction)setUserAgentAction:(id)sender;
- (IBAction)showUserAgentPanelAction:(id)sender;
- (IBAction)closeUserAgentPanelAction:(id)sender;

- (IBAction)loadIconLocalAction:(id)sender;
- (IBAction)deleteIconAction:(id)sender;

- (IBAction)showFaviconPanelAction:(id)sender;
- (IBAction)closeFaviconPanelAction:(id)sender;

- (IBAction)setSourceFontSizeAction:(id)sender;

// User agents
+ (NSArray*)userAgents;

@end
