//
//  SRJSErrorLog.h
//  Shiira
//
//  Created by 鷲田 基 on 06/01/28.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*!
	@class SRJSErrorLogController
	@discussion
	SRJSErrorLogController Manages JavaScript Error Log.
	
	Note: It contains a key named <i>logItems</i>, but there is no method to access it.
	
	<i>logItems</i>' keys are <i>lineNumber</i>, <i>message</i>, and <i>sourceURL</i>
*/

@interface SRJSErrorLogController : NSWindowController {
	NSMutableArray*			_logItems;
}

/*!
	@method clearLog:
	@abstract action to clear log messages.
*/
- (IBAction)clearLog:(id)sender;

/*!
	@method openJavaScriptSources:
	@param items subarray of <i>logItems</i>
	@abstract open sources related to logItems.
*/
- (void)openJavaScriptSources:(NSArray *)items;

@end
