/*
SRIconDatabase.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRBookmarkIconDatabase.h"

#import "WebKitEx.h"

NSString*   SRIconFileName = @"Shiira/Icon.dat";
NSString*   SRIconDirName = @"Shiira/Favicons";
NSString*   SRIconDictFileName = @"Shiira/Favicons/Favicons.plist";

@implementation SRBookmarkIconDatabase

//--------------------------------------------------------------//
#pragma mark -- Initialzie --
//--------------------------------------------------------------//

+ (SRBookmarkIconDatabase*)sharedInstance
{
    static SRBookmarkIconDatabase*  _instance = nil;
    if (!_instance) {
        _instance = [[SRBookmarkIconDatabase alloc] init];
    }
    
    return _instance;
}

#if 0

//--------------------------------------------------------------//
#pragma mark -- Persistence --
//--------------------------------------------------------------//

- (BOOL)loadIcons
{
    NSFileManager*	fileMgr;
    fileMgr = [NSFileManager defaultManager];
    
    // Get icon.dat path
    NSString*   path;
    path = [[self class] faviconDatFilePath];
    
    // Check existence
    if ([fileMgr fileExistsAtPath:path]) {
        // Convert it
        NSString*   faviconsDir;
        faviconsDir = [[self class] faviconsDirPath];
        
        id  faviconDict;
        faviconDict = [NSUnarchiver unarchiveObjectWithFile:path];
        if (faviconDict) {
            NSEnumerator*   enumerator;
            NSString*       URLString;
            enumerator = [faviconDict keyEnumerator];
            while (URLString = [enumerator nextObject]) {
                NSImage*    image;
                image = [faviconDict objectForKey:URLString];
                if (image) {
                    // Save favicon
                    NSString*   fileName;
                    fileName = [NSString stringWithFormat:@"%u.dat", [URLString hash]];
                    [[image TIFFRepresentation] writeToFile:[faviconsDir stringByAppendingPathComponent:fileName] 
                            atomically:YES];
                    
                    // Set image file name
                    [_URLToFileDict setObject:fileName forKey:URLString];
                    
                    // Set image to favicon dict
                    [_faviconDict setObject:image forKey:URLString];
                }
            }
        }
        
        // Remove icon.dat
        [fileMgr removeFileAtPath:path handler:NULL];
    }
    
    // Get favicon dict path
    path = [[self class] faviconsDictFilePath];
    
    // Check existence
    if ([fileMgr fileExistsAtPath:path]) {
        // Load favicon dict
        NSData*                 data;
        NSMutableDictionary*    dict;
        data = [NSData dataWithContentsOfMappedFile:path];
        dict = [NSPropertyListSerialization propertyListFromData:data 
                mutabilityOption:NSPropertyListMutableContainers 
                format:NULL 
                errorDescription:NULL];
        if (dict) {
            [_URLToFileDict release];
            _URLToFileDict = [dict retain];
        }
    }
    
    return YES;

#if 0
    // Get the paths of ~/Library/Shiira/ and icon file
    NSArray*	libraryPaths;
    NSString*   iconFilePath;
    libraryPaths = NSSearchPathForDirectoriesInDomains(
            NSLibraryDirectory, NSUserDomainMask, YES);
    iconFilePath = [[libraryPaths objectAtIndex:0] 
            stringByAppendingPathComponent:SRIconFileName];
    
    // Convert Icon.dat
    NSFileManager*	fileMgr;
    fileMgr = [NSFileManager defaultManager];
    if ([fileMgr fileExistsAtPath:iconFilePath]) {
        // Unarchive file
        id  faviconDict;
        faviconDict = [NSUnarchiver unarchiveObjectWithFile:file];
        if (!faviconDict) {
            return NO;
        }
        
        return YES;
    }
    
    // Load icons
    SRBookmarkIconDatabase* iconDatabase;
    iconDatabase = [SRBookmarkIconDatabase sharedInstance];
    if (![iconDatabase loadFromFile:iconFilePath]) {
        // Error
        return;
    }
    
    // Unarchive file
    id  faviconDict;
    faviconDict = [NSUnarchiver unarchiveObjectWithFile:file];
    if (!faviconDict) {
        return NO;
    }
    
    [_faviconDict release];
    _faviconDict = [faviconDict retain];
#endif
    
    return YES;
}

- (BOOL)saveIcons
{
    // Get favicon dict path
    NSString*   path;
    path = [[self class] faviconsDictFilePath];
    
    // Save favicon dict
    NSData* data;
    data = [NSPropertyListSerialization dataFromPropertyList:_URLToFileDict 
            format:NSPropertyListBinaryFormat_v1_0 
            errorDescription:NULL];
    return [data writeToFile:path atomically:YES];
}
#endif

//--------------------------------------------------------------//
#pragma mark -- Conversion --
//--------------------------------------------------------------//

- (BOOL)hasOldIconDabase
{
    return NO;
}

- (void)convertIconDatabase
{
}

@end
