/*
SRXMLElement.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRXMLNodePrivate.h"
#import "SRXMLElement.h"

@interface SRXMLElementPrivate : NSObject
{
@public
	NSMutableArray*			_attributes;
	NSMutableDictionary*	_attrsDict;
}
@end

@implementation SRXMLElementPrivate

- (id)init
{
	self = [super init];
	if (!self) {
		return nil;
	}
	
	// Initialize instance variables
	_attributes = nil;
	_attrsDict = nil;
	
	return self;
}

- (void)dealloc
{
	[_attributes release];
	[_attrsDict release];
	
	[super dealloc];
}

@end

#pragma mark -

@implementation SRXMLElement

#pragma mark -- Initialize --

- (id)initWithName:(NSString*)name
{
	self = [self initWithLocalName:name URI:nil];
	return self;
}

- (id)initWithName:(NSString*)name stringValue:(NSString*)string
{
	self = [self initWithLocalName:name URI:nil];
	if (!self) {
		return nil;
	}
	
	// Initialize instance variables
	_elementPrivate = [[SRXMLElementPrivate alloc] init];
	[self setStringValue:string];
	
	return self;
}

- (id)initWithLocalName:(NSString*)name URI:(NSString*)URI
{
	self = [super initWithKind:SRXMLElementKind];
	
	// Initialize instance variables
	_elementPrivate = [[SRXMLElementPrivate alloc] init];
	[self setName:name];
	[self _setURI:URI];
	
	return self;
}

- (void)dealloc
{
	[_elementPrivate release];
	_elementPrivate = nil;
    
	[super dealloc];
}

#pragma mark -- Attributes --

- (void)_createAttributes
{
	xmlNodePtr	node;
	node = [self _node];
	if (!node) {
		return;
	}
	
	// It should be xmlElmentPtr
	if (node->type != XML_ELEMENT_NODE) {
		return;
	}
	xmlElementPtr	element;
	element = (xmlElementPtr)node;
	
	// Get attributes
	xmlAttributePtr	attrs;
	attrs = element->attributes;
	if (!attrs) {
		return;
	}
	
	// Create attributes
	_elementPrivate->_attributes = [[NSMutableArray array] retain];
	_elementPrivate->_attrsDict = [[NSMutableDictionary dictionary] retain];
	while (attrs) {
		// Create attribute
		SRXMLNode*	attr;
		attr = [SRXMLNode _nodeWithNode:(xmlNodePtr)attrs];
		[_elementPrivate->_attributes addObject:attr];
		[_elementPrivate->_attrsDict setObject:attr forKey:[attr name]];
		
		attrs = (xmlAttributePtr)attrs->next;
	}
}

- (SRXMLNode*)attributeForName:(NSString*)name
{
	if (!_elementPrivate->_attrsDict) {
		[self _createAttributes];
	}
	
	return [_elementPrivate->_attrsDict objectForKey:name];
}

- (NSArray*)attributes
{
	if (!_elementPrivate->_attributes) {
		[self _createAttributes];
	}
	
	return _elementPrivate->_attributes;
}

@end
