/*
  SRTBIImageFrameStyleCell.m
Author: Hetima Computer

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.


*/

#import <objc/objc-runtime.h>
#import "SRTBIImageFrameStyleCell.h"




#define	kHTTabBarIndicatorWidth 16
#define	kHTTabBarIndicatorRightMargin 2
#define	kHTTabBarIndicatorYActive   5//4.5
#define	kHTTabBarIndicatorYInactive 5//4.5




#pragma mark -

#define	MARGIN_X	3
#define	kPaddingLeft	2
#define	kPaddingRight	4
#define	MARGIN_Y	4

@implementation SRTBIImageFrameStyleCell

NSImageCell *gSRTBIImageFrameStyleImageCell;
+ (void)initialize
{
	gSRTBIImageFrameStyleImageCell=[[NSImageCell alloc]init];
	[gSRTBIImageFrameStyleImageCell setImageFrameStyle:NSImageFrameGrayBezel];
}
+(NSString*)name
{
	return @"ImageFrame Style";
}


+(float)displayWidthOfString:(NSString*)label withCloseButton:(BOOL)flag
{
	NSMutableAttributedString*  attrStr;
	attrStr=[[[NSMutableAttributedString alloc]initWithString:label]autorelease];
	NSRange range=NSMakeRange(0, [label length]);

	// Add font attribute
	[attrStr addAttribute:NSFontAttributeName value:[NSFont systemFontOfSize:11.0]/*[self font]*/ range:range];
	[attrStr addAttribute:NSParagraphStyleAttributeName value:gTruncatingTailParagraphStyle range:range];

	float   resultWidth=[attrStr size].width;
    if (flag) {
        resultWidth+=[gHTTabBarGeneralCloseBtn size].width;
    }
	resultWidth+=MARGIN_X+MARGIN_Y+kPaddingLeft+kPaddingRight+kPaddingRight;
	return resultWidth;
}

+(float)cellHeight
{
	return 26;
}
+(float)cellTopMargin
{
	return 0;
}
+(float)cellBottomMargin
{
	return 0;
}

-(id)initWithKeeperView:(id)keeperView contentView:(id)webView
{
    self = [super initWithKeeperView:keeperView contentView:webView];
    if (self) {

	}
	return self;
}

- (NSString *)description
{
	return [self stringValue];
}



#pragma mark -
#pragma mark ---- draw ----
+(BOOL)canHaveCloseButton
{
	return YES;
}

-(NSRect)closeBtnRectForFrame:(NSRect)cellFrame
{
	NSRect  result;
	cellFrame.size.height-=6.5;
	cellFrame.origin.y+=4;
	
	if(!_hasCloseButton)return NSZeroRect;
	result.size=[gHTTabBarGeneralCloseBtn size];

	result.origin.x =cellFrame.origin.x + MARGIN_X+kPaddingLeft;
	result.origin.y =cellFrame.origin.y + MARGIN_Y;
	return result;

}

+(BOOL)canHaveIndicator
{
	return YES;
}
-(NSRect)indicatorRectForFrame:(NSRect)cellFrame
{
	NSRect  resultRect=cellFrame;
	
	resultRect.size.height=kHTTabBarIndicatorWidth;
	resultRect.size.width=kHTTabBarIndicatorWidth;

	resultRect.origin.x+=(cellFrame.size.width-kHTTabBarIndicatorWidth-kHTTabBarIndicatorRightMargin);
	resultRect.origin.y+=kHTTabBarIndicatorYActive;

	return resultRect;
}

-(void)drawBackgroundRect:(NSRect)rect inView:(HTSRTabBarView *)controlView
{
	//image frame
	if([self state]==NSOnState){
		NSRect  iRect=[self frame];
		iRect.origin.x=(int)([self frame].origin.x+[self frame].size.width-2);
		iRect.size.width=(int)([controlView bounds].size.width);
		
		iRect.size.height-=[SRTBIImageFrameStyleCell cellBottomMargin];
	//	cellFrame.origin.y+=3;
	//[SRTBIImageFrameStyleCell cellHeight]
		[gSRTBIImageFrameStyleImageCell drawWithFrame:iRect inView:controlView];
		
		if(!([self tabState] & HTSRTab_PositionLeftMask)){
			NSRect  iRect=[self frame];
			iRect.origin.x=(int)([controlView leftMargin]-3);
			iRect.size.width=(int)([self frame].origin.x-[controlView leftMargin]+6);
		
			[gSRTBIImageFrameStyleImageCell drawWithFrame:iRect inView:controlView];
		}
	}else{
		NSRect  iRect=rect;
		//iRect.size.width-=([controlView leftMargin]+[controlView rightMargin]);
		iRect.origin.x+=([controlView leftMargin]-3);
		
		iRect.size.height-=[SRTBIImageFrameStyleCell cellBottomMargin];
		[gSRTBIImageFrameStyleImageCell drawWithFrame:iRect inView:controlView];
	
	}

	NSColor*	lineColor;
    float x=rect.origin.x;
    float y=rect.origin.y;
	if([[controlView window]styleMask]&NSTexturedBackgroundWindowMask){
		lineColor=[NSColor darkGrayColor];
	}else{
		lineColor=[NSColor controlShadowColor];
	}
	//frame
	[lineColor set];
	[NSBezierPath strokeLineFromPoint:NSMakePoint(x,y+rect.size.height-0.5) toPoint:NSMakePoint(x+rect.size.width,y+rect.size.height-0.5)];



}


- (void)drawWithFrame:(NSRect)cellFrame  inView:(NSView *)controlView
{
	NSColor*	lineColor;
//	cellFrame.size.height-=6.5;
//	cellFrame.origin.y+=3;
	

	if([[controlView window]styleMask]&NSTexturedBackgroundWindowMask){
		lineColor=[NSColor darkGrayColor];
	}else{
		lineColor=[NSColor controlShadowColor];
	}

	if([self state]==NSOnState){
		//nothing

	}else{
//		NSRect  aRect=NSMakeRect(cellFrame.origin.x,cellFrame.origin.y,cellFrame.size.width,cellFrame.size.height);
        NSRect  aRect=cellFrame;
        aRect.size.height-=6.5;
        aRect.origin.y+=3;

		aRect.origin.y+=0.5;
		aRect.origin.x+=1.5;
		aRect.size.width-=1;

		//background
		if(_trackingMode==track_normal && _trackingHilite){
//			int tabState=[self tabState];
			float   x=aRect.origin.x;
			float alpha;
			if([[controlView window]styleMask]&NSTexturedBackgroundWindowMask){
				alpha=0.2;
			}else{
				alpha=0.1;
			}	

			[[NSColor colorWithCalibratedWhite:0.0 alpha:alpha]set];
			NSRectFillUsingOperation(aRect, NSCompositeSourceAtop); 
			aRect.origin.x=x;
		}
		aRect.origin.x-=1;
		aRect.size.width+=1;
		
		//frame
		if(!([self tabState] & HTSRTab_RightIsSelectedMask)){
			[lineColor set];
			[NSBezierPath strokeLineFromPoint:NSMakePoint(aRect.origin.x+aRect.size.width,aRect.origin.y) 
				toPoint:NSMakePoint(aRect.origin.x+aRect.size.width,aRect.origin.y+aRect.size.height)];
		}
	}
	
	[self drawInteriorWithFrame:cellFrame inView:controlView];
}



- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
    NSSize	iconSize = NSZeroSize;

    // Draw Image
	if(_hasCloseButton){
		NSRect  iconRect=[self closeBtnRectForFrame:cellFrame];
		NSImage*	icon=gHTTabBarGeneralCloseBtn;
		if(_trackingMode==track_ROver_close_btn)icon=gHTTabBarGeneralCloseROver;
		if(_trackingMode==track_close_btn && _trackingHilite)icon=gHTTabBarGeneralClosePress;
        iconSize=[icon size];
        
        if([controlView isFlipped]) {
            iconRect.origin.y += iconSize.height;
        }		
			float alpha;
			if([[controlView window]styleMask]&NSTexturedBackgroundWindowMask){
				alpha=1.0;
			}else{
				alpha=0.66;
			}			
			[icon compositeToPoint:iconRect.origin operation:NSCompositeSourceOver fraction:alpha];
	}

	// calc size
	NSRect	pathRect;
	cellFrame.size.height-=6.5;
	cellFrame.origin.y+=3;

	pathRect.origin.x = cellFrame.origin.x + MARGIN_X+kPaddingLeft;
	if(iconSize.width > 0) {
		pathRect.origin.x += iconSize.width + MARGIN_X;
	}
	pathRect.size.width = cellFrame.size.width - (pathRect.origin.x - cellFrame.origin.x)-kPaddingRight;
	pathRect.size.height = cellFrame.size.height;
	pathRect.origin.y = cellFrame.origin.y+MARGIN_Y ;


	if(_isLoading){
		float   canvasWidth=pathRect.size.width-kHTTabBarIndicatorWidth-(kHTTabBarIndicatorRightMargin*2);
		if(_stringSize.width>=canvasWidth)
			pathRect.size.width=canvasWidth;
	}

	[self _drawLabelInRect:pathRect offScreen:NO];
}

-(void)_drawLabelInRect:(NSRect)aRect offScreen:(BOOL)flag
{
    // Draw text
	NSMutableAttributedString*  attrStr=[[[NSMutableAttributedString alloc]initWithAttributedString:
										[self attributedStringValue]]autorelease];
	if (attrStr) {
		NSRange range=NSMakeRange(0, [attrStr length]);

		// Add shadow attribute
        if ([self state] == NSOnState || [self isHighlighted]) {
            if ([[_keeperView window] styleMask] & NSTexturedBackgroundWindowMask) {
                NSShadow*   shadow;
                shadow = [[[NSShadow alloc] init] autorelease];
                [shadow setShadowColor:[NSColor colorWithCalibratedWhite:1.0 alpha:0.8]];
                [shadow setShadowOffset:NSMakeSize(0, -1)];
                [shadow setShadowBlurRadius:1.0];
                [attrStr addAttribute:NSShadowAttributeName value:shadow range:range];
            }
        }
        else {
            NSShadow*   shadow;
            shadow = [[[NSShadow alloc] init] autorelease];
            [shadow setShadowColor:[NSColor colorWithCalibratedWhite:0.1 alpha:0.25]];
            [shadow setShadowOffset:NSMakeSize(0, -1)];
            [shadow setShadowBlurRadius:1.0];
            [attrStr addAttribute:NSShadowAttributeName value:shadow range:range];
        }
        
		[attrStr drawInRect:aRect]; 
	}

}


-(NSImage*)dragImageForRect:(NSRect)cellFrame
{
	NSImage* resultImage=[[[NSImage alloc]initWithSize:cellFrame.size]autorelease];
	if(resultImage){
		cellFrame.origin=NSZeroPoint;
		[resultImage lockFocus];
		//draw frame
		[[NSColor colorWithCalibratedWhite:0.1 alpha:0.16]set];
		NSRectFillUsingOperation(cellFrame, NSCompositeSourceAtop);		
		NSRectFill(cellFrame);
		[[NSColor grayColor]set];
		NSFrameRect(cellFrame);
		
		//draw label
		cellFrame.origin.y+=MARGIN_Y;
		cellFrame.size.height = _stringSize.height;
		[self _drawLabelInRect:cellFrame offScreen:YES];

		[resultImage unlockFocus];
	}
	return resultImage;
	
}
#pragma mark -



- (void)setStringValue:(NSString *)aString
{
	NSMutableAttributedString*  attrStr;
	attrStr=[[[NSMutableAttributedString alloc]initWithString:aString] autorelease];
	NSRange range=NSMakeRange(0, [aString length]);

	// Add font attribute
	[attrStr addAttribute:NSFontAttributeName value:[NSFont systemFontOfSize:11.0]/*[self font]*/ range:range];
	[attrStr addAttribute:NSForegroundColorAttributeName value:[NSColor textColor] range:range];
	[attrStr addAttribute:NSParagraphStyleAttributeName value:gTruncatingTailParagraphStyle range:range];

	[self setAttributedStringValue:attrStr];
	_stringSize=[attrStr size];
}



-(float)stringWidth
{
	return _stringSize.width;
}

#pragma mark -- Tab view type --

+ (BOOL)supportTabViewType:(HTSRTabViewType)tabViewType
{
    return tabViewType == HTSRTopTabsBezelBorder;
}

@end

