/*
SRMainDocument.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

extern NSString*   SRCSSDocumentType;
extern NSString*   SRGIFDocumentType;
extern NSString*   SRHTMLDocumentType;
extern NSString*   SRHTMLNoExtensionDocumentType;
extern NSString*   SRJavaScriptDocumentType;
extern NSString*   SRJPEGDocumentType;
extern NSString*   SRJPEG2000DocumentType;
extern NSString*   SRTextDocumentType;
extern NSString*   SRPNGDocumentType;
extern NSString*   SRRTFDocumentType;
extern NSString*   SRTIFFDocumentType;
extern NSString*   SRURLDocumentType;
extern NSString*   SRWeblocDocumentType;
extern NSString*   SRWebArchiveDocumentType;
extern NSString*   SRICODocumentType;
extern NSString*   SRXHTMLDocumentType;
extern NSString*   SRXMLDocumentType;
extern NSString*   SRRSSDocumentType;
extern NSString*   SRRDFDocumentType;
extern NSString*   SRPDFDocumentType;

@class SRMainWindowController;

@interface SRMainDocument : NSDocument
{
    NSString*   _initialFileName;
    NSString*   _initialURLString;
    
    IBOutlet id _printController;
    IBOutlet id _content;
    
    IBOutlet id _printView;
}

- (void)makeWindowControllersWithInitialFrameName:(NSString*)frameName 
        groupName:(NSString*)groupName;

// Controller
- (SRMainWindowController*)mainWindowController;

// Accessors
- (NSView*)printAccessoryView;

@end

// Utility
NSArray* SRTextAndURLOfWeblocFile(
        NSString* weblocFile);
