/*
SRDOMFilter.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRDOMFilter.h"
#import "WebKitEx.h"

@implementation SRDOMRangeFilter

- (id)initWithDOMRange:(DOMRange*)range nodeName:(NSString*)nodeName
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Initialize member variables
    _range = [range retain];
    _nodeName = [nodeName retain];
    
    return self;
}

- (void)dealloc
{
    [_range release];
    [_nodeName release];
    
    [super dealloc];
}

- (short)acceptNode:(DOMNode*)node
{
    // Check node name
    if (![[node nodeName] isEqualToString:_nodeName]) {
        return DOM_FILTER_SKIP;
    }
    
    // Create DOM range
    DOMRange*   range;
    range = [[node ownerDocument] createRange];
    [range setStart:node :0];
    [range setEnd:node :0];
    
    // Compare boundary
    short   start, end;
    start = [_range compareBoundaryPoints:DOM_START_TO_START :range];
    end = [_range compareBoundaryPoints:DOM_END_TO_END :range];
//NSLog(@"start %d end %d", start, end);
    
    return start >= 0 || end >= 0 ? DOM_FILTER_ACCEPT  : DOM_FILTER_SKIP;
}

@end
