/*
SRDefaultsKey.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Main document
extern NSString*    SRMainDocumentPrintBackground;

// Main window
extern NSString*    SRMainWindowContentSize;
extern NSString*    SRMainWindowFrameOrigin;
extern NSString*    SRMainWindowBookmarksBarVisible;
extern NSString*    SRMainWindowStatusBarVisible;
extern NSString*    SRMainWindowSidebarVisible;
extern NSString*    SRMainWindowSidebarSelectedTab;

extern NSString*    SRSaveFileFormat;

extern NSString*    SRToolbarUseSmallURLAndSearchField;

// Drawer
extern NSString*    SRSideBarDrawerSize;
extern NSString*    SRSideBarDownloadUpperViewHeight;

// Download
extern NSString*    SRDownloadPanelFrame;

// Browse mode
extern NSString*    SRBrowseMode;
enum {
    SRDefaultBrowseMode = 0, 
    SRAlwaysInSameTabBrowseMode, 
    SRAlwaysInNewTabBrowseMode, 
    SRAlwaysInNewBackgroundTabBrowseMode, 
    SRNumberOfBrowseMode, 
};

// Search field
extern NSString*    SRSearchFieldWidth;

// Preferences
extern NSString*    SRPreferencesPanelFrame;
extern NSString*    SRSelectedPreferencesItem;

extern NSString*    SRGeneralNewWindowsOpenWith;
extern NSString*    SRGeneralHomePgae;
extern NSString*    SRGeneralDownloadPath;
extern NSString*    SRDownloadInDateSubDirEnabled;
enum {
    SRGeneralNewWindowsOpenWithHomePage = 0, 
    SRGeneralNewWindowsOpenWithEmptyPage, 
    SRGeneralNewWindowsOpenWithSamePage, 
};
extern NSString*    SRDownloadNotification;
enum {
    SRDownloadNotificationSideBar = 0, 
    SRDownloadNotificationInfoCenter, 
};
extern NSString*    SRDownloadItemRemove;
enum {
    SRDownloadItemRemoveByHand = 0, 
    SRDownloadItemRemoveAtTremination, 
    SRDownloadItemRemoveAutomatically
};
extern NSString*    SRInfoCenterAlwaysDisply;
extern NSString*    SRGeneralTimeout;
extern NSString*    SRGeneralOneClickNavigation;

extern NSString*    SRProtocolLibrary;
enum {
    SRProtocolLibraryWebKit = 0, 
    SRProtocolLibraryCURL, 
};

extern NSString*    SRUsePageTransitionEffect;
extern NSString*    SRDefaultTextEncoding;

extern NSString*    SRBookmarkBookmarksBar;
extern NSString*    SRBookmarkIsUsing;

extern NSString*    SRTabEnableTabbedBrowsing;
extern NSString*    SRTabSelectNewTabs;
extern NSString*    SRTabAlwaysShowTabBar;
extern NSString*    SRTabAccordingToStringWidth;
extern NSString*    SRTabDefaultWidth;
extern NSString*    SRTabMinWidth;
extern NSString*    SRTabStyleClassName;
extern NSString*    SRTabTargetLinkUseTab;
extern NSString*    SRTabOpenURLUseTab;
extern NSString*    SRTabSelectionLogic;
enum {
    SRTabSelectionPreviousTab = 0, 
    SRTabSelectionRightTab, 
};
extern NSString*    SRTabShowAllTabsShortcut;

extern NSString*    SRCookieRemoveAtTermination;
extern NSString*    SRSecurityAllowAllURLSchemes;
extern NSString*    SREnableJavaScirptStatusMessage;
extern NSString*    SREnableJavaScriptDialogAlert;

extern NSString*    SRCacheRemoveAtTermination;
extern NSString*    SRCacheShowAdvancedSettings;
extern NSString*    SRCacheMemoryCapacity;
extern NSString*    SRCacheDiskCapacity;

extern NSString*    SRSearchEngineDefaultTitle;
extern NSString*    SRSearchEngineRecents;
extern NSString*    SRSearchEngineRecentsLimit; //int

extern NSString*    SRUserAgent;
enum {
    SRUserAgentShiira = 0, 
    SRUserAgentOther = 999, 
};
extern NSString*    SRUserAgentShiiraName;
extern NSString*    SRUserAgentOtherIsUging;
extern NSString*    SRUserAgentOtherName;

extern NSString*    SRIconTexture;
enum {
    SRIconTextureAqua = 0, 
    SRIconTextureMetal, 
};
extern NSString*    SRIconName;
extern NSString*    SRIconUseFavicon;
extern NSString*    SRIconUseFaviconBookmarkMenu;
extern NSString*    SRIconUseFaviconBookmarkBar;
extern NSString*    SRIconUseFaviconSearchEngine;
extern NSString*    SRIconUseFaviconSideBar;

extern NSString*    SRSidebarEdge;
enum {
    SRSidebarEdgeLeft = 0, 
    SRSidebarEdgeRight, 
};
extern NSString*    SRSidebarPreferredEdge;
extern NSString*    SRSidebarAutoresize;
extern NSString*    SRSidebarClick;
enum {
    SRSidebarSingleClick = 0, 
    SRSidebarDoubleClick, 
};

extern NSString*    SRSourceFontName;
extern NSString*    SRSourceFontSize;
extern NSString*    SRSourceDefaultColor;
extern NSString*    SRSourceBackgroundColor;
extern NSString*    SRSourceTagColor;
extern NSString*    SRSourceCommentColor;
