/*
SRBookmarkStorage.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Notification name
extern NSString*    SRBookmarkAddedNotificationName;
extern NSString*    SRBookmarkRemovedNotificationName;
extern NSString*    SRBookmarkChangedNotificationName;

// Pasteboard data type
extern NSString*    SRBookmarkPboardType;

@class SRBookmark;

@interface SRBookmarkStorage : NSObject
{
    SRBookmark*             _rootBookmark;
    
    // Only _shiiraBookmarks is retained
    SRBookmark*             _shiiraBookmarks;
    SRBookmark*             _shiiraBookmarksBar;
    
    // Only _safariBookmarks is retained
    SRBookmark*             _safariBookmarks;
    SRBookmark*             _safariBookmarksBar;
    SRBookmark*             _safariBookmarksMenu;
    
    // Only _firefoxBookmarks is retained
    BOOL                    _hasFirefoxBookmark;
    WebView*                _firefoxBoookmarkWebView;
    SRBookmark*             _firefoxBookmarks;
    SRBookmark*             _firefoxBookmarksBar;

    // Only _ieBookmarks is retained
    BOOL                    _hasIEBookmark;
    WebView*                _ieBoookmarkWebView;
    SRBookmark*             _ieBookmarks;
    SRBookmark*             _ieBookmarksBar;
    SRBookmark*             _ieBookmarksMenu;
    
    BOOL                    _notifyFlag;
}

// Accessing to instance
+ (id)sharedInstance;

// Loading bookmark
- (void)reloadBookmarksOfBrowser:(int)browser;
- (void)reloadBookmarksOfAllBrowsers;
- (BOOL)saveShiiraBookmarksToURL:(NSURL*)URL error:(NSError**)error;

// Accessing to bookmark
- (SRBookmark*)rootBookmark;
- (BOOL)hasBookmarkOfBrowser:(int)browser;
- (SRBookmark*)shiiraBookmarksBar;
- (NSArray*)shiiraBookmarksMenu;
- (SRBookmark*)safariBookmarksBar;
- (SRBookmark*)safariBookmarksMenu;
- (SRBookmark*)firefoxBookmarks;
- (SRBookmark*)firefoxBookmarksBar;
- (SRBookmark*)ieBookmarksBar;
- (SRBookmark*)ieBookmarksMenu;
- (NSMenu*)bookmarkFolderMenu;

- (SRBookmark*)parentOfBookmark:(SRBookmark*)bookmark 
        fromRoot:(SRBookmark*)rootBookmark;
- (SRBookmark*)parentOfBookmark:(SRBookmark*)bookmark;

// Find bookmark
- (NSArray*)findBookmarkWithString:(NSString*)findString;

// Notification
- (BOOL)notifyFlag;
- (void)setNotifyFlag:(BOOL)flag;
- (void)notifyBookmarkUpdated:(NSNotification*)notification;

@end

// Utility
NSMenu* SRCreateBookmarkMenu(
        SRBookmark* bookmark, 
        BOOL isExpandChild, 
        BOOL isFaviconAvailable);
NSMenu* SRCreateBookmarkMenuFromArray(
        NSArray* bookmarks, 
        BOOL isExpandChild, 
        BOOL isFaviconAvailable);
NSMenu* SRCreateHistoryMenu(
        NSArray* historyItems, 
        BOOL reverse);

void SRWriteBookmarksToPasteboard(
        NSArray* bookmarks, 
        NSPasteboard* pboard);
void SRWriteWebHistoryItemsToPasteboard(
        NSArray* historyItems, 
        NSPasteboard* pboard);
NSArray* SRReadBookmarksFromPasteboard(
        NSPasteboard* pboard);
