/*
SRBookmark.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Bookmakr types
enum {
    SRBookmarkTypeHTML = 0, 
    SRBookmarkTypeFolder, 
    SRBookmarkTypeBookmarksBar, 
    SRBookmarkTypeBookmarksMenu, 
};

// Browser
enum {
    SRBrowserShiira = 0, 
    SRBrowserSafari = 1, 
    SRBrowserFirefox = 2, 
    SRBrowserCamino = 3, 
    SRBrowserIE = 4, 
    SRBrowserOmniWeb = 5, 
    SRBrowserOpera = 6, 
    SRBrowserICab = 7, 
    
    SRNumberOfBrowser = 8
};

extern NSArray* SRBrowserNames;

@interface SRBookmark : NSObject <NSCoding>
{
    NSMutableDictionary*    _infoDict;
}

// Initialize
+ (SRBookmark*)bookmarkWithTitle:(NSString*)title 
        URLString:(NSString*)URLString 
        originalBrowser:(int)originalBrowser;
+ (SRBookmark*)folderWithTitle:(NSString*)title 
        originalBrowser:(int)originalBrowser;
+ (SRBookmark*)bookmarkWithBookmark:(SRBookmark*)bookmark;
+ (SRBookmark*)bookmarkWithBookmark:(SRBookmark*)bookmark deep:(BOOL)flag;
+ (SRBookmark*)bookmarkWithBookmark:(SRBookmark*)bookmark deep:(BOOL)flag browser:(int)browser;
+ (SRBookmark*)bookmarksBar;

- (id)initWithType:(int)type 
        URLString:(NSString*)URLString 
        isMutable:(BOOL)isMutable 
        originalBrowser:(int)originalBrowser;

// Bookmark attributes
- (int)type;
- (BOOL)isFolderType;

- (NSString*)title;
- (void)setTitle:(NSString*)title;

- (NSString*)URLString;
- (void)setURLString:(NSString*)URLString;

- (NSImage*)icon;
- (NSString*)iconURLString;
- (void)setIconURLString:(NSString*)URLString;

- (int)originalBrowser;
- (void)setOriginalBrowser:(int)browser;
- (BOOL)isShiiraBookmark;
- (void)makeItShiira;
- (void)makeItOriginalBrowser:(int)browser;

- (BOOL)isMutable;
- (void)setMutable:(BOOL)isMutable;

- (BOOL)isAutoTab;
- (void)setAutoTab:(BOOL)isAutoTab;

- (NSString*)UUID;
- (void)setUUID:(NSString*)UUID;

- (void)update;

// Handling hierarchy
- (NSArray*)children;
- (void)addChild:(SRBookmark*)child;
- (void)addChildren:(NSArray*)children;
- (void)insertChild:(SRBookmark*)child atIndex:(int)index;
- (void)insertChildren:(NSArray*)children atIndex:(int)index;
- (void)removeChild:(SRBookmark*)child;
- (void)removeChildAtIndex:(int)index;
- (void)removeChildren:(NSArray*)children;
- (void)removeAllChildren;

// Dragging
- (NSImage*)draggingImage;

@end
