/*
FoundationEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Foundation/Foundation.h>
#import "SRError.h"

@interface NSArray (Recursively)
- (unsigned)indexOfObjectRecursively:(id)object;
- (unsigned)indexOfObjectRecursivelyIdenticalTo:(id)object;
@end

@interface NSCharacterSet (NewLine)
+ (NSCharacterSet*)newLineCharacterSet;
@end

@interface NSDate (ReverseComparison)
- (NSComparisonResult)reverseCompare:(NSDate*)anotherDate;
@end

@interface NSFileManager (UniqueFilePath)
- (NSString*)makeUniqueFilePath:(NSString*)filePath;
@end

@interface NSMutableArray (DeepCopy)
- (id)initWithArray:(NSArray*)otherArray copyItemsDeeply:(BOOL)flag;

- (void)insertObjectsFromArray:(NSArray*)otherArray atIndex:(unsigned)index;
@end

@interface NSMutableArray (Recursively)
- (void)removeObjectRecursively:(id)object;
- (void)removeObjectRecursivelyIdenticalTo:(id)object;
- (void)removeObjectsFromArrayRecursively:(NSArray*)otherArray;
- (void)removeObjectsFromArrayRecursivelyIdenticalTo:(NSArray*)otherArray;
@end

@interface NSMutableDictionary (DeepCopy)
- (id)initWithDictionary:(NSDictionary*)otherDict copyItemsDeeply:(BOOL)flag;
@end

@interface NSURLDownload (ResumeExtention)
// These are hidden APIs
- (id)_initWithResumeInformation:(id)resumeInfo delegate:(id)delegate path:(id)path;
- (id)_resumeInformation;

- (void)_setDeletesFileAfterFailure:(BOOL)flag;
- (BOOL)_deletesFileAfterFailure;

@end

@interface NSURLRequest (CertificateAllowing)
+ (BOOL)allowsAnyHTTPSCertificateForHost:(NSString*)host;
+ (void)setAllowsAnyHTTPSCertificate:(BOOL)flag forHost:(NSString*)host;
@end

@interface NSHTTPURLResponse (Accessors)
+ (BOOL)isErrorStatusCode:(int)fp8;
- (void)setStatusCode:(int)fp8;
- (void)setAllHeaderFields:(id)fp8;

- (void)_parseCacheControl;
- (id)_createdDate;
- (id)_expiresDate;
- (id)_lastModifiedDate;
- (id)_maxAge;
- (id)_ageHeaderValue;
- (double)_freshnessLifetime;
- (BOOL)_mustRevalidate;
@end
