/*
SRMainWindowController.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

typedef enum _SROpenActionType {
    SROpenAction, 
    SROpenInNewTabAction, 
    SROpenInNewBackgroundTabAction, 
    SROpenInNewWindowAction, 
    SROpenInNewBackgroundWindowAction, 
    SROpenOptionAction, 
} SROpenActionType;

// Toolbar item identifier
extern NSString*   SRGoBackIdentifier;
extern NSString*   SRGoForwardIdentifier;
extern NSString*   SRReloadPageIdentifier;
extern NSString*   SRStopLoadingIdentifier;
extern NSString*   SRGoHomeIdentifier;
extern NSString*   SRURLIdentifier;
extern NSString*   SRSidebarIdentifier;
extern NSString*   SRHideSidebarIdentifier;
extern NSString*   SRBookmarkPageIdentifier;
extern NSString*   SRNewTabIdentifier;
extern NSString*   SRCloseTabIdentifier;
extern NSString*   SRBiggerTextIdentifier;
extern NSString*   SRSmallerTextIdentifier;
extern NSString*   SRCustomizeIdentifier;
extern NSString*   SRSearchIdentifier;

// Key path
extern NSString*    SRMainWebViewTitle;
extern NSString*    SRMainWebViewURLString;
extern NSString*    SRMainWebViewIsLoading;
extern NSString*    SRMainWebViewIsIndeterminate;
extern NSString*    SRMainWebViewEstimatedProgress;
extern NSString*    SRMainWebViewStatus;
extern NSString*    SRMainWebViewIsSecured;

// Notifications
extern NSString*    SRMainWindowGoToHistotyItem;
extern NSString*    SRMainWindowSelectedWebViewChanged;
extern NSString*    SRMainWindowDidChangeLocationWithinPage;
extern NSString*    SRMainWindowDidBecomeMain;
extern NSString*    SRMainWindowDidResignMain;
extern NSString*    SRMainWindowWillClose;

// URL location
extern int          SRURLMinWidth;
extern int          SRURLMaxWidth;

// Search field
extern int          SRSearchMinWidth;
extern int          SRSearchMaxWidth;

@class SRMainDocument;
@class SRSourceWindowController;
@class SRSideBarController;
@class SRAuthenticationController;
@class SRSearchFieldController;
@class SRTabExposeController;
@class SRBookmark;
@class SRURLComboBox;
@class SRTabView;
@class SRSearchField;

@interface SRMainWindowController : NSWindowController
{
    SRSideBarController*            _sideBarController;
    SRAuthenticationController*     _authController;
    SRSearchFieldController*        _searchFieldController;
    NSImageView*                    _lockIconView;
    SRTabExposeController*          _tabExposeController;
    
    int                             _bookmarksBarBrowser;
    BOOL                            _isResizedByJavaScript;
    BOOL                            _isInitializedSidebarVisibility;
    
    // Cocoa bindings properties
    NSString*   _webViewTitle;
    NSString*   _webViewURLString;
    BOOL        _webViewIsIndeterminate;
    BOOL        _webViewIsLoading;
    double      _webViewEstimatedProgress;
    NSString*   _webViewStatus;
    BOOL        _webViewIsSecured;
    
    // Interface Builder outlets
    IBOutlet id _bookmarksBarView;
    IBOutlet id _parentView;
    IBOutlet id _srTabView;
    IBOutlet id _statusBox;
    IBOutlet id _webViewController;
    
    IBOutlet id _addBookmarkPanel;
    IBOutlet id _addBookmarkTextField;
    IBOutlet id _addBookmarkPopup;
    
    IBOutlet id _bookmarkAllPanel;
    IBOutlet id _bookmarkAllPopup;
    
    IBOutlet id _newFolderPanel;
    IBOutlet id _newFolderTextField;
    
    IBOutlet id _addToBarPanel;
    IBOutlet id _addToBarTextField;
    
    IBOutlet id _locationPanel;
    IBOutlet id _locationURLView;
    
    IBOutlet id _searchPanel;
    IBOutlet id _searchFieldView;
}

// Initialize
- (id)initWithWindowNibName:(NSString*)nibName 
        initialFrameName:(NSString*)frameName 
        initialGroupName:(NSString*)groupName;

// Controller
- (SRSideBarController*)sideBarController;

// Outlets
- (id)addBookmarkPanel;
- (id)addBookmarkTextField;
- (id)addBookmarkPopup;
- (id)bookmarkAllPanel;
- (id)bookmarkAllPopup;
- (id)newFolderPanel;
- (id)newFolderTextField;
- (id)addToBarPanel;
- (id)addToBarTextField;
- (id)locationPanel;
- (id)locationURLView;
- (id)searchPanel;
- (id)searchFieldView;

// Web view and toolbar items
- (WebView*)selectedWebView;
- (SRURLComboBox*)URLComboBox;
- (SRURLComboBox*)URLComboBoxOnSheet;
- (SRSearchField*)searchField;
- (SRSearchField*)searchFieldOnSheet;

// Tab management
- (SRTabView*)srTabView;
- (WebView*)addNewTabWithLabel:(NSString*)label 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName;
- (WebView*)addNewTabWithLabel:(NSString*)label 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName 
        select:(BOOL)select;
- (void)selectLeftTab;
- (void)selectRightTab;

// Opening page
- (NSURLRequest*)createRequestWithURL:(NSURL*)url;
- (NSURLRequest*)createRequestWithURLString:(NSString*)URLString;
- (WebView*)openRequest:(NSURLRequest*)request;
- (WebView*)openRequest:(NSURLRequest*)request atIndex:(int)index;
- (id)openRequest:(NSURLRequest*)request 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName 
        withOpenAction:(SROpenActionType)openAction;
- (WebView*)openInNewTabRequest:(NSURLRequest*)request 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName;
- (WebView*)openInNewTabRequest:(NSURLRequest*)request 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName 
        select:(BOOL)select;
- (SRMainDocument*)openInNewWindowRequest:(NSURLRequest*)request 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName;
- (SRMainDocument*)openInNewBackgroundWindowRequest:(NSURLRequest*)request 
        frameName:(NSString*)frameName 
        groupName:(NSString*)groupName;

- (WebView*)openURLString:(NSString*)URLString;
- (WebView*)openURLString:(NSString*)URLString atIndex:(int)index;
- (id)openURLString:(NSString*)URLString withOpenAction:(SROpenActionType)openAction;
- (WebView*)openInNewTabURLString:(NSString*)URLString;
- (WebView*)openInNewTabURLString:(NSString*)URLString select:(BOOL)select;
- (SRMainDocument*)openInNewWindowURLString:(NSString*)URLString;
- (SRMainDocument*)openInNewBackgroundWindowURLString:(NSString*)URLString;

- (WebView*)openURL:(NSURL*)url;
- (WebView*)openURL:(NSURL*)url atIndex:(int)index;
- (id)openURL:(NSURL*)url withOpenAction:(SROpenActionType)openAction;
- (WebView*)openInNewTabURL:(NSURL*)url;
- (WebView*)openInNewTabURL:(NSURL*)url select:(BOOL)select;
- (SRMainDocument*)openInNewWindowURL:(NSURL*)url;
- (SRMainDocument*)openInNewBackgroundWindowURL:(NSURL*)url;

- (WebView*)openBookmark:(SRBookmark*)bookmark;
- (WebView*)openBookmark:(SRBookmark*)bookmark atIndex:(int)index;
- (id)openBookmark:(SRBookmark*)bookmark withOpenAction:(SROpenActionType)openAction;
- (WebView*)openInNewTabBookmark:(SRBookmark*)bookmark;
- (WebView*)openInNewTabBookmark:(SRBookmark*)bookmark select:(BOOL)select;
- (SRMainDocument*)openInNewWindowBookmark:(SRBookmark*)bookmark;
- (SRMainDocument*)openInNewBackgroundWindowBookmark:(SRBookmark*)bookmark;
- (NSArray*)openInTabsBookmark:(SRBookmark*)bookmark;
- (NSArray*)openInTabsBookmarks:(NSArray*)bookmarks;

- (WebView*)openHistory:(WebHistoryItem*)historyItem;
- (WebView*)openHistory:(WebHistoryItem*)historyItem atIndex:(int)index;
- (WebView*)openHistory:(WebHistoryItem*)historyItem withOpenAction:(SROpenActionType)openAction;
- (WebView*)openInNewTabHistory:(WebHistoryItem*)historyItem;
- (WebView*)openInNewTabHistory:(WebHistoryItem*)historyItem select:(BOOL)select;
- (SRMainDocument*)openInNewWindowHistory:(WebHistoryItem*)historyItem;
- (SRMainDocument*)openInNewBackgroundWindowHistory:(WebHistoryItem*)historyItem;
- (NSArray*)openInTabsHistory:(NSArray*)historyItems;

- (BOOL)reloadURLIfExists:(NSURL*)URL;

// Appearnace
- (BOOL)isBookmarksBarVisible;
- (void)setBookmarksBarVisible:(BOOL)isVisible display:(BOOL)display;
- (BOOL)isStatusBarVisible;
- (void)setStatusBarVisible:(BOOL)isVisible display:(BOOL)display;
- (BOOL)isTabVisible;
- (void)setTabVisible:(BOOL)isVisible display:(BOOL)display;
- (BOOL)isSidebarVisible;
- (void)setSidebarVisible:(BOOL)isVisible;
- (BOOL)isResizedByJavaScript;

// Supported schemes
- (BOOL)isSchemeSupported:(NSString *)scheme;

// Bookmarks bar
- (void)setBookmarksBarBrowser:(int)browser;

// User agent
- (void)setUserAgent:(int)userAgent;

// Icon and texture
- (void)setTexture:(int)texture;

// Authentication
- (SRAuthenticationController*)authenticationController;
@end

@interface SRMainWindowController (Action)

// Actions
- (void)setTextEncodingAction:(id)sender;

- (void)goBackAction:(id)sender;
- (void)goForwardAction:(id)sender;
- (void)goHomeAction:(id)sender;
- (void)showHistoryInSidebarAction:(id)sender;
- (void)openHistoryItemAction:(id)sender;

- (void)addToBookmarkAction:(id)sender;
- (void)closeAddBookmarkSheetAction:(id)sender;
- (void)showBookmarkInSidebarAction:(id)sender;

- (void)takeStringURLFromAction:(id)sender;
- (void)toggleSidebarAction:(id)sender;
- (void)newTabAction:(id)sender;
- (void)closeWindowAction:(id)sender;
- (void)closeTabAction:(id)sender;
- (void)addToBookmarksBarAction:(id)sender;
- (void)closeAddToBarSheetAction:(id)sender;

- (void)previousTabAction:(id)sender;
- (void)nextTabAction:(id)sender;

- (void)openBookmarkBarAtAction:(id)sender;

- (void)openHistoryAction:(id)sender;
- (void)openHistoryInNewWindowAction:(id)sender;
- (void)openHistoryInNewTabAction:(id)sender;
- (void)openHistoryInTabsAction:(id)sender;
- (void)openHistoryInNewBackgroundWindowAction:(id)sender;
- (void)openHistoryInNewBackgroundTabAction:(id)sender;

- (void)URLComboBoxAction:(id)sender;

@end

@interface SRMainWindowController (WebViewDelegateMethods)

// Error
- (void)showAlertWithError:(NSError*)error forFrame:(WebFrame*)frame;

@end

// Utitlity
SROpenActionType SROpenActionTypeFromModifierFlags(
        unsigned modifierFlags);
