/*
SRAppDelegate.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Application menu tags
enum {
    SRShiiraTag = 100, 
    
    SRAboutShiiraTag = 101, 
    
    SRPreferencesTag = 110, 
    
    SRHideShiiraTag = 120, 
    SRHideOthersTag = 121, 
    SRShowAllTag = 122, 
    
    SRQuitShiiraTag = 130, 
};

// File menu tags
enum {
    SRFileTag = 200, 
    
    SRNewWindowTag = 201, 
    SRNewTabTag = 202, 
    SROpenFileTag = 203, 
    SROpenLocationTag = 204, 
    
    SRCloseWindowTag = 210, 
    SRCloseTabTag = 211, 
    
    SRSaveAsTag = 220, 
    
    SRPageSetupTag = 230, 
    SRPrintTag = 231, 
    SRPrintAPDFTag = 232, 
};

// Edit menu tags
enum {
    SREditTag = 300, 
    
    SRUndoTag = 301, 
    SRRedoTag = 302, 
    
    SRCutTag = 310, 
    SRCopyTag = 311, 
    SRPasteTag = 312, 
    SRDeleteTag = 313, 
    SRSelectAllTag = 314, 
    
    SRFindTag = 320, 
    SRFindNextTag = 321, 
    SRFindPreviousTag = 322, 
    SRUseSelectionForFindTag = 323, 
    SRJumpToSelectionTag = 324, 
    SRFindByToolbarTag = 325, 
    
    SRSpecialCharactersTag = 330, 
};

// View menu tags
enum {
    SRViewTag = 400, 
    
    SRToolbarTag = 401, 
    SRBookmarksBarTag = 402, 
    SRStatusBarTag = 403, 
    SRSidebarTag = 404, 
    
    SRCustomizeToolbarTag = 410, 
    
    SRStopLoadingTag = 420, 
    SRReloadPageTag = 421, 
    SRBiggerTextTag = 422, 
    SRSmallerTextTag = 423, 
    
    SRViewPageSourceTag = 430, 
    
    SRTextEncodingTag = 440, 
    SRTextEncodingDefaultTag = 441, 
    
    SROpenURLWithTag = 450, 
    SROpenURLWithBrowserItemTag = 451, 
    
    SRDefaultBrowsingTag = 460, 
    SRAlwaysInSameTabTag = 461, 
    SRAlwaysInNewTabTag = 462, 
    SRAlwaysInNewBackgroundTabTag = 463, 
};

// History menu tags
enum {
    SRHistoryTag = 500, 
    
    SRBackTag = 501, 
    SRForwardTag = 502, 
    SRHomeTag = 503, 
    
    SRShowHistoryInSidebarTag = 510, 
    
    SRHistoryBeginTag = 520, 
    SRHistoryItemTag = 521, 
    
    SRClearHistoryTag = 530, 
};

// Bookmark menu tags
enum {
    SRBookmarkTag = 600, 
    
    SRAddToBookmarkTag = 601, 
    SRAddBookmarkFolderTag = 602, 
    SRBookmarkAllTabsTag = 603, 
    
    SRShowBookmarkInSidebarTag = 610, 
    
    SRBookmarkBeginTag = 620, 
};

// Window menu tags
enum {
    SRWindowTag = 700, 
    
    SRZoomTag = 701, 
    SRMinimizeTag = 702, 
    
    SRPreviousTabTag = 710, 
    SRNextTabTag = 711, 
    SRShowAllTabsTag = 712, 
    
    SRDownloadsTag = 720, 
    SRCacheTag = 721, 
    SRSearchEnginesTag = 722, 
    SRShowInfoCenterTag = 723, 
    SRDownloadsPanelTag = 724, 
    
    SRBringAllToFronTag = 730, 
};

// Setting file names
extern NSString*    SRShiiraDirectory;
extern NSString*    SRHistoryFileName;
extern NSString*    SRBookmarksFileName;
extern NSString*    SRSerachnEnginesFileName;
extern NSString*    SRDownloadsFileName;

// For Growl support
#ifdef SR_SUPPORT_GROWL
extern NSString*    SRGrowlDownloadCompletedNotification;
#endif // SR_SUPPORT_GROWL

@class SRFindWindowController;
@class SRPreferencesController;
@class SRSearchEnginesController;
@class SRDownloadsController;
@class SRCacheController;
@class SRIconInstaller;
@class SRAboutController;

@interface SRHistoryMenuCreator : NSObject
{
}
@end

@interface SRBookmarkMenuCreator : NSObject
{
}
@end

@interface SRAppDelegate : NSObject
{
    // Contollers
    SRFindWindowController*     _findWindowController;
    SRPreferencesController*    _preferencesController;
    SRDownloadsController*      _downloadsController;
    SRSearchEnginesController*  _searchEnginesController;
    SRCacheController*          _cacheController;
    SRIconInstaller*            _iconInstaller;
    SRAboutController*          _aboutController;
    
    // Periodic update
    SRHistoryMenuCreator*       _historyMenuCreator;
    SRBookmarkMenuCreator*      _bookmarkMenuCreator;
    
    // Properties
    WebView*                    _selectedWebView;
}

// Preferences
- (SRPreferencesController*)preferencesController;

// Menu
+ (NSMenu*)fileMenu;
+ (NSMenu*)editMenu;
+ (NSMenu*)viewMenu;
+ (NSMenu*)browserMenu;
+ (NSMenu*)textEncodingMenu;
+ (NSMenu*)historyMenu;
+ (NSMenu*)bookmarkMenu;
+ (NSMenu*)windowMenu;

// Text encoding menu
- (void)updateTextEncodingMenu;

// Application support folder
- (NSString*)libraryFolder;
- (NSString*)applicationSupportFolder;

// Bookmark menu
- (void)saveBookmarks;
- (void)updateBookmarkMenu;

// History menu
- (void)loadHistory;
- (void)saveHistory;
- (void)updateHistoryMenu;

// Browser menu
- (void)updateBrowserMenu;

// Search engines
- (SRSearchEnginesController*)searchEnginesController;

// Find panel
- (SRFindWindowController*)findWindowController;

// Downloads
- (void)loadDownloadHistory;
- (void)saveDownloadHistory;
- (SRDownloadsController*)downloadsController;

// Icons
- (void)loadIcons;
- (void)saveIcons;

// Cache
- (SRCacheController*)cacheController;

// Icon installer
- (SRIconInstaller*)iconInstaller;

// Protocol library
- (void)updateProtocolLibary;

// Actions
- (IBAction)findAction:(id)sender;
- (IBAction)findNextAction:(id)sender;
- (IBAction)findPreviousAction:(id)sender;
- (IBAction)useSelectionForFindAction:(id)sender;

- (IBAction)setBrowseModeAction:(id)sender;
- (IBAction)clearHistoryAction:(id)sender;

- (IBAction)showPreferencesAction:(id)sender;
- (IBAction)showDownloadsPanelAction:(id)sender;
- (IBAction)showSearchEnginesAction:(id)sender;
- (IBAction)showCacheAction:(id)sender;
- (IBAction)showDebugAction:(id)sender;

- (IBAction)openBookmarkAction:(id)sender;

// OpenURL
- (void)openURL:(NSAppleEventDescriptor*)event
        withReplyEvent:(NSAppleEventDescriptor*)replyEvent;
- (void)_openURL:(NSURL*)URL;

// With other browsers
- (NSArray*)browserURLsWithShiira:(BOOL)flag;
- (NSArray*)browserMenuItemsWithShiira:(BOOL)flag action:(SEL)action;

@end

// Utitlity
NSString* SRAlternateTitleOfWebHistoryItem(
        WebHistoryItem* historyItem);
