/*
NSToolbarViewEx.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "NSToolbarViewEx.h"

@implementation NSToolbarViewEx

+ (void)load
{
    [self poseAsClass:[NSToolbarView class]];
}

- (NSMenu*)menuForEvent:(NSEvent*)event
{
    NSUserDefaults* defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    
    NSMenu* menu;
    menu = [super menuForEvent:event];
    
    id<NSMenuItem>  item;
    
    // Check toolbar display mode
    NSToolbarDisplayMode    displayMode;
    displayMode = [_toolbar displayMode];
    if (displayMode != 0) {
        item = [menu itemWithTag:displayMode];
        if (item && [item state] != NSOnState) {
            [item setState:NSOnState];
        }
    }
    
    // Check toolbar size mode
    NSToolbarSizeMode   sizeMode;
    sizeMode = [_toolbar sizeMode];
    if (sizeMode == NSToolbarSizeModeSmall) {
        item = [menu itemAtIndex:4]; // Menu item for size mode
        if (item && [item state] != NSOnState) {
            [item setState:NSOnState];
        }
    }
    
#if 0
    // For main window toolbar
    if ([[_toolbar identifier] isEqualToString:@"SRMainWindowToolbarIdentifier"]) {
        // Add 'Use small URL and search field'
        [menu addItem:[NSMenuItem separatorItem]];
        
        item = [[NSMenuItem alloc] initWithTitle:NSLocalizedString(@"Use small URL and search field", nil) 
                action:@selector(toggleSmallURLAndSearchFieldAction:) 
                keyEquivalent:@""];
        [item autorelease];
        [item setTarget:[_toolbar delegate]];
        
        if ([defaults boolForKey:SRToolbarUseSmallURLAndSearchField]) {
            [item setState:NSOnState];
        }
        
        [menu addItem:item];
    }
#endif
    
    return menu;
}

@end
