/*
Shiira.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef SR_SUPPORT_GROWL
#define SR_SUPPORT_GROWL
#endif

#import "SRError.h"
#import "SRUtil.h"

#import "SRAppDelegate.h"
#import "SRDocumentController.h"
#import "SRMainDocument.h"
#import "SRMainWindowController.h"
#import "SRSideBarController.h"
#import "SRSourceWindowController.h"
#import "SRFindWindowController.h"
#import "SRPreferencesController.h"
#import "SRDownloadsController.h"
#import "SRDownloadViewController.h"
#import "SRCacheController.h"
#import "SRSearchEnginesController.h"
#import "SRSearchFieldController.h"
#import "SRAuthenticationController.h"
#import "SRInfoCenterController.h"
#import "SRDebugWindowController.h"
#import "SRDownloadCenter.h"
#import "SRIconInstaller.h"
#import "SRTabExpose.h"
#import "SRAboutController.h"

#import "SRSBBookmarksController.h"
#import "SRSBHistoryController.h"
#import "SRSBDownloadController.h"

#import "SRBookmark.h"
#import "SRBookmarkStorage.h"
#import "SRDefaultsKey.h"
#import "SRURLAutoComplete.h"
#import "SRDownloadHistory.h"
#import "SRDownloadHistoryItem.h"
#import "SRBookmarkIconDatabase.h"

#import "SRContextMenu.h"
#import "SRMainWindow.h"
#import "SREncodings.h"
#import "SRView.h"
#import "SRMenu.h"
#import "SRTabView.h"
#import "HTSRTabBarView.h"
#import "SRTableView.h"
#import "SROutlineView.h"
#import "SRImageTextCell.h"
#import "SRURLComboBox.h"
#import "SRURLComboBoxCell.h"
#import "SRBookmarkButton.h"
#import "SRBookmarkButtonCell.h"
#import "SRBookmarksBarView.h"
#import "SRDownloadStatusCell.h"
#import "SRTextInputPanelManager.h"
#import "SRPredictEncoding.h"
#import "SRAutoFadePanel.h"
#import "SRHalfTransparentButton.h"
#import "SRProgressIndicator.h"
#import "SRSearchField.h"
#import "SRAnimation.h"

#import "NSCellEx.h"
#import "NSTableViewEx.h"
#import "NSOutlineViewEx.h"
#import "NSWindowEx.h"
#import "NSTextViewEx.h"
#import "NSToolbarEx.h"
#import "NSToolbarItemViewerEx.h"
#import "NSAttributedStringEx.h"
#import "NSDateEx.h"
#import "NSArrayEx.h"
#import "NSDictionaryEx.h"
#import "NSFileManagerEx.h"
#import "NSCharacterSetEx.h"
#import "NSURLRequestEx.h"
#import "NSURLResponseEx.h"
#import "NSURLConnectionEx.h"
#import "NSURLDownloadEx.h"
#import "SRPasteboard.h"
#import "WebPreferencesEx.h"
#import "WebKitEx.h"
#import "SRHTTPURLProtocol.h"

// For Growl support
#ifdef SR_SUPPORT_GROWL
#import "GrowlApplicationBridge.h"
#import "GrowlDefines.h"
#endif // SR_SUPPORT_GROWL
