<?php
class Planmodel extends MY_Model {
	var $id;
	var $owner_id;
	var $owner_name;
	var $name;
	var $summary;
	var $status;
	var $activity;
	var $term;
	var $target_budget;
	var $budget;
	var $created;
	var $modified;

	function __construct() {
		parent::__construct();
	}

	function getEmpty() {
		return array(
			'id' => '',
			'owner_id' => '',
			'owner_name' => '',
			'name' => '',
			'summary' => '',
			'status' => '',
			'activity' => '',
			'term' => '',
			'target_budget' => '',
			'budget' => '',
			'created' => '',
			'modified' => '',
			'docs' => array(),
			'sponsors' => array()
		);
	}

	function count_plan() {
		return $this->db->count_all('plans');
	}

	function search_plan($limit=20, $offset=0) {
		$this->db->from('plans')->limit($limit, $offset)->order_by('activity desc, budget desc, modified desc, id desc');
		//TODO: slow! please change to fast code!
		$tmp = $this->db->get()->result_array();
		foreach ($tmp as $k => $row) {
			$tmp[$k]['sponsors'] = $this->db->get_where('sponsors', array('plan_id' => $row['id']))->result_array();
		}
		return $tmp;
	}

	function detail($id) {
		$query = $this->db->get_where('plans', array('id' => $id));
		$db_ret = $query->row_array();
		if (empty($db_ret))
			return FALSE;

		//Note: change to single query?
		$db_ret['docs'] = $this->db->get_where('docs', array('plan_id' => $id))->result_array();
		$db_ret['sponsors'] = $this->db->get_where('sponsors', array('plan_id' => $id))->result_array();

		return $db_ret;
	}

	function save($user, $id, $data=NULL) {
		if (empty($data))
			$data = (array)$this;

		if (empty($id)) {
			$data = $this->setAutoData($data, array('created', 'modified', 'owner_id', 'owner_name', 'activity'));
			$db_ret = $this->db->insert('plans', $data);
			if ($db_ret)
				return $this->db->insert_id();

			return $db_ret;
		} else {
			$data = $this->setAutoData($data, array('created', 'modified', 'activity'));
			unset($data['created']);
			$data['owner_id'] = $user['id'];
			$data['owner_name'] = $user['name'];
			$this->db->where('id', $id);
			$db_ret = $this->db->update('plans', $data);
			if ($db_ret)
				return $id;

			return $db_ret;
		}
	}

	function saveAll($user, $id, $data=NULL, $docs=array(), $sponsors=array()) {
		$insert_id = $this->save($user, $id, $data);
		if ($insert_id === FALSE)
			return FALSE;

		// docs
		if ($id) {
			$doc_ids = $this->getChildIds($insert_id, 'docs');
		} else {
			$doc_ids = array();
		}
		foreach ($docs as $doc) {
			if ($doc['id']) {
				$new_doc = $this->setAutoData($doc, array('created', 'modified', 'plan_id'));
				$new_doc['plan_id'] = $insert_id;
				unset($new_doc['created']);
				unset($doc_ids[$doc['id']]);

				$this->db->where(array('id' => $doc['id'], 'plan_id' => $insert_id));
				$db_ret = $this->db->update('docs', $new_doc);
				if ($db_ret === FALSE)
					return FALSE;

			} else {
				$new_doc = $this->setAutoData($doc, array('created', 'modified', 'plan_id'));
				$new_doc['plan_id'] = $insert_id;

				$db_ret = $this->db->insert('docs', $new_doc);
				if ($db_ret === FALSE)
					return FALSE;
			}
		}
		if (count($doc_ids) > 0) {
			$this->db->where_in('id', $doc_ids);
			$this->db->delete('docs');
		}

		// sponsors
		if ($id) {
			$sponsor_ids = $this->getChildIds($id, 'sponsors');
		} else {
			$sponsor_ids = array();
		}
		foreach ($sponsors as $sponsor) {
			if ($sponsor['id']) {
				$new_sponsor = $this->setAutoData($sponsor, array('created', 'modified', 'plan_id'));
				$new_sponsor['plan_id'] = $insert_id;
				unset($new_sponsor['created']);
				unset($sponsor_ids[$new_sponsor['id']]);

				$this->db->where(array('id' => $new_sponsor['id'], 'plan_id' => $insert_id));
				$db_ret = $this->db->update('sponsors', $new_sponsor);
				if ($db_ret === FALSE)
					return FALSE;

			} else {
				$new_sponsor = $this->setAutoData($sponsor, array('created', 'modified', 'plan_id'));
				$new_sponsor['plan_id'] = $insert_id;

				$db_ret = $this->db->insert('sponsors', $new_sponsor);
				if ($db_ret === FALSE)
					return FALSE;
			}
		}
		if (count($sponsor_ids) > 0) {
			$this->db->where_in('id', $sponsor_ids);
			$this->db->delete('sponsors');
		}

		return $insert_id;
	}

	function getChildIds($plan_id, $table_name) {
		$query = $this->db->select('id')->get_where($table_name, array('plan_id' => $plan_id));
		$db_ret = $query->result_array();
		if (empty($db_ret))
			return FALSE;

		$ret = array();
		foreach ($db_ret as $row) {
			$ret[$row['id']] = $row['id'];
		}

		return $ret;
	}

	function addActivity($user, $plan_id) {
		$d = date('Y-m-d');
		$ret = $this->db->limit(1)->get_where('active_log',array(
			'user_id' => $user['id'],
			'plan_id' => $plan_id,
			'add_date' => $d
		))->row_array();
		if ($ret)
			return FALSE;

		$insert_ret = $this->db->insert('active_log', array(
			'user_id' => $user['id'],
			'plan_id' => $plan_id,
			'add_date' => $d
		));
		if ($insert_ret === FALSE)
			return FALSE;

		$old_data = $this->db->get_where('plans', array('id' => $plan_id))->row_array();
		$update_ret = $this->db->where(array('id' => $plan_id))->update('plans', array(
			'activity' => $old_data['activity'] + 10,
			'modified' => date('Y-m-d H:i:s')
		));
		if ($update_ret === FALSE)
			return FALSE;

		return $old_data['activity'] + 10;
	}
}
