/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.util.Arrays;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.RawDataBlock;

public class DocumentBlock
extends BigBlock {
    private byte[] _data;
    private int _bytes_read;

    public DocumentBlock(RawDataBlock block) throws IOException {
        this._data = block.getData();
        this._bytes_read = this._data.length;
    }

    private DocumentBlock() {
        this._data = new byte[512];
        Arrays.fill(this._data, (byte)-1);
    }

    public static DocumentBlock[] convert(byte[] array, int size) {
        DocumentBlock[] rval = new DocumentBlock[(size + 512 - 1) / 512];
        int offset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new DocumentBlock();
            if (offset < array.length) {
                int length = Math.min(512, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 512) {
                    Arrays.fill(rval[k]._data, length, 512, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 512;
        }
        return rval;
    }

    public static void read(DocumentBlock[] blocks, byte[] buffer, int offset) {
        int firstBlockIndex = offset / 512;
        int firstBlockOffset = offset % 512;
        int lastBlockIndex = (offset + buffer.length - 1) / 512;
        if (firstBlockIndex == lastBlockIndex) {
            System.arraycopy(blocks[firstBlockIndex]._data, firstBlockOffset, buffer, 0, buffer.length);
        } else {
            int buffer_offset = 0;
            System.arraycopy(blocks[firstBlockIndex]._data, firstBlockOffset, buffer, buffer_offset, 512 - firstBlockOffset);
            buffer_offset += 512 - firstBlockOffset;
            for (int j = firstBlockIndex + 1; j < lastBlockIndex; ++j) {
                System.arraycopy(blocks[j]._data, 0, buffer, buffer_offset, 512);
                buffer_offset += 512;
            }
            System.arraycopy(blocks[lastBlockIndex]._data, 0, buffer, buffer_offset, buffer.length - buffer_offset);
        }
    }
}

