/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.mspdi;

import com.projity.pm.assignment.functor.AssignmentFieldFunctor;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.server.data.mspdi.TimephasedConsumer;
import com.projity.server.data.mspdi.XsdDuration;
import com.projity.util.DateTime;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBException;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import org.apache.commons.collections.Closure;

public class TimephasedGetter
implements Closure {
    ObjectFactory factory;
    AssignmentFieldFunctor functor;
    BigInteger type;
    BigInteger id;
    TimephasedConsumer consumer;

    public static TimephasedGetter getInstance(ObjectFactory objectFactory, TimephasedConsumer timephasedConsumer, AssignmentFieldFunctor assignmentFieldFunctor, int n, long l) {
        return new TimephasedGetter(objectFactory, timephasedConsumer, assignmentFieldFunctor, n, l);
    }

    private TimephasedGetter(ObjectFactory objectFactory, TimephasedConsumer timephasedConsumer, AssignmentFieldFunctor assignmentFieldFunctor, int n, long l) {
        this.factory = objectFactory;
        this.consumer = timephasedConsumer;
        this.functor = assignmentFieldFunctor;
        this.type = BigInteger.valueOf(n);
        this.id = BigInteger.valueOf(l);
    }

    public void execute(Object object) {
        TimephasedDataType timephasedDataType;
        if (!this.consumer.acceptValue(this.functor.getValue())) {
            return;
        }
        try {
            timephasedDataType = this.factory.createTimephasedDataType();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return;
        }
        timephasedDataType.setType(this.type);
        timephasedDataType.setUID(this.id);
        timephasedDataType.setUnit(BigInteger.valueOf(3L));
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(DateTime.fromGmt((long)hasStartAndEnd.getStart()));
        GregorianCalendar gregorianCalendar2 = DateTime.calendarInstance();
        gregorianCalendar2.setTimeInMillis(DateTime.fromGmt((long)hasStartAndEnd.getEnd()));
        timephasedDataType.setStart(gregorianCalendar);
        timephasedDataType.setFinish(gregorianCalendar2);
        double d = this.functor.getValue() / 3600000.0;
        Duration duration = Duration.getInstance(d, TimeUnit.HOURS);
        XsdDuration xsdDuration = new XsdDuration(duration);
        timephasedDataType.setValue(xsdDuration.toString());
        this.consumer.consumeTimephased(timephasedDataType);
    }
}

