/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.editor;

import com.projity.datatype.CanSupplyRateUnit;
import com.projity.datatype.DurationFormat;
import com.projity.dialog.util.FixedSizeFilter;
import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.field.FieldParseException;
import com.projity.pm.graphic.ChangeAwareTextField;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.text.Format;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;

public class SimpleEditor
extends DefaultCellEditor {
    protected ChangeAwareTextField component = (ChangeAwareTextField)this.getComponent();
    protected Class clazz;
    protected Format useFormat = null;
    JTable cachedTable = null;

    public SimpleEditor() {
        super(new ChangeAwareTextField());
        this.component.setFocusLostBehavior(1);
        this.component.getInputMap(0).getParent().getParent().getParent().remove(KeyStroke.getKeyStroke(10, 0));
        this.clazz = String.class;
    }

    public SimpleEditor(Class clazz) {
        this();
        this.clazz = clazz;
    }

    public SimpleEditor(Class clazz, Format format) {
        this(clazz);
        this.useFormat = format;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.cachedTable = jTable;
        String string = object == null ? null : FieldConverter.toString(object);
        this.component.setText(string);
        this.component.setSelectedTextColor(Color.WHITE);
        this.component.setSelectionColor(Color.BLACK);
        if (jTable.getModel() instanceof SpreadSheetModel) {
            Object object2;
            SpreadSheetModel spreadSheetModel = (SpreadSheetModel)jTable.getModel();
            Field field = spreadSheetModel.getFieldInColumn(n3 + 1);
            int n4 = field.getTextWidth(null, null);
            if (n4 != Integer.MAX_VALUE) {
                ((AbstractDocument)this.component.getDocument()).setDocumentFilter(new FixedSizeFilter(n4));
            }
            this.component.setHorizontalAlignment(field.getHorizontalAlignment());
            if (field.isWork() && (object2 = spreadSheetModel.getObjectInRow(n2)) instanceof CanSupplyRateUnit && ((CanSupplyRateUnit)object2).isMaterial()) {
                this.useFormat = DurationFormat.getNonTemporalWorkInstance();
            }
        } else if (object == null || object instanceof String) {
            this.component.setHorizontalAlignment(2);
        } else {
            this.component.setHorizontalAlignment(4);
        }
        this.component.selectAll();
        return this.component;
    }

    public Object getCellEditorValue() {
        if (this.useFormat == null) {
            try {
                return FieldConverter.convert(this.component.getText(), this.clazz, null);
            }
            catch (FieldParseException fieldParseException) {
                return null;
            }
        }
        try {
            return this.useFormat.parseObject(this.component.getText());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean stopCellEditing() {
        if (this.component.hasChanged()) {
            boolean bl = super.stopCellEditing();
            if (this.handledPostErrorFocus()) {
                return false;
            }
            return bl;
        }
        this.cancelCellEditing();
        return true;
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    protected boolean handledPostErrorFocus() {
        if (this.cachedTable != null && this.cachedTable instanceof CommonSpreadSheet && ((CommonSpreadSheet)this.cachedTable).getLastException() != null) {
            this.cachedTable.requestFocus();
            return true;
        }
        return false;
    }
}

