/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.chart;

import com.projity.datatype.Money;
import com.projity.field.Field;
import com.projity.graphic.configuration.shape.PredefinedStroke;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.graphic.chart.ChartCorner;
import com.projity.pm.graphic.chart.ChartHelper;
import com.projity.pm.graphic.chart.ChartInfo;
import com.projity.pm.graphic.chart.ChartModel;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class TimeChartPanel
extends ChartPanel
implements Scrollable,
ScaledComponent {
    private static final long serialVersionUID = 2034704461047717965L;
    ChartInfo chartInfo;
    JViewport viewport;
    private Dimension olddmain = null;
    protected boolean verticalScrolling = false;
    JMenuItem verticalScrollingItem;

    public TimeChartPanel(ChartInfo chartInfo) {
        super(chartInfo.setChart(TimeChartPanel.buildChart(chartInfo.getModel())), true);
        this.chartInfo = chartInfo;
        this.setMaximumDrawWidth(4000);
        this.setMaximumDrawHeight(1000);
    }

    public void configureScrollPaneHeaders(JScrollPane jScrollPane, JComponent jComponent) {
        this.viewport = jScrollPane.getViewport();
        if (this.viewport == null || this.viewport.getView() != this) {
            return;
        }
        JViewport jViewport = new JViewport();
        jViewport.setView(jComponent);
        jViewport.setPreferredSize(jComponent.getPreferredSize());
        jScrollPane.setRowHeader(jViewport);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", new ChartCorner(this));
        Border border = jScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        this.viewport.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TimeChartPanel.this.updateTimeScaleComponentSize();
            }
        });
    }

    public void updateTimeScaleComponentSize() {
        Dimension dimension = this.viewport.getViewSize();
        if (dimension.equals(this.olddmain)) {
            return;
        }
        this.olddmain = dimension;
        Dimension dimension2 = this.chartInfo.getAxisPanel().getPreferredSize();
        dimension2.setSize(dimension2.getWidth(), dimension.getHeight());
        this.chartInfo.getAxisPanel().revalidate();
    }

    protected JFreeChart buildChart() {
        JFreeChart jFreeChart = ChartHelper.createChart(this.chartInfo.getModel().getDataset(), this.chartInfo.isHistogram(), this.chartInfo.getModel().getSecondDataset());
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        Object[] objectArray = this.chartInfo.getTraces();
        if (!this.chartInfo.isSimple() && objectArray.length > 0 && objectArray[0] instanceof Field) {
            Format format;
            Field field = (Field)objectArray[0];
            numberFormat = field.isMoney() ? new NumberFormat(){

                public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    return stringBuffer.append(Money.formatCurrency(d2, true));
                }

                public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    return null;
                }

                public Number parse(String string, ParsePosition parsePosition) {
                    return null;
                }
            } : ((format = field.getFormat()) instanceof NumberFormat ? (NumberFormat)format : NumberFormat.getNumberInstance());
        }
        ((NumberAxis)jFreeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(numberFormat);
        return jFreeChart;
    }

    public static JFreeChart buildChart(ChartModel chartModel) {
        return ChartHelper.createChart(chartModel.getDataset(), true, chartModel.getSecondDataset());
    }

    public void updateChart() {
        JFreeChart jFreeChart = this.chartInfo.getChart();
        final Object[] objectArray = this.chartInfo.getTraces();
        this.setChart(jFreeChart);
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Color color = ChartHelper.getColorForField(objectArray[i2]);
            if (objectArray[i2] == HasTimeDistributedData.AVAILABILITY) {
                jFreeChart.getXYPlot().getRenderer(1).setSeriesPaint(0, color);
                jFreeChart.getXYPlot().getRenderer(1).setSeriesStroke(0, PredefinedStroke.LARGE_FRAMED);
                continue;
            }
            jFreeChart.getXYPlot().getRenderer().setSeriesPaint(n2, color);
            jFreeChart.getXYPlot().getRenderer().setToolTipGenerator(new CustomXYToolTipGenerator(){

                public String generateToolTip(XYDataset xYDataset, int n2, int n3) {
                    return objectArray[0] + " ";
                }
            });
            ++n2;
        }
        jFreeChart.getXYPlot().getDomainAxis().setLowerBound(this.chartInfo.getCoord().getOrigin());
        jFreeChart.getXYPlot().getDomainAxis().setUpperBound(Math.max((double)this.chartInfo.getCoord().getEnd(), this.chartInfo.getCoord().toTime(this.viewport.getWidth())));
    }

    public double getNonPlotHeight() {
        ChartRenderingInfo chartRenderingInfo = this.getChartRenderingInfo();
        return chartRenderingInfo.getChartArea().getHeight() - chartRenderingInfo.getPlotInfo().getDataArea().getHeight();
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        this.chartInfo.setCoord(coordinatesConverter);
    }

    public CoordinatesConverter getCoord() {
        return this.chartInfo.getCoord();
    }

    public boolean isVerticalScrolling() {
        return this.verticalScrolling;
    }

    public void setVerticalScrolling(boolean bl) {
        this.verticalScrolling = bl;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return n2 == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            if (((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height) {
                return true;
            }
            return !this.verticalScrolling;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 1) {
            return 2;
        }
        return 4;
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JPopupMenu jPopupMenu = super.createPopupMenu(false, bl2, bl3, false);
        return jPopupMenu;
    }
}

