/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.functor;

import com.projity.algorithm.CalculationVisitor;
import com.projity.pm.assignment.functor.AssignmentFieldClosureCollection;
import com.projity.pm.assignment.functor.AssignmentFieldFunctor;
import com.projity.pm.time.HasStartAndEnd;

public class DateAtValueFunctor
implements CalculationVisitor {
    AssignmentFieldClosureCollection childList;
    double subtotal;
    double value;
    long date;

    public static DateAtValueFunctor getInstance(double d2, AssignmentFieldClosureCollection assignmentFieldClosureCollection) {
        return new DateAtValueFunctor(d2, assignmentFieldClosureCollection);
    }

    private DateAtValueFunctor(double d2, AssignmentFieldClosureCollection assignmentFieldClosureCollection) {
        this.reset();
        this.value = d2;
        this.childList = assignmentFieldClosureCollection;
    }

    public void initialize() {
    }

    public void reset() {
        this.subtotal = 0.0;
        this.value = 0.0;
        this.date = 0L;
    }

    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        double d2 = this.childList.getValue();
        this.subtotal += d2;
        if (this.date == 0L && this.subtotal >= this.value) {
            if (this.value == 0.0) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            if (hasStartAndEnd.getStart() == hasStartAndEnd.getEnd()) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            double d3 = this.childList.getFixedValue();
            if (this.subtotal + d3 - d2 >= this.value) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            double d4 = ((d2 -= d3) - (this.subtotal - this.value)) / d2;
            AssignmentFieldFunctor assignmentFieldFunctor = this.childList.getANonZeroFunctor();
            long l2 = assignmentFieldFunctor.getWorkCalendar().compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
            this.date = assignmentFieldFunctor.getWorkCalendar().add(hasStartAndEnd.getStart(), (long)((double)l2 * d4), true);
        }
    }

    public long getDate() {
        return this.date;
    }

    public boolean isCumulative() {
        return false;
    }
}

