/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.configuration.CalculationPreference;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import java.io.Serializable;

public class PersonalContourBucket
extends AbstractContourBucket
implements Serializable {
    static final long serialVersionUID = 99779271628737L;
    private long duration = 0L;

    public long getDuration() {
        return this.duration;
    }

    public long getBucketDuration(long l2) {
        return this.duration;
    }

    protected PersonalContourBucket(long l2, double d2) {
        this.duration = l2;
        this.units = d2;
    }

    public static PersonalContourBucket getInstance(long l2, double d2) {
        if (l2 < 0L) {
            System.out.println("bug negative bucket");
        }
        return new PersonalContourBucket(l2, d2);
    }

    private PersonalContourBucket(AbstractContourBucket abstractContourBucket, long l2) {
        this.duration = abstractContourBucket.getBucketDuration(l2);
        this.units = abstractContourBucket.getUnits();
    }

    public double getEffectiveUnits(double d2) {
        return this.units;
    }

    public PersonalContourBucket(PersonalContourBucket personalContourBucket) {
        this(personalContourBucket.duration, personalContourBucket.units);
    }

    public long calcWork() {
        return (long)(this.units * (double)this.duration);
    }

    public String toString() {
        return "[duration] " + this.duration / 3600000L + "h" + "\n[units] " + this.units;
    }

    public double weightedSum() {
        return this.units * (double)this.duration;
    }

    public PersonalContourBucket adjustUnits(double d2) {
        return new PersonalContourBucket(this.duration, this.units * d2);
    }

    public PersonalContourBucket adjustWork(double d2) {
        if (!CalculationPreference.getActive().isNonWorkContourPeriodsStayFixedLength() || this.units != 0.0) {
            return new PersonalContourBucket((long)((double)this.duration * d2), this.units / d2);
        }
        return this;
    }

    public PersonalContourBucket adjustDuration(long l2) {
        return new PersonalContourBucket(this.duration + l2, this.units);
    }

    public static PersonalContourBucket getInstance(AbstractContourBucket abstractContourBucket, long l2) {
        return new PersonalContourBucket(abstractContourBucket, l2);
    }

    public Object clone() {
        return super.clone();
    }
}

