/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.pm.assignment.contour.AbstractContour;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.FillerContourBucket;
import com.projity.pm.assignment.contour.PersonalContourBucket;
import com.projity.pm.assignment.contour.StandardContour;
import com.projity.pm.assignment.contour.StandardContourBucket;
import com.projity.pm.time.MutableInterval;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.Collection;

public class PersonalContour
extends AbstractContour {
    private static final String name = Messages.getString("PersonalContour.personal");

    public boolean isPersonal() {
        return true;
    }

    public long calcTotalWork(long l2) {
        long l3 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            l3 += ((PersonalContourBucket)this.contourBuckets[i2]).calcWork();
        }
        return l3;
    }

    public String getName() {
        return name;
    }

    public int getType() {
        return 8;
    }

    private PersonalContour(AbstractContourBucket[] abstractContourBucketArray) {
        super(abstractContourBucketArray);
    }

    public static PersonalContour makePersonal(AbstractContour abstractContour, long l2) {
        if (abstractContour.isPersonal()) {
            return (PersonalContour)abstractContour;
        }
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[abstractContour.contourBuckets.length];
        for (int i2 = 0; i2 < abstractContour.contourBuckets.length; ++i2) {
            StandardContourBucket standardContourBucket = (StandardContourBucket)abstractContour.contourBuckets[i2];
            abstractContourBucketArray[i2] = PersonalContourBucket.getInstance(standardContourBucket.getBucketDuration(l2), standardContourBucket.getUnits());
        }
        PersonalContour personalContour = PersonalContour.getInstance(abstractContourBucketArray);
        return personalContour;
    }

    public static PersonalContour constructUsingSizeOf(AbstractContour abstractContour) {
        PersonalContour personalContour = PersonalContour.getInstance(new AbstractContourBucket[abstractContour.contourBuckets.length]);
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    public static PersonalContour getInstance(Collection collection) {
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[collection.size()];
        collection.toArray(abstractContourBucketArray);
        PersonalContour personalContour = PersonalContour.getInstance(abstractContourBucketArray);
        personalContour.validate();
        return personalContour;
    }

    public void validate() {
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            if (this.contourBuckets[i2].getBucketDuration(0L) >= 0L && !(this.contourBuckets[i2].getUnits() < 0.0)) continue;
            System.out.println("error neg bucket!\n" + this.toString(0L));
        }
    }

    public static PersonalContour getInstance(AbstractContourBucket[] abstractContourBucketArray) {
        return new PersonalContour(abstractContourBucketArray);
    }

    public static PersonalContour addEmptyBucket(AbstractContour abstractContour, long l2, boolean bl) {
        int n2 = abstractContour.contourBuckets.length;
        PersonalContour personalContour = PersonalContour.getInstance(new AbstractContourBucket[n2 + 1]);
        System.arraycopy(abstractContour.contourBuckets, 0, personalContour.contourBuckets, bl ? 0 : 1, n2);
        personalContour.contourBuckets[bl ? n2 : 0] = PersonalContourBucket.getInstance(l2, 0.0);
        return personalContour;
    }

    public AbstractContour adjustDuration(long l2, long l3) {
        PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
        PersonalContourBucket personalContourBucket = null;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i2];
            personalContour.contourBuckets[i2] = personalContourBucket;
            if ((l2 -= personalContourBucket.getDuration()) > 0L) continue;
            personalContour.contourBuckets[i2] = personalContourBucket.adjustDuration(l2);
            if (i2 < this.contourBuckets.length - 1) {
                System.arraycopy(personalContour.contourBuckets, 0, personalContour.contourBuckets, 0, i2 + 1);
            }
            PersonalContour personalContour2 = personalContour.makePacked();
            return personalContour2;
        }
        personalContour.contourBuckets[this.contourBuckets.length - 1] = personalContourBucket.adjustDuration(l2);
        return personalContour;
    }

    private ArrayList bucketsBeforeDuration(long l2) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        boolean bl = false;
        PersonalContourBucket personalContourBucket = null;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i2];
            if ((l3 += personalContourBucket.getDuration()) >= l2) {
                long l4 = l2 - (l3 - personalContourBucket.getDuration());
                if (l4 <= 0L) break;
                if (personalContourBucket.isFiller()) {
                    arrayList.add(FillerContourBucket.getInstance(l4));
                    break;
                }
                arrayList.add(PersonalContourBucket.getInstance(l4, personalContourBucket.getUnits()));
                break;
            }
            arrayList.add(personalContourBucket);
        }
        return arrayList;
    }

    private ArrayList bucketsAfterDuration(long l2, boolean bl) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        boolean bl2 = false;
        PersonalContourBucket personalContourBucket = null;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i2];
            if (bl && personalContourBucket.isFiller() || (l3 += personalContourBucket.getDuration()) <= l2) continue;
            if (l3 - personalContourBucket.getDuration() >= l2) {
                arrayList.add(personalContourBucket);
                continue;
            }
            long l4 = l3 - l2;
            if (l4 <= 0L) continue;
            arrayList.add(PersonalContourBucket.getInstance(l4, personalContourBucket.getUnits()));
        }
        return arrayList;
    }

    public AbstractContour removeFillerAfter(long l2) {
        ArrayList arrayList = this.bucketsBeforeDuration(l2);
        arrayList.addAll(this.bucketsAfterDuration(l2, false));
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    public MutableInterval getRangeThatIntervalCanBeMoved(long l2, long l3) {
        PersonalContourBucket personalContourBucket;
        ArrayList arrayList = this.bucketsBeforeDuration(l2);
        long l4 = l2;
        long l5 = Long.MAX_VALUE;
        if (arrayList.size() > 0 && (personalContourBucket = (PersonalContourBucket)arrayList.get(arrayList.size() - 1)).getUnits() == 0.0) {
            l4 = l2 - personalContourBucket.getDuration();
        }
        arrayList.clear();
        arrayList = this.bucketsAfterDuration(l3, false);
        if (arrayList.size() > 0) {
            personalContourBucket = (PersonalContourBucket)arrayList.get(0);
            l5 = personalContourBucket.getUnits() == 0.0 ? l3 + personalContourBucket.getDuration() : l3;
        }
        return new MutableInterval(l4, l5);
    }

    public PersonalContour setInterval(long l2, long l3, double d2) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        arrayList.addAll(this.bucketsBeforeDuration(l2));
        arrayList.add(PersonalContourBucket.getInstance(l3 - l2, d2));
        arrayList.addAll(this.bucketsAfterDuration(l3, false));
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    public PersonalContour insertBucket(long l2, AbstractContourBucket abstractContourBucket) {
        ArrayList<AbstractContourBucket> arrayList = new ArrayList<AbstractContourBucket>();
        boolean bl = false;
        PersonalContourBucket personalContourBucket = null;
        long l3 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i2];
            if (bl || (l3 += personalContourBucket.getDuration()) < l2) {
                arrayList.add(personalContourBucket);
                continue;
            }
            long l4 = l3 - l2;
            arrayList.add(PersonalContourBucket.getInstance(l4, personalContourBucket.getUnits()));
            arrayList.add(abstractContourBucket);
            arrayList.add(PersonalContourBucket.getInstance(personalContourBucket.getDuration() - l4, personalContourBucket.getUnits()));
            bl = true;
        }
        return PersonalContour.getInstance(arrayList).makePacked();
    }

    public PersonalContour extendBucket(long l2, long l3) {
        PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
        PersonalContourBucket personalContourBucket = null;
        boolean bl = false;
        long l4 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket = (PersonalContourBucket)this.contourBuckets[i2];
            personalContour.contourBuckets[i2] = personalContourBucket;
            if (bl || (l4 += personalContourBucket.getDuration()) < l2 || personalContourBucket.getUnits() == 0.0) continue;
            bl = true;
            personalContour.contourBuckets[i2] = PersonalContourBucket.getInstance(Math.max(0L, personalContourBucket.getDuration() + l3), personalContourBucket.getUnits());
        }
        return personalContour.makePacked();
    }

    public PersonalContour shift(long l2, long l3, long l4) {
        PersonalContour personalContour;
        if (l4 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        if (l4 > 0L) {
            arrayList.addAll(this.bucketsBeforeDuration(l3));
            arrayList.addAll(this.bucketsAfterDuration(l3 + l4, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
            arrayList.clear();
            arrayList.addAll(personalContour.bucketsBeforeDuration(l2));
            arrayList.add(PersonalContourBucket.getInstance(l4, 0.0));
            arrayList.addAll(personalContour.bucketsAfterDuration(l2, false));
        } else {
            arrayList.addAll(this.bucketsBeforeDuration(l3));
            arrayList.add(PersonalContourBucket.getInstance(-l4, 0.0));
            arrayList.addAll(this.bucketsAfterDuration(l3, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
            arrayList.clear();
            arrayList.addAll(personalContour.bucketsBeforeDuration(l2 + l4));
            arrayList.addAll(personalContour.bucketsAfterDuration(l2, false));
        }
        personalContour = PersonalContour.getInstance(arrayList).makePacked();
        return personalContour;
    }

    public AbstractContour extend(long l2, long l3) {
        PersonalContour personalContour;
        if (l3 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        if (l3 > 0L) {
            arrayList.addAll(this.bucketsBeforeDuration(l2));
            arrayList.addAll(this.bucketsAfterDuration(l2 + l3, false));
            PersonalContour personalContour2 = PersonalContour.getInstance(arrayList).makePacked();
            personalContour = personalContour2.extendBucket(l2, l3);
        } else {
            arrayList.addAll(this.bucketsBeforeDuration(l2 + l3));
            arrayList.add(PersonalContourBucket.getInstance(-l3, 0.0));
            arrayList.addAll(this.bucketsAfterDuration(l2, false));
            personalContour = PersonalContour.getInstance(arrayList).makePacked();
        }
        return personalContour;
    }

    public AbstractContour extendBefore(long l2, long l3) {
        if (l3 == 0L) {
            return this;
        }
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        PersonalContour personalContour = this.extendBucket(l2, -l3);
        if (l3 < 0L) {
            arrayList.addAll(personalContour.bucketsBeforeDuration(l2 + l3));
            arrayList.addAll(personalContour.bucketsAfterDuration(l2, false));
        } else {
            arrayList.addAll(personalContour.bucketsBeforeDuration(l2));
            arrayList.add(PersonalContourBucket.getInstance(l3, 0.0));
            arrayList.addAll(personalContour.bucketsAfterDuration(l2, false));
        }
        PersonalContour personalContour2 = PersonalContour.getInstance(arrayList).makePacked();
        return personalContour2;
    }

    private PersonalContour makePacked() {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        PersonalContourBucket personalContourBucket = null;
        PersonalContourBucket personalContourBucket2 = null;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            personalContourBucket2 = (PersonalContourBucket)this.contourBuckets[i2];
            if (personalContourBucket2 == null) {
                System.out.println("null bucket " + i2 + " in make packed - skipping");
                continue;
            }
            if (personalContourBucket != null && personalContourBucket.getUnits() == personalContourBucket2.getUnits() && personalContourBucket.isFiller() == personalContourBucket2.isFiller()) {
                personalContourBucket = PersonalContourBucket.getInstance(personalContourBucket.getDuration() + personalContourBucket2.getDuration(), personalContourBucket2.getUnits());
                continue;
            }
            if (personalContourBucket != null && personalContourBucket.getDuration() > 0L) {
                arrayList.add(personalContourBucket);
            }
            personalContourBucket = personalContourBucket2;
        }
        if (personalContourBucket != null && personalContourBucket.getDuration() > 0L && personalContourBucket.getUnits() != 0.0) {
            arrayList.add(personalContourBucket);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(PersonalContourBucket.getInstance(0L, 1.0));
        }
        return PersonalContour.getInstance(arrayList);
    }

    public AbstractContour convertToFlatIfPossible() {
        if (this.getContourBuckets().length > 1) {
            return this;
        }
        return StandardContour.FLAT_CONTOUR;
    }

    public AbstractContour adjustUnits(double d2, long l2) {
        ArrayList<PersonalContourBucket> arrayList = new ArrayList<PersonalContourBucket>();
        arrayList.addAll(this.bucketsBeforeDuration(l2));
        ArrayList arrayList2 = this.bucketsAfterDuration(l2, false);
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            arrayList.add(((PersonalContourBucket)arrayList2.get(i2)).adjustUnits(d2));
        }
        PersonalContour personalContour = PersonalContour.getInstance(arrayList).makePacked();
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    public AbstractContour contourAdjustWork(double d2, long l2) {
        if (l2 == 0L) {
            PersonalContour personalContour = PersonalContour.constructUsingSizeOf(this);
            for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
                personalContour.contourBuckets[i2] = ((PersonalContourBucket)this.contourBuckets[i2]).adjustWork(d2);
            }
            personalContour.makePacked();
            personalContour.maxUnits = personalContour.calcMaxUnits();
            return personalContour;
        }
        ArrayList arrayList = this.bucketsBeforeDuration(l2);
        ArrayList arrayList2 = this.bucketsAfterDuration(l2, false);
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            arrayList.add(((PersonalContourBucket)arrayList2.get(i3)).adjustWork(d2));
        }
        PersonalContour personalContour = PersonalContour.getInstance(arrayList).makePacked();
        personalContour.maxUnits = personalContour.calcMaxUnits();
        return personalContour;
    }

    public PersonalContour(AbstractContour abstractContour, long l2) {
        super(new PersonalContourBucket[abstractContour.numBuckets()]);
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            this.contourBuckets[i2] = PersonalContourBucket.getInstance(abstractContour.getContourBuckets()[i2], l2);
        }
        this.maxUnits = this.calcMaxUnits();
    }

    public long extractDelay() {
        long l2 = 0L;
        if (this.contourBuckets.length < 2) {
            return 0L;
        }
        while (this.contourBuckets[0].getUnits() == 0.0) {
            l2 += this.contourBuckets[0].getBucketDuration(0L);
            AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[this.contourBuckets.length - 1];
            System.arraycopy(this.contourBuckets, 1, abstractContourBucketArray, 0, abstractContourBucketArray.length);
            this.contourBuckets = abstractContourBucketArray;
        }
        return l2;
    }

    public AbstractContour removeEmptyBucketAtDuration(long l2) {
        ArrayList arrayList = this.bucketsAfterDuration(l2, false);
        if (arrayList.isEmpty() || ((AbstractContourBucket)arrayList.get(0)).getUnits() != 0.0) {
            return this;
        }
        arrayList.remove(0);
        ArrayList arrayList2 = this.bucketsBeforeDuration(l2);
        arrayList2.addAll(arrayList);
        return PersonalContour.getInstance(arrayList2).makePacked();
    }

    public Object clone() {
        return super.clone();
    }
}

