/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.datatype.DurationFormat;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.PersonalContourBucket;
import com.projity.pm.time.MutableInterval;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class AbstractContour
implements Cloneable {
    protected AbstractContourBucket[] contourBuckets = null;
    protected double maxUnits = 0.0;

    public abstract int getType();

    public abstract boolean isPersonal();

    public abstract long calcTotalWork(long var1);

    public AbstractContour adjustDuration(long l2, long l3) {
        return this;
    }

    public AbstractContour adjustUnits(double d2, long l2) {
        return this;
    }

    public AbstractContour contourAdjustWork(double d2, long l2) {
        return this;
    }

    public AbstractContourBucket[] getContourBuckets() {
        return this.contourBuckets;
    }

    public abstract String getName();

    public int numBuckets() {
        if (this.contourBuckets == null) {
            return 0;
        }
        return this.contourBuckets.length;
    }

    private long calcSumBucketDuration(long l2, boolean bl) {
        long l3 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            if (this.contourBuckets[i2] == null) {
                System.out.println(this.toString(l2));
            }
            if (bl && this.contourBuckets[i2].getUnits() == 0.0) continue;
            l3 += this.contourBuckets[i2].getBucketDuration(l2);
        }
        return l3;
    }

    public long calcTotalBucketDuration(long l2) {
        return this.calcSumBucketDuration(l2, false);
    }

    public long calcWorkingBucketDuration(long l2) {
        return this.calcSumBucketDuration(l2, true);
    }

    protected double calcMaxUnits() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            if (this.contourBuckets[i2] == null) continue;
            d2 = Math.max(d2, this.contourBuckets[i2].getUnits());
        }
        return d2;
    }

    public ArrayList toArrayList() {
        if (this.contourBuckets == null) {
            return null;
        }
        ArrayList<AbstractContourBucket> arrayList = new ArrayList<AbstractContourBucket>(this.contourBuckets.length);
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            arrayList.add(this.contourBuckets[i2]);
        }
        return arrayList;
    }

    public double getMaxUnits() {
        return this.maxUnits;
    }

    public AbstractContour(AbstractContourBucket[] abstractContourBucketArray) {
        this.contourBuckets = abstractContourBucketArray;
        this.maxUnits = this.calcMaxUnits();
    }

    public LinkedList bucketsBetweenDurations(long l2, long l3, long l4) {
        LinkedList<PersonalContourBucket> linkedList = new LinkedList<PersonalContourBucket>();
        AbstractContourBucket abstractContourBucket = null;
        long l5 = 0L;
        long l6 = 0L;
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            abstractContourBucket = this.contourBuckets[i2];
            l6 = l5;
            if ((l5 += abstractContourBucket.getBucketDuration(l4)) <= l2) continue;
            if (l6 >= l3) break;
            long l7 = Math.min(l3, l5) - Math.max(l2, l6);
            linkedList.add(PersonalContourBucket.getInstance(l7, abstractContourBucket.getUnits()));
        }
        return linkedList;
    }

    public String toString(long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contourBuckets == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
            stringBuffer.append("bucket[" + i2 + "]");
            if (this.contourBuckets[i2] == null) {
                stringBuffer.append(" NULL!");
                continue;
            }
            stringBuffer.append(" duration=" + DurationFormat.format(this.contourBuckets[i2].getBucketDuration(l2)) + " units " + this.contourBuckets[i2].getUnits() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0L);
    }

    public abstract AbstractContour extend(long var1, long var3);

    public abstract AbstractContour extendBefore(long var1, long var3);

    public abstract MutableInterval getRangeThatIntervalCanBeMoved(long var1, long var3);

    public AbstractContour removeFillerAfter(long l2) {
        return this;
    }

    public long extractDelay() {
        return 0L;
    }

    public Object clone() {
        try {
            AbstractContour abstractContour = (AbstractContour)super.clone();
            if (this.contourBuckets != null) {
                abstractContour.contourBuckets = new AbstractContourBucket[this.contourBuckets.length];
                for (int i2 = 0; i2 < this.contourBuckets.length; ++i2) {
                    abstractContour.contourBuckets[i2] = (AbstractContourBucket)this.contourBuckets[i2].clone();
                }
            }
            return abstractContour;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public double getLastBucketUnits() {
        return this.contourBuckets[this.contourBuckets.length - 1].getUnits();
    }
}

