/*
 * Decompiled with CFR 0.152.
 */
package com.projity.interval;

import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.interval.InvalidValueObjectForIntervalException;
import com.projity.interval.ValueObjectForInterval;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public abstract class ValueObjectForIntervalTable
implements NodeModelDataFactory,
Serializable,
Cloneable {
    static final long serialVersionUID = 7728399282882L;
    protected ArrayList valueObjects = new ArrayList();
    protected String name;

    public List getList() {
        return Collections.unmodifiableList(this.valueObjects);
    }

    public ArrayList getValueObjects() {
        return this.valueObjects;
    }

    public ValueObjectForIntervalTable() {
    }

    public ValueObjectForIntervalTable(String string, ArrayList arrayList) {
        this.name = string;
        this.valueObjects = arrayList;
    }

    public ValueObjectForIntervalTable(String string) {
        this.name = string;
        this.valueObjects.add(this.createValueObject(ValueObjectForInterval.NA_TIME));
    }

    protected abstract ValueObjectForInterval createValueObject(long var1);

    public ValueObjectForInterval newValueObject(long l2) throws InvalidValueObjectForIntervalException {
        ValueObjectForInterval valueObjectForInterval = this.createValueObject(l2);
        int n2 = Collections.binarySearch(this.valueObjects, valueObjectForInterval, valueObjectForInterval);
        if (n2 >= 0) {
            throw new InvalidValueObjectForIntervalException(Messages.getString("ValueObjectForIntervalTable.ThatEffectiveDateIsAlreadyInTheTable"));
        }
        ValueObjectForInterval valueObjectForInterval2 = (ValueObjectForInterval)this.valueObjects.get(-n2 - 2);
        this.valueObjects.add(-n2 - 1, valueObjectForInterval);
        valueObjectForInterval.setEnd(valueObjectForInterval2.getEnd());
        valueObjectForInterval2.setEnd(l2);
        return valueObjectForInterval;
    }

    public long getEnd() {
        long l2 = 0L;
        Iterator iterator = this.valueObjects.iterator();
        while (iterator.hasNext()) {
            l2 = Math.max(l2, ((ValueObjectForInterval)iterator.next()).getEnd());
        }
        return l2;
    }

    public void adjustStart(long l2, ValueObjectForInterval valueObjectForInterval) throws InvalidValueObjectForIntervalException {
        int n2 = this.valueObjects.indexOf(valueObjectForInterval);
        if (n2 == 0) {
            return;
        }
        ValueObjectForInterval valueObjectForInterval2 = (ValueObjectForInterval)this.valueObjects.get(n2 - 1);
        if (l2 <= valueObjectForInterval2.getStart()) {
            throw new InvalidValueObjectForIntervalException(Messages.getString("ValueObjectForIntervalTable.ThisDateMustBeAfter"));
        }
        if (l2 >= valueObjectForInterval.getEnd()) {
            throw new InvalidValueObjectForIntervalException(Messages.getString("ValueObjectForIntervalTable.ThisDateMustBeBefore"));
        }
        valueObjectForInterval2.setEnd(l2);
        valueObjectForInterval.setStart(l2);
    }

    public long getStart() {
        long l2 = DateTime.getMaxDate().getTime();
        Iterator iterator = this.valueObjects.iterator();
        while (iterator.hasNext()) {
            l2 = Math.min(l2, ((ValueObjectForInterval)iterator.next()).getStart());
        }
        return l2;
    }

    public void remove(ValueObjectForInterval valueObjectForInterval) throws InvalidValueObjectForIntervalException {
        if (valueObjectForInterval.isFirst()) {
            throw new InvalidValueObjectForIntervalException(Messages.getString("ValueObjectForIntervalTable.YouCannotRemoveTheFirst"));
        }
        int n2 = this.valueObjects.indexOf(valueObjectForInterval);
        ValueObjectForInterval valueObjectForInterval2 = (ValueObjectForInterval)this.valueObjects.get(n2 - 1);
        valueObjectForInterval2.setEnd(valueObjectForInterval.getEnd());
        this.valueObjects.remove(valueObjectForInterval);
    }

    private int findActiveIndex(long l2) {
        ValueObjectForInterval valueObjectForInterval = this.createValueObject(l2);
        int n2 = Collections.binarySearch(this.valueObjects, valueObjectForInterval, valueObjectForInterval);
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return n2;
    }

    public ValueObjectForInterval findActive(long l2) {
        return (ValueObjectForInterval)this.valueObjects.get(this.findActiveIndex(l2));
    }

    public ValueObjectForInterval findCurrent() {
        return this.findActive(System.currentTimeMillis());
    }

    public String getName() {
        return this.name;
    }

    public Object createUnvalidatedObject(NodeModel nodeModel, Object object) {
        long l2 = DateTime.midnightToday();
        ValueObjectForInterval valueObjectForInterval = (ValueObjectForInterval)this.valueObjects.get(this.valueObjects.size() - 1);
        l2 = Math.max(l2, valueObjectForInterval.getStart());
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        gregorianCalendar.roll(1, true);
        long l3 = gregorianCalendar.getTimeInMillis();
        try {
            return this.newValueObject(l3);
        }
        catch (InvalidValueObjectForIntervalException invalidValueObjectForIntervalException) {
            invalidValueObjectForIntervalException.printStackTrace();
            return null;
        }
    }

    public void addUnvalidatedObject(Object object, NodeModel nodeModel, Object object2) {
    }

    public NodeModelDataFactory getFactoryToUseForChildOfParent(Object object) {
        return this;
    }

    public void rollbackUnvalidated(NodeModel nodeModel, Object object) {
        this.remove(object, nodeModel, false, true, true);
    }

    public void remove(Object object, NodeModel nodeModel, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.remove((ValueObjectForInterval)object);
        }
        catch (InvalidValueObjectForIntervalException invalidValueObjectForIntervalException) {
            return;
        }
    }

    public void validateObject(Object object, NodeModel nodeModel, Object object2, Object object3, boolean bl) {
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeObject(this.valueObjects);
    }

    protected static ValueObjectForIntervalTable deserialize(ObjectInputStream objectInputStream, ValueObjectForIntervalTable valueObjectForIntervalTable) throws IOException, ClassNotFoundException {
        valueObjectForIntervalTable.name = (String)objectInputStream.readObject();
        valueObjectForIntervalTable.valueObjects = (ArrayList)objectInputStream.readObject();
        return valueObjectForIntervalTable;
    }

    public Object clone() {
        try {
            ValueObjectForIntervalTable valueObjectForIntervalTable = (ValueObjectForIntervalTable)super.clone();
            valueObjectForIntervalTable.name = this.name == null ? null : new String(this.name);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = this.valueObjects.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((ValueObjectForInterval)iterator.next()).clone());
            }
            valueObjectForIntervalTable.valueObjects = arrayList;
            return valueObjectForIntervalTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void initAfterCloning() {
        Iterator iterator = this.valueObjects.iterator();
        while (iterator.hasNext()) {
            ((ValueObjectForInterval)iterator.next()).setTable(this);
        }
    }
}

