/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.hierarchy;

import com.projity.association.Association;
import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import com.projity.grouping.core.LazyParent;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeBridge;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.hierarchy.AbstractMutableNodeHierarchy;
import com.projity.grouping.core.hierarchy.HierarchyUtils;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelUtil;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import com.projity.pm.task.TaskLinkReference;
import com.projity.pm.task.TaskSnapshot;
import com.projity.undo.NodeIndentEdit;
import com.projity.undo.NodeUndoInfo;
import com.projity.util.Alert;
import com.projity.util.Environment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MutableNodeHierarchy
extends AbstractMutableNodeHierarchy {
    public static int DEFAULT_NB_END_VOID_NODES = 50;
    public static int DEFAULT_NB_MULTIPROJECT_END_VOID_NODES = 1;
    private final Node root = NodeFactory.getInstance().createRootNode();
    protected int nbEndVoidNodes = DEFAULT_NB_END_VOID_NODES;
    protected int nbMultiprojectEndVoidNodes = DEFAULT_NB_MULTIPROJECT_END_VOID_NODES;
    protected transient EventListenerList listenerList = new EventListenerList();

    public static boolean isEvent(int n2) {
        return (n2 & 1) == 1;
    }

    public static boolean isUndo(int n2) {
        return (n2 & 2) == 2;
    }

    private void setSubprojectLevel(Node node, int n2) {
        node.setSubprojectLevel(n2);
        int n3 = this.getChildrenSubprojectLevel(node);
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            this.setSubprojectLevel(node2, n3);
        }
    }

    private int getChildrenSubprojectLevel(Node node) {
        if (node == null || node.isRoot()) {
            return 0;
        }
        if (NodeModelUtil.nodeIsSubproject(node)) {
            return node.getSubprojectLevel() + 1;
        }
        return node.getSubprojectLevel();
    }

    public void add(Node node, List list, int n2, int n3) {
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        if (list.size() == 0) {
            return;
        }
        int n4 = this.getChildrenSubprojectLevel(node);
        int n5 = node2.getChildCount();
        if (n2 > n5) {
            NodeFactory nodeFactory = NodeFactory.getInstance();
            for (int i2 = n5; i2 < n2; ++i2) {
                Node node4 = nodeFactory.createVoidNode();
                this.setSubprojectLevel(node4, n4);
                node2.add(node4);
            }
        }
        int n6 = n2;
        for (Node node4 : list) {
            this.setSubprojectLevel(node4, n4);
            if (n2 == -1) {
                node2.add(node4);
                continue;
            }
            node2.insert(node4, n6++);
        }
        if (MutableNodeHierarchy.isEvent(n3)) {
            this.renumber();
            this.fireNodesInserted(this, MutableNodeHierarchy.addDescendants(list));
        }
    }

    public void paste(Node node, List list, int n2, NodeModel nodeModel, int n3) {
        Object object8;
        Node[] nodeArray;
        Node node2 = node == null ? this.root : node;
        Project project = null;
        ResourcePool resourcePool = null;
        if (nodeModel.getDataFactory() instanceof Project) {
            project = (Project)nodeModel.getDataFactory();
        } else if (nodeModel.getDataFactory() instanceof ResourcePool) {
            resourcePool = (ResourcePool)nodeModel.getDataFactory();
        }
        int n4 = this.getChildrenSubprojectLevel(node);
        int n5 = node2.getChildCount();
        if (n2 > n5) {
            NodeFactory nodeFactory = NodeFactory.getInstance();
            nodeArray = nodeFactory.createVoidNode();
            for (int i2 = n5; i2 < n2; ++i2) {
                this.setSubprojectLevel((Node)nodeArray, n4);
                node2.add((MutableTreeNode)nodeArray);
            }
        }
        int n6 = n2;
        for (Node node3 : list) {
            if (!(project != null && node3.getImpl() instanceof Task || resourcePool != null && node3.getImpl() instanceof Resource) && !node3.isVoid()) continue;
            this.setSubprojectLevel(node3, n4);
            if (n2 == -1) {
                node2.add(node3);
                continue;
            }
            node2.insert(node3, n6++);
        }
        nodeArray = MutableNodeHierarchy.addDescendants(list);
        ArrayList arrayList = new ArrayList();
        boolean bl = nodeModel.getDocument() != null && nodeArray.length > 0;
        int n7 = 0;
        if (bl) {
            n7 = nodeModel.getDocument().fireMultipleTransaction(0, true);
        }
        ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeArray.length);
        if (project != null) {
            Task task2;
            Object object22;
            HashMap<Long, Resource> hashMap = new HashMap<Long, Resource>();
            for (Object object22 : project.getResourcePool().getResourceList()) {
                hashMap.put(object22.getUniqueId(), (Resource)object22);
            }
            object8 = null;
            if (Environment.isKeepExternalLinks()) {
                object8 = new HashMap();
                for (Task task2 : project.getTasks()) {
                    ((HashMap)object8).put(task2.getUniqueId(), task2);
                }
            }
            object22 = node != null && node.getImpl() instanceof Task ? ((task2 = (Task)node.getImpl()).isSubproject() ? ((SubProj)((Object)task2)).getSubproject() : task2.getOwningProject()) : (Project)nodeModel.getDataFactory();
            for (int i3 = 0; i3 < nodeArray.length; ++i3) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                if (!(nodeArray[i3].getImpl() instanceof Task)) continue;
                Task task3 = (Task)nodeArray[i3].getImpl();
                Node node4 = this.getParentSubproject((Node)nodeArray[i3].getParent());
                if (node4 != null) {
                    object22 = ((SubProj)node4.getImpl()).getSubproject();
                }
                if (!task3.isExternal()) {
                    task3.setProjectId(((Project)object22).getUniqueId());
                }
                ((Project)object22).validateObject(task3, nodeModel, this, null, false);
                HashSet<Object> hashSet = new HashSet<Object>();
                AssociationList associationList = task3.getDependencyList(true);
                if (associationList != null && associationList.size() > 0 && Environment.isKeepExternalLinks()) {
                    object7 = associationList.iterator();
                    while (object7.hasNext()) {
                        object6 = (Dependency)object7.next();
                        if (!(((Dependency)object6).getPredecessor() instanceof Task)) {
                            object5 = (TaskLinkReference)((Dependency)object6).getPredecessor();
                            object4 = (Task)((HashMap)object8).get(object5.getUniqueId());
                            if (object4 == null) {
                                object7.remove();
                                continue;
                            }
                            ((Dependency)object6).setPredecessor((HasDependencies)object4);
                            ((Task)object4).getSuccessorList().add((Association)object6);
                        }
                        hashSet.add(object6);
                    }
                }
                if ((object7 = task3.getDependencyList(false)) != null && object7.size() > 0 && Environment.isKeepExternalLinks()) {
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (Dependency)object6.next();
                        if (!(((Dependency)object5).getSuccessor() instanceof Task)) {
                            object4 = (TaskLinkReference)((Dependency)object5).getSuccessor();
                            object3 = (Task)((HashMap)object8).get(object4.getUniqueId());
                            if (object3 == null) {
                                object6.remove();
                                continue;
                            }
                            ((Dependency)object5).setSuccessor((HasDependencies)object3);
                            ((Task)object3).getPredecessorList().add((Association)object5);
                        }
                        hashSet.add(object5);
                    }
                }
                arrayList.addAll(hashSet);
                for (int i4 = 0; i4 < Settings.numBaselines(); ++i4) {
                    object5 = (TaskSnapshot)task3.getSnapshot(new Integer(i4));
                    if (object5 == null || ((AssociationList)(object4 = ((TaskSnapshot)object5).getHasAssignments().getAssignments())).size() <= 0) continue;
                    object3 = ((AssociationList)object4).listIterator();
                    while (object3.hasNext()) {
                        Assignment assignment = (Assignment)object3.next();
                        Resource resource = assignment.getResource();
                        if (resource == ResourceImpl.getUnassignedInstance()) continue;
                        Resource resource2 = (Resource)hashMap.get(resource.getUniqueId());
                        if (resource2 != null) {
                            if (!Snapshottable.CURRENT.equals(i4)) continue;
                            if (resource2 != resource) {
                                resource = resource2;
                                assignment.getDetail().setResource(resource);
                            }
                            resource.addAssignment(assignment);
                            NodeUndoInfo nodeUndoInfo = new NodeUndoInfo(false);
                            ((ResourcePool)assignment.getResource().getDocument()).getObjectEventManager().fireCreateEvent(this, assignment, nodeUndoInfo);
                            continue;
                        }
                        assignment.getDetail().setResource(ResourceImpl.getUnassignedInstance());
                    }
                }
                project.initializeId(task3);
                project.addPastedTask(task3);
                arrayList2.add(nodeArray[i3]);
            }
        } else if (resourcePool != null) {
            for (int i5 = 0; i5 < nodeArray.length; ++i5) {
                if (!(nodeArray[i5].getImpl() instanceof Resource)) continue;
                object8 = (Resource)nodeArray[i5].getImpl();
                nodeModel.getDataFactory().validateObject(object8, nodeModel, this, null, false);
                resourcePool.initializeId((Resource)object8);
                arrayList2.add(nodeArray[i5]);
            }
        }
        if (project != null) {
            project.getSchedulingAlgorithm().markBoundsAsDirty();
        }
        if (bl) {
            nodeModel.getDocument().fireMultipleTransaction(n7, false);
        }
        if (MutableNodeHierarchy.isEvent(n3)) {
            this.renumber();
            this.fireNodesInserted(this, arrayList2.toArray(new Node[arrayList2.size()]));
            for (Object object8 : arrayList) {
                DependencyService.getInstance().updateSentinels((Dependency)object8);
                ((Dependency)object8).fireCreateEvent(this);
            }
        }
    }

    private Node getParentSubproject(Node node) {
        if (node.isRoot()) {
            return null;
        }
        if (node.getImpl() instanceof SubProj) {
            return node;
        }
        return this.getParentSubproject((Node)node.getParent());
    }

    public void cleanVoidChildren() {
        this.cleanVoidChildren(this.root);
    }

    private void cleanVoidChildren(Node node) {
        ListIterator listIterator = node.childrenIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.isVoid()) {
                listIterator.remove();
                continue;
            }
            this.cleanVoidChildren(node2);
        }
    }

    public static void addDescendants(Node node, List list) {
        Enumeration<TreeNode> enumeration = ((NodeBridge)node).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
    }

    public static void addDescendants(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MutableNodeHierarchy.addDescendants((Node)iterator.next(), list2);
        }
    }

    private static Node[] addDescendants(List list) {
        ArrayList arrayList = new ArrayList();
        Node[] nodeArray = list.listIterator();
        while (nodeArray.hasNext()) {
            Node node = (Node)nodeArray.next();
            MutableNodeHierarchy.extractSameProjectBranch(node, arrayList);
        }
        nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        return nodeArray;
    }

    private static void extractSameProjectBranch(Node node, ArrayList arrayList) {
        arrayList.add(node);
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            MutableNodeHierarchy.extractSameProjectBranch(node2, arrayList);
        }
    }

    public void remove(List list, NodeModel nodeModel, int n2, boolean bl) {
        if (list != null) {
            boolean bl2 = nodeModel.getDocument() != null && list.size() > 0 && MutableNodeHierarchy.isEvent(n2);
            int n3 = 0;
            if (bl2) {
                n3 = nodeModel.getDocument().fireMultipleTransaction(0, true);
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = new LinkedList();
                this.removeSubTree((Node)iterator.next(), nodeModel, linkedList, n2, bl);
                arrayList.addAll(linkedList);
            }
            if (MutableNodeHierarchy.isEvent(n2)) {
                this.renumber();
                this.fireNodesRemoved(this, arrayList.toArray());
            }
            if (bl2) {
                nodeModel.getDocument().fireMultipleTransaction(n3, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubTree(Node node, NodeModel nodeModel, LinkedList linkedList, int n2, boolean bl) {
        if (this.getUpdateLevel() == 0) {
            try {
                node.removeFromParent();
                this.beginUpdate();
                int n3 = 0;
                LinkedList<TreeNode> linkedList2 = new LinkedList<TreeNode>();
                Enumeration<TreeNode> enumeration = ((NodeBridge)node).postorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    linkedList2.add(enumeration.nextElement());
                }
                for (Node node2 : linkedList2) {
                    if (nodeModel.removeApartFromHierarchy(node2, false, n2, bl)) {
                        linkedList.add(node2);
                        continue;
                    }
                    ++n3;
                }
                node.removeFromParent();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public void removeAll(NodeModel nodeModel, int n2) {
        this.remove(this.buildList(), nodeModel, n2, true);
    }

    public void move(Node node, Node node2, int n2) {
        this.setSubprojectLevel(node, this.getChildrenSubprojectLevel(node2));
        node2.add(node);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = ((NodeBridge)node).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (MutableNodeHierarchy.isEvent(n2)) {
            this.fireNodesChanged(this, arrayList.toArray());
        }
    }

    public void indent(List list, int n2, NodeModel nodeModel, int n3) {
        boolean bl = nodeModel.getDocument() != null;
        int n4 = 0;
        if (bl) {
            n4 = nodeModel.getDocument().fireMultipleTransaction(0, true);
        }
        List list2 = this.internalIndent(list, n2, n3);
        if (bl) {
            nodeModel.getDocument().fireMultipleTransaction(n4, false);
        }
        if (nodeModel.getUndoableEditSupport() != null & MutableNodeHierarchy.isUndo(n3) && list2 != null && list2.size() > 0) {
            nodeModel.getUndoableEditSupport().postEdit(new NodeIndentEdit(nodeModel, list2, n2));
        }
    }

    private List internalIndent(List list, int n2, int n3) {
        if (n2 != 1 && n2 != -1) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        HierarchyUtils.extractParents(list, linkedList);
        ArrayList arrayList = new ArrayList();
        if (n2 > 0) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                if (!this.internalIndent((Node)listIterator.next(), n2, n3 & 2, arrayList)) {
                    listIterator.remove();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listIterator.add(iterator.next());
                }
                arrayList.clear();
            }
        } else {
            ListIterator listIterator = linkedList.listIterator(linkedList.size());
            while (listIterator.hasPrevious()) {
                if (!this.internalIndent((Node)listIterator.previous(), n2, n3 & 2, arrayList)) {
                    listIterator.remove();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listIterator.add(iterator.next());
                }
                arrayList.clear();
            }
        }
        if (MutableNodeHierarchy.isEvent(n3) && linkedList.size() > 0) {
            this.fireNodesChanged(this, linkedList.toArray());
        }
        return linkedList;
    }

    private boolean internalIndent(Node node, int n2, int n3, List list) {
        if (node == null || node == this.root || !node.isIndentable(n2)) {
            return false;
        }
        if (n2 == 1) {
            Node node2 = this.getParent(node);
            int n4 = node2.getIndex(node);
            if (n4 == 0) {
                return false;
            }
            Node node3 = null;
            Iterator iterator = node2.childrenIterator(n4);
            while (iterator.hasPrevious()) {
                Node node4 = (Node)iterator.previous();
                if (node.canBeChildOf(node4)) {
                    node3 = node4;
                    break;
                }
                if (!node4.isVoid()) continue;
                list.add(node4);
            }
            if (node3 == null || node3.getImpl() instanceof Assignment) {
                return false;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                node3.add((Node)iterator.next());
            }
            node3.add(node);
            if (MutableNodeHierarchy.isEvent(n3)) {
                this.fireNodesChanged(this, new Node[]{node});
            }
        } else if (n2 == -1) {
            Object object;
            Node node5 = this.getParent(node);
            if (node5 == null || node5 == this.root) {
                return false;
            }
            if (node5.isLazyParent()) {
                return false;
            }
            Node node6 = this.getParent(node5);
            int n5 = node5.getIndex(node);
            if (n5 > 0) {
                ListIterator listIterator = node5.childrenIterator(n5);
                while (listIterator.hasPrevious() && (object = (Node)listIterator.previous()).isVoid()) {
                    list.add(object);
                }
            }
            n5 = node6.getIndex(node5) + 1;
            node6.insert(node, n5);
            object = list.iterator();
            while (object.hasNext()) {
                node6.insert((Node)object.next(), n5);
            }
            if (MutableNodeHierarchy.isEvent(n3)) {
                this.fireNodesChanged(this, new Node[]{node});
            }
        }
        return true;
    }

    public void fireUpdate() {
        this.fireStructureChanged(this);
    }

    public void fireUpdate(Node[] nodeArray) {
        this.fireNodesChanged(this, nodeArray);
    }

    public void fireInsertion(Node[] nodeArray) {
        this.fireNodesInserted(this, nodeArray);
    }

    public void fireRemoval(Node[] nodeArray) {
        this.fireNodesRemoved(this, nodeArray);
    }

    public Node getParent(Node node) {
        if (node == null) {
            return null;
        }
        return (Node)node.getParent();
    }

    public List getChildren(Node node) {
        return node == null ? this.root.getChildren() : node.getChildren();
    }

    public int getLevel(Node node) {
        int n2 = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n2;
            node2 = this.getParent(node2);
        }
        return n2 - 1;
    }

    private List buildList() {
        return this.buildList(null);
    }

    private List buildList(Node node) {
        ArrayList arrayList = new ArrayList();
        this.buildList(node, arrayList);
        return arrayList;
    }

    private void buildList(Node node, List list) {
        List list2;
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        if (node2 != this.root) {
            list.add(node2);
        }
        if ((list2 = this.getChildren(node2)) != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.buildList((Node)iterator.next(), list);
            }
        }
    }

    private Node searchPrevious(Node node) {
        if (node == null || node == this.root) {
            return null;
        }
        Node node2 = this.getParent(node);
        List list = this.getChildren(node2);
        if (list == null) {
            return null;
        }
        for (Node node3 : list) {
            if (node3.equals(node)) {
                return node2;
            }
            node2 = node3;
        }
        return null;
    }

    private Node searchLast(Node node) {
        Node node2;
        Node node3 = node2 = node == null ? this.root : node;
        while (!this.isLeaf(node2)) {
            List list = this.getChildren(node2);
            node2 = (Node)list.get(list.size() - 1);
        }
        return node2;
    }

    private Node searchLast(int n2) {
        Node node = null;
        for (int i2 = 0; !this.isLeaf(node) && i2 < n2; ++i2) {
            List list = this.getChildren(node);
            node = (Node)list.get(list.size() - 1);
        }
        return node;
    }

    private boolean contains(Object object) {
        Alert.error("contains not implemented");
        return false;
    }

    public Object clone() {
        Alert.error("clone not implemented");
        return null;
    }

    public Node search(Object object, Comparator comparator) {
        return this.search(this.root, object, comparator);
    }

    private Node search(Node node, Object object, Comparator comparator) {
        if (comparator.compare(node == null ? this.root : node, object) == 0) {
            return node;
        }
        List list = this.getChildren(node);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node2 = this.search((Node)iterator.next(), object, comparator);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public boolean isSummary(Node node) {
        List list = this.getChildren(node);
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((Node)iterator.next()).getImpl() instanceof Assignment) continue;
            return true;
        }
        return false;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        List list = this.getChildren((Node)object);
        return list == null || list.size() == 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Node node = (Node)treePath.getLastPathComponent();
    }

    protected boolean checkSubprojectEndVoidNodes(Node node, List list) {
        Node node2;
        int n2 = 0;
        boolean bl = false;
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            node2 = (Node)enumeration.nextElement();
            if (this.checkSubprojectEndVoidNodes(node2, list)) {
                bl = true;
            }
            if (!NodeModelUtil.nodeIsSubproject(node)) continue;
            if (node2.isVoid()) {
                ++n2;
                continue;
            }
            n2 = 0;
        }
        if (NodeModelUtil.nodeIsSubproject(node)) {
            Object object;
            int n3 = this.nbMultiprojectEndVoidNodes;
            if (node.getImpl() instanceof SubProj && (object = ((SubProj)node.getImpl()).getSubproject()) != null && ((Project)object).isReadOnly()) {
                n3 = 0;
            }
            if (n2 < n3 && (object = (LazyParent)node.getImpl()).isDataFetched()) {
                int n4 = this.getChildrenSubprojectLevel(node);
                for (int i2 = 0; i2 < this.nbMultiprojectEndVoidNodes - n2; ++i2) {
                    node2 = NodeFactory.getInstance().createVoidNode();
                    this.setSubprojectLevel(node2, n4);
                    node.add(node2);
                    list.add(node2);
                }
            }
        }
        return bl;
    }

    public void checkEndVoidNodes(int n2) {
        this.checkEndVoidNodes(false, n2);
    }

    public void checkEndVoidNodes(boolean bl, int n2) {
        Node node;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (!bl) {
            this.checkSubprojectEndVoidNodes(this.root, arrayList);
        }
        int n3 = bl ? this.nbMultiprojectEndVoidNodes : this.nbEndVoidNodes;
        int n4 = 0;
        ListIterator listIterator = this.root.childrenIterator(this.root.getChildCount());
        while (listIterator.hasPrevious() && (node = (Node)listIterator.previous()).isVoid()) {
            ++n4;
        }
        if (n4 < n3) {
            for (int i2 = 0; i2 < n3 - n4; ++i2) {
                node = NodeFactory.getInstance().createVoidNode();
                this.root.add(node);
                arrayList.add(node);
            }
        } else if (n4 > n3) {
            int n5 = n4 - n3;
            ListIterator listIterator2 = this.root.childrenIterator(this.root.getChildCount());
            while (listIterator2.hasPrevious() && (node = (Node)listIterator2.previous()).isVoid()) {
                listIterator2.remove();
                if (--n5 != 0) continue;
            }
        }
        if (MutableNodeHierarchy.isEvent(n2) && arrayList.size() > 0) {
            this.fireNodesInserted(this, arrayList.toArray());
        }
    }

    public int getNbEndVoidNodes() {
        return this.nbEndVoidNodes;
    }

    public void setNbEndVoidNodes(int n2) {
        if (n2 == -1) {
            n2 = DEFAULT_NB_END_VOID_NODES;
        }
        this.nbEndVoidNodes = n2;
    }
}

