﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BTS.Trac.TestConsole
{
    using TicketType = TracNameAndValueField<ITicketType>;
    using Severity = TracNameAndValueField<ISeverity>;
    using Resolution = TracNameAndValueField<IResolution>;
    using Priority = TracNameAndValueField<IPriority>;
    using Status = TracNameAndValueField<IStatus>;

    class Program
    {
        static void Main( string[] args )
        {
            try {
                Trac.Connect( "http://cf-r5:8080/trac/TicketImportSample", "kaorun", "kaorun" );
                //testSystem();
                testWiki();
                //testTicketDelete();
                //testTicket();
                //testTicketMilestone();
                //testTicketType();
                //testSeverity();
                //testResolution();
                //testPriority();
                //testStatus();
                //testComponent();
                //testVersion();
            }
            catch ( Exception ex ) {
                Console.WriteLine( "Error : " + ex.Message );
            }
        }

        static void testVersion()
        {
            string[] versionNames = Version.GetAll();
            foreach ( string versionName in versionNames ) {
                Version version = new Version( versionName );
                Console.WriteLine( version.Name );
                Console.WriteLine( version.Description );
                Console.WriteLine( version.ReleaseDate.ToString() );
                version.Update();
            }

            Version newVersion = new Version();
            newVersion.Description = "詳細";
            newVersion.ReleaseDate = DateTime.Now;
            newVersion.Create( "新しいバージョン" );

            newVersion.Description = "詳細を変更";
            newVersion.ReleaseDate = DateTime.Today;
            newVersion.Update();

            newVersion.Update( "名称を変更" );

            newVersion.Delete();
        }

        static void testComponent()
        {
            string[] componentNames = Component.GetAll();
            foreach ( string componentName in componentNames ) {
                Component component = new Component( componentName );
                Console.WriteLine( component.Name );
                Console.WriteLine( component.Owner );
                Console.WriteLine( component.Description );
            }

            Component newConponent = new Component();
            newConponent.Owner = "kaorun";
            newConponent.Description = "詳細";
            newConponent.Create( "新しいコンポーネント" );

            newConponent.Description = "詳細を変更";
            newConponent.Update();

            newConponent.Update( "名称を変更" );

            newConponent.Delete();
        }

        static void testStatus()
        {
            string[] statusNames = Status.GetAll();
            foreach ( string statusName in statusNames ) {
                Status status = new Status( statusName );
                Console.WriteLine( status.Name );
                Console.WriteLine( status.Value );
                //Console.WriteLine( statusName );
            }

            //string Name = "test";
            //Status newStatus = new Status();
            //newStatus.Value = "insert";
            //newStatus.Create( Name );

            //newStatus.Value = Name + "2";
            //newStatus.Update();

            //newStatus.Delete();
        }

        static void testPriority()
        {
            string[] priorityNames = Priority.GetAll();
            foreach ( string priorityName in priorityNames ) {
                Console.WriteLine( priorityName );

                Priority priority = new Priority( priorityName );
            }

            string Name = "test";
            Priority newPriority = new Priority();
            newPriority.Value = "10";
            newPriority.Create( Name );

            newPriority.Value = "11";
            newPriority.Update();

            newPriority.Delete();
        }
        
        static void testResolution()
        {
            string[] resolutionNames = Resolution.GetAll();
            foreach ( string resolutionName in resolutionNames ) {
                Console.WriteLine( resolutionName );

                Resolution resolution = new Resolution( resolutionName );
            }

            string Name = "test";
            Resolution newResolution = new Resolution();
            newResolution.Value = "10";
            newResolution.Create( Name );

            newResolution.Value = "11";
            newResolution.Update();

            newResolution.Delete();
        }

        static void testSeverity()
        {
            string[] severityNames = Severity.GetAll();
            foreach ( string severityName in severityNames ) {
                Severity.Delete( severityName );
            }

            string Name = "XML-Trac.rpc からの重要度";
            Severity newSeverity = new Severity();
            newSeverity.Value = "3";
            newSeverity.Create( Name );

            Severity getSeverity = new Severity( "aaa" );

            //Severity getSeverity = new Severity( Name );
            //getSeverity.No = 4;
            //getSeverity.Update();
            //getSeverity.Delete();
        }

        static void testTicketType()
        {
            string[] ticketTypeNamess = TicketType.GetAll();
        }

        static void testTicketMilestone()
        {
            string[] milestoneNames = Milestone.GetAll();
            foreach ( string milestoneName in milestoneNames ) {
                Milestone milestone = new Milestone( milestoneName );
                Console.WriteLine( milestone.Name );
                //Console.WriteLine( milestone.Description );
                //Console.WriteLine( milestone.Due.ToString() );
                //Console.WriteLine( milestone.Conmleted.ToString() );
                Console.WriteLine( "" );
                //milestone.Delete();
            }

            DateTime now = DateTime.Now;
            Milestone newMilestone = new Milestone();
            //newMilestone.Name = "XML-Trac.rpc マイルストーン";
            //newMilestone.Description = "XML-Trac.rpc から取得されたマイルストーン";
            ////newMilestone.Due = now;
            //newMilestone.Delete();
            //newMilestone.Create();

            string[] newMilestoneNames = Milestone.GetAll();
            Milestone updateMilestone = new Milestone( newMilestoneNames[0] );
            //updateMilestone.Name = "マイルストーンの更新";

            updateMilestone.Update();

            updateMilestone.Delete();
        }

        static void testTicketDelete()
        {
            int[] tickets = Ticket.Query( "status!=closed" );
            foreach ( int ticketId in tickets ) {
                Ticket ticket = new Ticket( ticketId );
                ticket.Delete();
            }
        }

        static void testTicket()
        {
            Ticket.GetTicketFields();
            int[] tickets = Ticket.Query( "status != closed" );
            foreach ( int ticketId in tickets ) {
                Console.WriteLine( "ID : " + ticketId.ToString() );
                Ticket ticket = new Ticket( ticketId );
                ticket.ChangeLog();
                ticket.GetAvailableActions();
                TicketAttachment[] attachments = ticket.ListAttachments();
                if ( attachments != null ) {
                    foreach ( TicketAttachment attachment in attachments ) {
                        attachment.Get();
                    }
                }

                string filename = "BTS.Trac.xml";
                TicketAttachment newAttachments = new TicketAttachment( ticket );
                newAttachments.Put( filename, "XML-Trac.rpc テスト", true );
                newAttachments.Delete();
            }

            //Ticket newTicket = new Ticket();
            //newTicket.Summary = "XML_Trac.rpc から登録";
            //newTicket.Description = "登録だよん";
            //newTicket.Create();

            //Console.WriteLine( "new id : " + newTicket.ID.ToString() );
            //newTicket.Summary = "概要こうしん";
            //newTicket.Update( "XML_Trac.rpc で更新" );

            //newTicket.Delete();
        }

        static void testWiki()
        {
            Console.WriteLine( "version : " + Wiki.GetRpcVersionSupported().ToString() );

            string[] pageNames = Wiki.GetAllPages();
            foreach ( string pageName in pageNames ) {
                Console.WriteLine( pageName );
            }

            Wiki wiki = new Wiki( pageNames[0] );
            wiki.GetInfo();
            string page = wiki.Get();
            wiki.ListAttachments();

            Wiki newPage = new Wiki();
            newPage.Author = "kaorun";
            newPage.Comment = "新しいページを追加";
            newPage.Create( "新しいページ", "nnn" );
            newPage.Update( "bbb" );
            page = newPage.Get();

            WikiAttachment attache = new WikiAttachment( newPage );
            attache.Create( "BTS.Trac.XML", "添付ファイル" );
            string updata = "変更されたデータ";

            List<WikiAttachment> attachemnts = newPage.ListAttachments();

            attache.Update( Encoding.ASCII.GetBytes( updata ) );
            byte[] data = attache.Get();
            attache.Delete();

            newPage.Delete();
        }

        static void testSystem()
        {
            Console.Write( "API Version : " );
            string versions = TracXmlRpcSystem.GetAPIVersion();
            Console.WriteLine( versions );

            string[] methods = TracXmlRpcSystem.ListMethods();
            //foreach ( string method in methods ) {
            //    Console.WriteLine( method );
            //}

            Console.WriteLine( methods[0] );
            Console.WriteLine( TracXmlRpcSystem.GetMethodHelp( methods[0] ) );
            string[] methodSignatures = TracXmlRpcSystem.GetMethodSignature( methods[0] );
            foreach ( string methodSignature in methodSignatures ) {
                Console.WriteLine( methodSignature );
            }
        }
    }
}
