﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Meyn.TestLink;
using CookComputing.XmlRpc;

namespace BTS.Trac.Test
{
    [TestFixture]
    [TestLinkFixture(
        Url = TestLinkConnect.Url,
        ProjectName = TestLinkConnect.ProjectName,
        UserId = TestLinkConnect.UserId,
        TestPlan = TestLinkConnect.TestPlan,
        TestSuite = TestLinkConnect.TestSuite,
        DevKey = TestLinkConnect.DevKey )]
    public class WikiTest
    {
        [SetUp]
        public void SetUp()
        {
            Trac.Connect( TracConnect.Url, TracConnect.UserName, TracConnect.Password );

            // 最初にすべて削除しておく
            string[] pageNames = Wiki.GetAllPages();
            foreach ( string pageName in pageNames ) {
                Wiki.Delete( pageName );
            }
        }

        [TearDown]
        public void TearDown()
        {
            Trac.Close();
        }

        [Test]
        public void Wikiの作成と取得()
        {
            string pageName = "新しいWikiページ";
            string contents = "aaa";

            int before = Wiki.GetAllPages().Length;

            Wiki newWiki = new Wiki();
            newWiki.Author = "kaorun";
            newWiki.Comment = "登録テスト";
            newWiki.Create( pageName, contents );

            int after = Wiki.GetAllPages().Length;

            Assert.AreEqual( before + 1, after );

            Wiki getWiki = new Wiki( pageName );

            Assert.AreEqual( newWiki.Name, getWiki.Name );
            Assert.AreEqual( newWiki.Author, getWiki.Author );
            Assert.AreEqual( newWiki.Comment, getWiki.Comment );
            Assert.AreEqual( contents, getWiki.Get() );
        }

        [Test]
        public void Wikiの作成と削除()
        {
            string pageName = "新しいWikiページ";
            string contents = "aaa";

            int before = Wiki.GetAllPages().Length;

            Wiki newWiki = new Wiki();
            newWiki.Author = "kaorun";
            newWiki.Comment = "登録テスト";
            newWiki.Create( pageName, contents );

            Assert.AreEqual( before + 1, Wiki.GetAllPages().Length );

            Wiki.Delete( pageName );

            Assert.AreEqual( before, Wiki.GetAllPages().Length );
        }
    }
}
