<?php 
include ("../set_session.php");
session_start();
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/display.php");
include ("../classes/form.php");

function parse_csv($line) {
	preg_match_all('/("[^"]*(?:""[^"]*)*"|[^,]*),?/', $line, $a);
	foreach($a[1] as $key => $value) {
		if(preg_match('/^"(.*)"$/', $value, $value2)) {
			$a[1][$key] = preg_replace('/""/', '"', $value2[1]);
		}
	}
	return $a[1];
}

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Admin',$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
</head>

<body>
<?php

$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$display->displayTitle($lang->log_title);

$path = "../log/loginlog.php";

if(!File_Exists($path)){
	echo "OL^܂B";
	die;
}

$hWriteLog = fopen($path, "r+" ) or die ("login Check Script Error!!");
$data = array();

while (!feof ($hWriteLog)) {
    $buffer = fgets($hWriteLog, 4096);
    $oneline = parse_csv($buffer);
	$oneline[0] = date("Y/m/d H:i",(int)$oneline[0]);
	
	//for modification
	$temp_one = array(
		$oneline[0], //log date
		$oneline[1], //log id
		//$oneline[2], //log password
		$oneline[3], //log succeed
		$oneline[4], //log host
		$oneline[5],   //log ip
		//$oneline[6]  //log agent
		
	);
	
	//$data[] = $oneline;
	$data[] = $temp_one;
}

array_pop($data);

array_pop($data); // Cut Last Line
array_shift($data); // Cut Top Line
reset($data);

fclose($hWriteLog);

$tableheaders = array(
	$lang->log_date,
	$lang->log_id,
	//$lang->log_pass,
	$lang->log_succeed,
	$lang->log_host,
	$lang->log_IP,
	//$lang->log_agent
);

$display->displayTable_horizontal($tableheaders,$data,700);
//print_r($data);

?>
