<?php 

include ("../set_session.php");
session_start();

header("Content-Type: text/html; charset=Shift-JIS");
header("Expires: Thu, 01 Dec 1994 16:00:00 GMT");
header("Last-Modified: ". gmdate("D, d M Y H:i:s"). " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/display.php");
include ("../classes/form.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

setlocale(LC_ALL, 'ja_JP.eucJP');

?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
<SCRIPT LANGUAGE="Javascript">
<!---
function decision(message, url)
{
  if(confirm(message) )
  {
    location.href = url;
  }
}

function go_Prt(){
	document.receipt.submit();
}

function change_name() {
  yy = rsv.rsv_year.value;
  mm = rsv.rsv_month.value;
  dd = rsv.rsv_date.value;
  if(mm.length == 1) mm = "0" + mm;
  if(dd.length == 1) dd = "0" + dd;
  changedate.rs_date.value = yy + "-" + mm + "-" + dd;
  changedate.sale_name.value = rsv.sale_name.value;
  changedate.submit();
}

function change_date() {
  yy = rsv.rsv_year.value;
  mm = rsv.rsv_month.value;
  dd = rsv.rsv_date.value;
  if(mm.length == 1) mm = "0" + mm;
  if(dd.length == 1) dd = "0" + dd;
  changedate.rs_date.value = yy + "-" + mm + "-" + dd;
  changedate.sale_name.value = "";
  changedate.submit();
}

function goToday() {

  mydate=new Date();
  yy = mydate.getFullYear();
  mm = mydate.getMonth()+1;
  dd = mydate.getDate();
  if(mm.length == 1) mm = "0" + mm;
  if(dd.length == 1) dd = "0" + dd;
  changedate.rs_date.value = yy + "-" + mm + "-" + dd;
  changedate.sale_name.value = "";
  changedate.submit();
}

// --->
</SCRIPT> 
</head>
<body>
<form name="changedate" method="POST">
<input type="hidden" name="rs_date" value="">
<input type="hidden" name="act" value="search">
<input type="hidden" name="sale_name" value="">
</form>

<?php

$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

//If you are selling to somebody, you can not execute this page....
if(!empty($_SESSION['current_sale_customer_id'])){
///////////////////////////////////////////////////////////
echo <<<EOD
<script type="text/javascript" language="javascript">
<!--

function getKeyCode(e) {
   if( (_getKEYCODE(e)==13) ){
	location.href = "sale_ui.php";
   }
}

//--ꂽL|R[hԂ
function _getKEYCODE(e){
  var ua = navigator.userAgent
  if(ua.search('opera(\ |\/)6')!=-1)  //o6s
    return null
  else if(document.layers)            //n4p
    return  e.which
  else if(document.all)               //e4,e5,e6,o7,s1p
    return  event.keyCode
  else if(document.getElementById)    //n6,n7,mozp
    return  e.which
  else return null                    //LȊO
}

window.document.onkeypress=getKeyCode;

//-->
</script>
EOD;
$display->displayTitle("$lang->manageSales");
echo "<center><B>".$lang->already_sale_started."</B></center>";
echo "<br><center><font size=\"2\">".$lang->enter_then_return."</font></center>\n";
die;
////////////////////////////////////////////////////////////
}

echo "<SCRIPT TYPE=\"text/javascript\" SRC=\"../classes/keynavi_ja.js\"></SCRIPT>";

$sales_table="$cfg_tableprefix"."sales";

//Determine Date....
if(isset($_POST['rs_date'])){ //if specified...
	$search_date = $_POST['rs_date'];
	$sale_name = $_POST['sale_name'];
	$_SESSION['mgs_date'] = $search_date;
	$_SESSION['mgs_name'] = $sale_name;
} else {
	
	if(isset($_SESSION['mgs_date'])){
		$search_date = $_SESSION['mgs_date']; //not first time...
		$sale_name = $_SESSION['mgs_name'];
	} else {
		$search_date = date("Y-m-d", time()); //today's date.
		$sale_name = '';
	}
}

//echo "sale_name=".$sale_name;

$saledata = $display->displaySalebyDate("$cfg_tableprefix",$search_date);

function put_narrowdown()
{
	global $lang;
	global $dbf;
	global $search_date;
	global $saledata;
	global $sale_name;
	
	print "<FORM NAME=\"rsv\" METHOD=\"post\"><table ALIGN='center' BORDER><tr><td>";

	$time1 = strtotime($search_date);
	$sel_year = date("Y",$time1);
	$sel_month = date("m",$time1);
	$sel_date = date("d",$time1);

	if(isset($_POST['rsv_year'])){
		$sel_year = $_POST['rsv_year'];
		$sel_month = $_POST['rsv_month'];
		$sel_date = $_POST['rsv_date'];
		$_SESSION['mgs_year']= $sel_year;
		$_SESSION['mgs_month']= $sel_month;
		$_SESSION['mgs_date']= $sel_date;
	} else {
		if(isset($_SESSION['mgs_year'])){
			$sel_year = $_SESSION['mgs_year'];
			$sel_month = $_SESSION['mgs_month'];
			$sel_date = $_SESSION['mgs_date'];
		}
	}

	$year_list = $dbf->getSaleYearBetween();
	
    //year
	print "<SELECT NAME='rsv_year' onChange=\"change_date()\" value='2004'>\n";
	//print "<SELECT NAME='rsv_year' value='$sel_year'>\n";
	for( $i=$year_list[0]; $i<($year_list[1]+1); $i++){
		$temp_val =  "<option value='".$i."'";
		if($i==$sel_year){
			$temp_val .= " SELECTED ";
		}
		$temp_val .= ">".$i."\n";
		print $temp_val;
	}
	print "</SELECT>-";

    //month
	print "<SELECT NAME='rsv_month' onChange=\"change_date()\" value='1'>\n";
	//print "<SELECT NAME='rsv_month' value='$sel_month'>\n";
	$temp_val = "";
	for( $i=1; $i<13; $i++){
		$temp_val =  "<option value='".$i."'";
		if($i==$sel_month){
			$temp_val .= " SELECTED ";
		}
		$temp_val .= ">".$i."\n";
		print $temp_val;
	}
	print "</SELECT>-";

    //date
	print "<SELECT NAME='rsv_date' onChange=\"change_date()\" value='1'>\n";
	//print "<SELECT NAME='rsv_date' value='$sel_date'>\n";
	$temp_val = "";
	for( $i=1; $i<32; $i++){
		$temp_val =  "<option value='".$i."'";
		if($i==$sel_date){
			$temp_val .= " SELECTED ";
		}
		$temp_val .= ">".$i."\n";
		print $temp_val;
	}
	print "</SELECT>";


	print "</td></tr>\n";
	
	print "<tr><td>";
	
	$names = array();
	$names[] = $lang->cust_name;
	for ($i=0; $i < count($saledata); $i++){
		$one_array = $saledata[$i];
		
		if(array_search($one_array[2],$names) == NULL){
			$names[] = $one_array[2];
		}
		
	}
	print "<SELECT NAME='sale_name' value='' onChange=\"change_name()\">\n";
	$temp_val="";
	for( $i=0; $i<count($names); $i++ ){
		$temp_val = "<option value='".$names[$i]."'";
		if( strcasecmp($names[$i],$sale_name) == 0){
			$temp_val .= " SELECTED ";
		}
		$temp_val .= ">".$names[$i]."\n";
		print $temp_val;
	}

	
	print "</td></tr>";
	
	print "<tr><td>";
	//print "<INPUT Type=\"button\" Value=\"".$lang->mes_search."\" OnClick=\"change_date()\">";
	print "<INPUT Type=\"button\" Value=\"".$lang->saleoftoday."\" OnClick=\"goToday()\">";
	print "</td></tr>";
	
	print "</table></FORM>\n";
}


/*
echo "<form action='manage_sales.php' method='POST' name='sales'>\n";
echo "<input type='hidden' name='srhbydate' value='{$today_date}'>";
echo "<center><input type='submit' value='$lang->saleoftoday'></center>";
echo "</form>\n";
*/
/*
	var $sort_name = "Oݏ";
	var $sort_time = "ԏ";
	var $sort_locker = "bJ[";
	var $sort_id = "ID";
$f1->createSelectField("$lang->in_sex",'sex',$sex_option_values,$sex_option_titles,'150');

$sort_option_titles = array(
	$lang->sort_time,
	$lang->sort_time,
	$lang->sort_name,
	//$lang->sort_locker,
	$lang->sort_id
	);
	
$sort_option_values = array(
	1,
	1,
	2,
	//3,
	4
	);
*/
/*
$f1=new form('manage_sales.php','POST','sales','450',$cfg_theme,$lang);
$f1->createInputField("<b>$lang->searchForSale</b>",'text','srhbysale',"",'24','350');
$f1->createInputField("<b>$lang->searchBycusID</b>",'text','srhbycusid',"",'24','350');
$f1->createInputField("<b>$lang->searchBydate</b> (ex. 2005/11/12)",'text','srhbydate',"",'24','350');
$f1->createInputField("<b>$lang->searchBylocker</b>",'text','srhbylocker',"",'24','350');
$f1->createSelectField("<b>$lang->sort_title</b>",'sort',$sort_option_values,$sort_option_titles,'350');
$f1->endForm();
*/

//$display->displaySalelist("$cfg_tableprefix",$sale_id,$cus_id,$sale_date);
//	function createInputField($field_title,$input_type,$input_name,$input_value,$input_size,$td_width,$ime_switch="0")

/*
$orderby = " id DESC ";

if(!empty($_POST['srhbysale']))
{
	$tempID=$_POST['srhbysale'];
	echo "<center>$lang->searchForSale ID=<b>$tempID</b></center>";
	$display->displaySalelist("$cfg_tableprefix",$tempID,'','',$orderby);
}
elseif(!empty($_POST['srhbycusid']))
{
	$tempID=$_POST['srhbycusid'];
	echo "<center>$lang->searchBycusID ID=<b>$tempID</b></center>";
	$display->displaySalelist("$cfg_tableprefix",'',$tempID,'',$orderby);
}
elseif(!empty($_POST['srhbydate']))
{
	$tempID=$_POST['srhbydate'];
	echo "<center>$lang->searchBydate DATE=<b>$tempID</b></center>";
	$conv_tempID = strtr($tempID,"/","-");
	$display->displaySalelist("$cfg_tableprefix",'','',$conv_tempID,$orderby);
}
elseif(!empty($_POST['srhbylocker']))
{
	$locker_num = $_POST['srhbylocker'];

	if(!$dbf->isLockerUsed($locker_num))
	{
		 echo "<center><B>{$lang->lockernum}[{$locker_num}]{$lang->isNotUsed}</B></center>";
	}
	else
	{
		$tempID=$dbf->lockertocustomer_id($locker_num);
		
		echo "<center>$lang->searchBylocker LOCKER=<b>$locker_num</b></center>";
		$display->displaySalelist("$cfg_tableprefix",'',$tempID,'',$orderby);
	}
}
else
{
	echo "<center>$lang->latest50</center>";
	$display->displaySalelist("$cfg_tableprefix",'','','',$orderby);
}
*/

/////////////////////////////////////
// new version.... 2005/4

	$sales_tableheaders=array(
		"{$lang->saleID}",
		"{$lang->date}",
		"{$lang->customerName}",
		"{$lang->customers_50}",
		"{$lang->itemsPurchased}",
		"{$lang->paidWith}",
		"{$lang->paymentstatus}",
		"{$lang->soldBy}",
		"{$lang->lockernum}",
		"{$lang->checkin}",
		"{$lang->saleTotalCost}",
		"{$lang->saleComment}",
		"{$lang->detail}",
		"{$lang->delete}",
		"{$lang->print_account}"
		);

$display->displayTitle("$lang->manageSales");

//sort *************************************
if(isset($_GET['sort'])){
	$sort = $_GET['sort'];
}

function nameCmp($p1,$p2){
	return strcasecmp($p1[3],$p2[3]);
}

function idCmp($p1,$p2){
	return strnatcasecmp($p1[0],$p2[0]);
}

function lockerCmp($p1,$p2){
	return strnatcasecmp($p1[8],$p2[8]);
}


$filename = basename($_SERVER['SCRIPT_NAME']);
$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";


if($sort=='name'){
	$link = "$lang->sort_name[1] / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
	if(count($saledata)){
		usort($saledata,nameCmp);
	}
}
elseif($sort=='locker') {
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / $lang->sort_locker[4]";
	if(count($saledata)){
		usort($saledata,lockerCmp);
	}

}
elseif($sort=='rtime'){
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / $lang->sort_rtime[3] / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
	if(count($saledata)){
		usort($saledata,idCmp);
	}

}
else{
	//time
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / $lang->sort_time[2] / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
}
//////////////////////////////////////////////////////////////////////////

//////////////////
// View 

put_narrowdown();
echo "<BR><center>".$link."</center><BR>\n";

//extract
if( strlen(trim($sale_name)) && (strcasecmp($sale_name,$lang->cust_name) != 0) ){
	$saledata2 = array();
	for($i=0; $i<count($saledata); $i++){
		$one_array = $saledata[$i];
		if( strcasecmp($one_array[2],$sale_name) == 0){
			$saledata2[] = $one_array;
		}
	}
	$saledata = $saledata2;
}


$display->displayTable_horizontal($sales_tableheaders,$saledata,900,'../sales/sales_print_helper.php','POST');
	
$dbf->closeDBlink();


?>
</body>
</html>