<?php 

include ("../set_session.php");
session_start();

header("Content-Type: text/html; charset=Shift-JIS");
header("Expires: Thu, 01 Dec 1994 16:00:00 GMT");
header("Last-Modified: ". gmdate("D, d M Y H:i:s"). " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/display.php");
include ("../classes/form.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

setlocale(LC_ALL, 'ja_JP.eucJP');

?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">

<?php

$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

//If you are selling to somebody, you can not execute this page....
if(!empty($_SESSION['current_sale_customer_id'])){
///////////////////////////////////////////////////////////
echo <<<EOD
<script type="text/javascript" language="javascript">
<!--

function getKeyCode(e) {
   if( (_getKEYCODE(e)==13) ){
	location.href = "sale_ui.php";
   }
}

//--ꂽL|R[hԂ
function _getKEYCODE(e){
  var ua = navigator.userAgent
  if(ua.search('opera(\ |\/)6')!=-1)  //o6s
    return null
  else if(document.layers)            //n4p
    return  e.which
  else if(document.all)               //e4,e5,e6,o7,s1p
    return  event.keyCode
  else if(document.getElementById)    //n6,n7,mozp
    return  e.which
  else return null                    //LȊO
}

window.document.onkeypress=getKeyCode;

//-->
</script>
EOD;
$display->displayTitle("$lang->manageSales");
echo "<center><B>".$lang->already_sale_started."</B></center>";
echo "<br><center><font size=\"2\">".$lang->enter_then_return."</font></center>\n";
die;
////////////////////////////////////////////////////////////
}


echo "<SCRIPT TYPE=\"text/javascript\" SRC=\"../classes/keynavi_ja.js\"></SCRIPT>";

$sales_table="$cfg_tableprefix"."sales";

if(isset($_POST['go_check']) or isset($_GET['sort'])){

	$sales_tableheaders=array(
		"{$lang->saleID}",
		"{$lang->date}",
		"{$lang->customerName}",
		"{$lang->customers_50}",
		"{$lang->itemsPurchased}",
		"{$lang->paidWith}",
		"{$lang->paymentstatus}",
		"{$lang->soldBy}",
		"{$lang->lockernum}",
		"{$lang->checkin}",
		"{$lang->saleTotalCost}",
		"{$lang->saleComment}",
		"{$lang->detail}",
		"{$lang->delete}",
		"{$lang->print_account}"
		);

	$query = "SELECT id FROM $sales_table WHERE ispaid = '0' ORDER BY id DESC ";
	$result = mysql_query($query, $dbf->conn) or die(mysql_error());

	$total_array = array();
	while($row=mysql_fetch_assoc($result)){

		$tmp_id = $row['id'];
		//echo $tmp_id." ";
		$one_array = $display->getOneSale($cfg_tableprefix,$tmp_id);
		//print_r($one_array);
		array_push($total_array,$one_array);
	}

	$saledata = $total_array;

//print_r($saledata);

//sort *************************************
if(isset($_GET['sort'])){
	$sort = $_GET['sort'];
	//echo $sort;
}

function nameCmp($p1,$p2){
	return strcasecmp($p1[3],$p2[3]);
}

function idCmp($p1,$p2){
	return strnatcasecmp($p1[0],$p2[0]);
}

function lockerCmp($p1,$p2){
	return strnatcasecmp($p1[8],$p2[8]);
}


$filename = basename($_SERVER['SCRIPT_NAME']);
$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";

if($sort=='name'){
	$link = "$lang->sort_name[1] / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
	if(count($saledata)){
		usort($saledata,nameCmp);
	}
}
elseif($sort=='locker') {
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / $lang->sort_locker[4]";
	if(count($saledata)){
		usort($saledata,lockerCmp);
	}

}
elseif($sort=='rtime'){
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / <a href='".$filename."?sort=time'>$lang->sort_time[2]<a> / $lang->sort_rtime[3] / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
	if(count($saledata)){
		usort($saledata,idCmp);
	}

}
else{
	//time
	$link = "<a href='".$filename."?sort=name'>$lang->sort_name[1]<a> / $lang->sort_time[2] / <a href='".$filename."?sort=rtime'>$lang->sort_rtime[3]<a> / <a href='".$filename."?sort=locker'>$lang->sort_locker[4]<a>";
}

echo $link;

	$display->displayTitle("̎Xg");
	echo "<center>̃`FbNAEgɏWv܂B</center>";
	
	$display->displayTable_horizontal($sales_tableheaders, $saledata, 900,'','');
	

} else {

	$display->displayTitle("݂̖̎̔XgAbv܂B");
	echo "<center><form action='check_unpaidsales.php' method='POST'>\n";
	echo "<input type='submit' value='XgAbv' >";
	echo "<input type='hidden' name = 'go_check' value='1' >";
	echo "</form></center>";
	
}

	
$dbf->closeDBlink();


?>
</body>
</html>