<?php

include ("../set_session.php");
session_start();
/*
Input
	$_SESSION['items_in_sale']
	$_SESSION['current_sale_customer_id']
	
	$_POST['paid_with']
	$_POST['comment']
	$_POST['totalTax']
	$_POST['finalTotal']
	$_POST['totalItemsPurchased']
*/

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/display.php");

function CheckCheckin($customer_no){
	global $dbf;
	global $lang;
	
	if(!$dbf->isCheckin($customer_no)){
		echo "<center><B>$lang->thisperson_not_checkin2</B></center>";
	}

}

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

//sale was from Checkin Display? Then go back to Checkin.
if(isset($_SESSION['from_checkin_display'])){
	unset($_SESSION['from_checkin_display']);
	$url = "../customers/customer_checkin.php";
} else {
	$url = "sale_ui.php";
}

?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
<SCRIPT Language="JavaScript">
<!--

function getKeyCode(e) {
   if( (_getKEYCODE(e)==13) ){
		location.href = "<?php echo $url?>";
   }
}

//--ꂽL|R[hԂ
function _getKEYCODE(e){
  var ua = navigator.userAgent
  if(ua.search('opera(\ |\/)6')!=-1)  //o6s
    return null
  else if(document.layers)            //n4p
    return  e.which
  else if(document.all)               //e4,e5,e6,o7,s1p
    return  event.keyCode
  else if(document.getElementById)    //n6,n7,mozp
    return  e.which
  else return null                    //LȊO
}

window.document.onkeypress=getKeyCode;

-->
</SCRIPT>
</head>

<body>
<?php
$table_bg=$display->sale_bg;
$num_items=count($_SESSION['items_in_sale']);

if($num_items==0)
{
	echo "<b>$lang->youMustSelectAtLeastOneItem</b><br>";
	echo "<a href=javascript:history.go(-1)>$lang->refreshAndTryAgain</a>";
	exit();
}
$customers_table=$cfg_tableprefix.'customers';
$items_table=$cfg_tableprefix.'items';
$sales_items_table=$cfg_tableprefix.'sales_items';
$sales_table=$cfg_tableprefix.'sales';

//checkin check.
CheckCheckin($_SESSION['current_sale_customer_id']); //for Checkin Check.

//general sale info
$paid_with=isset($_POST['paid_with'])?$_POST['paid_with']:'';
$comment=isset($_POST['comment'])?$_POST['comment']:'';
$customer_name=$dbf->idToField($customers_table,'last_name',$_SESSION['current_sale_customer_id']).' '.$dbf->idToField($customers_table,'first_name',$_SESSION['current_sale_customer_id']);

//totals
$finalTax=$_POST['totalTax'];
$sale_total_cost=$_POST['finalTotal'];
$temp_total_items_purchased=$_POST['totalItemsPurchased'];

//table two colums
echo "<table Border='1' WIDTH=\"95%\">\n";
echo "<tr><td>\n";

$now=date("F j, Y, g:i a");
echo "
<center>$now<br>
<h4>$lang->orderBy: $customer_name $lang->sama [$lang->paidWith $paid_with]</h4>

<table border='0' cellspacing='0' cellpadding='2' bgcolor='$table_bg'>

		   <tr>
		   <th><font color='CCCCCC'>$lang->itemOrdered</font></th>
	   	   <th><font color='CCCCCC'>$lang->unitPrice</font></th>
		   <th><font color='CCCCCC'></font></th>
		   <th><font color='CCCCCC'>$lang->quantity</font></th>
		   <th><font color='CCCCCC'>$lang->extendedPrice</font></th>
		   </tr>";


$todaysDate=date("Y-m-d");
$subtotal=my_number_format($sale_total_cost-$finalTax,2,'.', '');
$final_tax=my_number_format($finalTax,2,'.', '');

$field_names=array('date','customer_id','sale_sub_total','sale_total_cost','paid_with','items_purchased','sold_by','comment');
$field_data=array($todaysDate,$_SESSION['current_sale_customer_id'],$subtotal,$sale_total_cost,$paid_with,$temp_total_items_purchased,$_SESSION['session_user_id'],$comment);
$dbf->insert($field_names,$field_data,$sales_table,false);
$saleID=mysql_insert_id();

$field_names=array('sale_id','item_id','quantity_purchased','item_unit_price','item_buy_price','item_tax_percent','item_tax_cal_type','item_total_tax','item_total_cost');

$temp_item_id='';
$temp_item_name='';
$temp_quantity_purchased=0;
$temp_item_unit_price=0;
$temp_item_buy_price=0;
$temp_item_tax_percent=0;
$temp_item_tax=0;
$temp_item_tax_type=0;
$temp_item_cost=0;
$item_info=array();

//Add to sales_items table
for($k=0;$k<$num_items;$k++)
{
	$item_info=explode(' ',$_SESSION['items_in_sale'][$k]);
	
	$temp_item_id=$item_info[0];
	$temp_item_name=$dbf->idToField($items_table,'item_name',$temp_item_id);
	$temp_quantity_purchased=$item_info[3];
	$temp_item_unit_price=my_number_format($item_info[1],2,'.', '');
	$temp_item_buy_price=my_number_format($dbf->idToField($items_table,'buy_price',$temp_item_id),2,'.', '');

	$temp_item_tax_percent=$item_info[2];
	$temp_item_tax_type=$item_info[4];

/*
	$temp_item_tax=my_number_format($temp_item_tax_percent/100*$temp_item_unit_price*$temp_quantity_purchased,2,'.', '');
*/
	//for Japan...
	//$temp_item_per_tax = round (($temp_item_tax_percent/100) * $temp_item_unit_price );
	//2005/08
	$temp_item_per_tax = $dbf->tax_calc($temp_item_unit_price, $temp_item_tax_percent, $temp_item_tax_type );
	$temp_item_tax = my_number_format( $temp_item_per_tax * $temp_quantity_purchased , 2, '.', '');

	//for Japan
	//$temp_item_tax = round($temp_item_tax);

	$temp_item_cost=my_number_format(($temp_item_unit_price*$temp_quantity_purchased)+$temp_item_tax,2,'.', '');

	$field_data=array("$saleID","$temp_item_id","$temp_quantity_purchased","$temp_item_unit_price","$temp_item_buy_price","$temp_item_tax_percent","$temp_item_tax_type","$temp_item_tax","$temp_item_cost");
	$new_quantity=$dbf->idToField($items_table,'quantity',$temp_item_id)-$temp_quantity_purchased;
	$query="UPDATE $items_table SET quantity=\"$new_quantity\" WHERE $temp_item_id=id";
	mysql_query($query,$dbf->conn);
	$dbf->insert($field_names,$field_data,$sales_items_table,false);
	
	//for Package Sale
	if($temp_item_unit_price == 0){
		$disp_temp_item_unit_price ='***';
		//$disp_temp_quantity_purchased = '***';
		$disp_temp_quantity_purchased = disp_number_format($temp_quantity_purchased);
		$disp_temp_item_cost = '***';
		
	} else {

		//for display (Original Code)
		$disp_temp_item_unit_price = disp_number_format($temp_item_unit_price);
		$disp_temp_item_per_tax = disp_number_format($temp_item_per_tax);
		$disp_temp_quantity_purchased = disp_number_format($temp_quantity_purchased);
		$disp_temp_item_cost = disp_number_format($temp_item_cost);

	}
	//end of Package Sale

	
	echo "<tr><td align='center'><font color='white'>$temp_item_name</font></td>
			  <td align='center'><font color='white'>$cfg_currency_symbol$disp_temp_item_unit_price</font></td>
			  <td align='center'><font color='white'>$cfg_currency_symbol$disp_temp_item_per_tax</font></td>
			  <td align='center'><font color='white'>$disp_temp_quantity_purchased</font></td>
			  <td align='center'><font color='white'>$cfg_currency_symbol$disp_temp_item_cost</font></td>
		  </tr>";

}

	//for Next Sale Display 2005/5 BY SD
	$_SESSION['last_sale_info'] = $saleID;

	//for display
	//$disp_subtotal = disp_number_format($subtotal);
	$disp_subtotal = disp_number_format($subtotal+$final_tax); // for Japan tax system
	$disp_final_tax = disp_number_format($final_tax);
	$disp_sale_total_cost = disp_number_format($sale_total_cost);

echo "</table><br>\n";

//table two colums
echo "</td><td><BR>\n";

echo "<table border='0' align='center'><tr><td><b>$lang->saleSubTotal: $cfg_currency_symbol$disp_subtotal</b></td></tr>";
echo "<tr><td><b>$lang->uchi_tax: $cfg_currency_symbol$disp_final_tax</b></td></tr>";
echo "<tr><td><b>$lang->saleTotalCost: $cfg_currency_symbol$disp_sale_total_cost</b></td></tr>";
echo "<tr><td>$lang->saleID: $saleID</td></tr>";
echo "</table>";

/* ̔ς݂ɂł̂ŁAꎞIɎĂB
echo "<br><center><font size=\"2\"><a href='update_sale.php?id={$saleID}'>[{$lang->manageSales}]</a></font></center>";
*/

echo "<center>";

//`FbNCĂȂꍇ́A[ŐZ]{^oB
if(!$dbf->isCheckin($_SESSION['current_sale_customer_id'])){

	echo "<form action='payment.php' method='POST'>";
	echo "<input type='hidden' name='sale_count' value='1'>";
	echo "<input type='hidden' name='group_flag' value='0'>";
	
	//this is a test.
	//echo "<input type='hidden' name='sale_count' value='2'>";
	//$test = $saleID-1;
	//echo "<input type='hidden' name='sale_array1' value='{$test}'>";
	
	echo "<input type='hidden' name='sale_array0' value='{$saleID}'>";
	echo "<input type='submit' name='payment' value='$lang->continuepayment'>";
	echo "</form>";

} else {

 echo "<font size=2>[Z̓`FbNAEĝ݂ɍsȂݒłB]</font>";

}

$sec->closeSale();
$dbf->closeDBlink();

echo"<br><br><b>$lang->contact $cfg_company:</b><p>";
if($cfg_address!='')
{
	$temp_address=nl2br($cfg_address);
	echo "$lang->address: $temp_address <br>";

}
if($cfg_phone!='')
{
	echo "$lang->phoneNumber: $cfg_phone <br>";

}

if($cfg_email!='')
{
	echo "$lang->email: $cfg_email <br>";

}

if($cfg_fax!='')
{
	echo "$lang->fax: $cfg_fax <br>";

}


if($cfg_website!='')
{
	echo "$lang->website <a href=$cfg_website>$cfg_website</a> <br>";

}


if($cfg_other!='')
{
	echo "$lang->other: $cfg_other <br>";

}

	echo "<br><center><font size=\"2\">".$lang->enter_then_return."</font></center>\n";

//table two colums
echo "</center></td></tr></table>\n";


?>
<br><br>
<SCRIPT Language="Javascript">

/*
This script is written by Eric (Webcrawl@usa.net)
For full source code, installation instructions,
100's more DHTML scripts, and Terms Of
Use, visit dynamicdrive.com
*/

function printit(){  
if (window.print) {
    window.print() ;  
} else {
    var WebBrowser = '<OBJECT ID="WebBrowser1" WIDTH=0 HEIGHT=0 CLASSID="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2"></OBJECT>';
document.body.insertAdjacentHTML('beforeEnd', WebBrowser);
    WebBrowser1.ExecWB(6, 2);//Use a 1 vs. a 2 for a prompting dialog box    WebBrowser1.outerHTML = "";  
}
}
</script>

<SCRIPT Language="Javascript">  
var NS = (navigator.appName == "Netscape");
var VERSION = parseInt(navigator.appVersion);
if (VERSION > 3) {
    document.write('<form><input type=button value="<?PHP echo $lang->printdisplay; ?>" name="Print" onClick="printit()"></form>');        
}
</script>
</body>
</html>