<?php
// By SD. CBA-Japan All Rights Reserved for this script.
// Search Web Yoyaku System and export to POS system
//
// 1) Search Web Yoyaku System
// 2) Export Data to POS system
// 3) SET $_SESSION['cus_id']

session_start();
include ("../settings.php");
include("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");
Require_Once("customerdao_class.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$cf=new Codefilter();

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

//This page will use
// $_GET['web_id']
//

$customers_table="$cfg_tableprefix".'customers';

//echo "ŁCǗ\tgɗ݂܂B";

//**********************************************************
// import from reservation system and publish new id code.
function import_from_reservation($custid){
	global $customers_table;
	global $dbf;
	global $lang;
	
	//$customers_table = 'test';

	$cus_dao = new CustomerDAO();
	$web_found = $cus_dao->findByID($custid);

	if($web_found==0){
		echo "<center><B>$lang->problemConnectingToDB</B></center><BR>";
		die;
	}

	$web_found->SetCode('SJIS');
	
	//gets variables entered by user.
	$first_name = $web_found->GetCust_name2();
	$last_name = $web_found->GetCust_name1();
	$account_number = '';
	$phone_number = $web_found->GetTel1();
	$email = $web_found->GetEmail();
	$street_address = $web_found->GetAddress();
	$comments = '';
	
	$first_name50 = $web_found->GetCustName50_2();
	$last_name50 = $web_found->GetCustName50_1();
	$sex = $web_found->GetSex();
	$birthdate = $web_found->GetBirth();
	$zip = $web_found->GetZipcode();
	$pref = $web_found->GetPrefbyID();
	$phone_number2 = $web_found->GetTel2();
	$fax = $web_found->GetFax();
	$password = $web_found->GetPassword();
	$regular = $web_found->GetRegular();

	$new_id = $dbf->GetNext_ID();
	//echo "name=".$first_name.$last_name;
	//echo "newid=".$new_id;
	//die;
	
	//insert.
			$field_names=array(
				'id',
				'last_name',
				'first_name',
				'account_number',
				'phone_number',
				'email',
				'street_address',
				'comments',
			//added by SD.
				'first_name_50',
				'last_name_50',
				'sex',
				'birth',
				'zipcode',
				'pref_id',
				'phone_number2',
				'fax',
				'password',
				'regular'
			);
			
			
			$field_data=array(
				"$new_id",
				"$last_name",
				"$first_name",
				"$account_number",
				"$phone_number",
				"$email",
				"$street_address",
				"$comments",
			// added by SD.
				"$first_name50",
				"$last_name50",
				"$sex",
				"$birthdate",
				"$zip",
				"$pref",
				"$phone_number2",
				"$fax",
				"$password",
				"$regular"
			);	
	
	//print_r($field_data);
	//print_r($field_names);
	//print_r($field_data);
	//echo "<BR>table=".$customers_table;
?>
<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
</head>
<body>
<?PHP
	$dbf->insert($field_names,$field_data,$customers_table,true);
	return $new_id;
?>
</body>
</html>
<?PHP

	$cus_dao->FinishDB();
}

function overwrite_from_reservation($originalid,$web_custid){
	global $customers_table;
	global $dbf;
	global $lang;
	
	//$customers_table = 'test';

	$cus_dao = new CustomerDAO();
	$web_found = $cus_dao->findByID($web_custid);

	if($web_found==0){
		echo "<center><B>$lang->problemConnectingToDB</B></center><BR>";
		die;
	}

	$web_found->SetCode('SJIS');
	
	//gets variables entered by user.
	$first_name = $web_found->GetCust_name2();
	$last_name = $web_found->GetCust_name1();
	$account_number = '';
	$phone_number = $web_found->GetTel1();
	$email = $web_found->GetEmail();
	$street_address = $web_found->GetAddress();
	$comments = '';
	
	$first_name50 = $web_found->GetCustName50_2();
	$last_name50 = $web_found->GetCustName50_1();
	$sex = $web_found->GetSex();
	$birthdate = $web_found->GetBirth();
	$zip = $web_found->GetZipcode();
	$pref = $web_found->GetPrefbyID();
	$phone_number2 = $web_found->GetTel2();
	$fax = $web_found->GetFax();
	$password = $web_found->GetPassword();
	$regular = $web_found->GetRegular();

	//update.
			$field_names=array(
				'id',
				'last_name',
				'first_name',
				'account_number',
				'phone_number',
				'email',
				'street_address',
				'comments',
			//added by SD.
				'first_name_50',
				'last_name_50',
				'sex',
				'birth',
				'zipcode',
				'pref_id',
				'phone_number2',
				'fax',
				'password',
				'regular'
			);
			
			
			$field_data=array(
			
				"$originalid",

				"$last_name",
				"$first_name",
				"$account_number",
				"$phone_number",
				"$email",
				"$street_address",
				"$comments",
			// added by SD.
				"$first_name50",
				"$last_name50",
				"$sex",
				"$birthdate",
				"$zip",
				"$pref",
				"$phone_number2",
				"$fax",
				"$password",
				"$regular"
			);	
	
	//print_r($field_data);
	//print_r($field_names);
	//print_r($field_data);
	//echo "<BR>table=".$customers_table;
?>
<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
</head>
<body>
<?PHP

	$dbf->update($field_names,$field_data,$customers_table,$originalid,true);
	return True;
?>
</body>
</html>
<?PHP	

	$cus_dao->FinishDB();

}

//end of functions
//**********************************************************

switch($_GET['act']){
	case 'newregist':
		//registration:
		//echo "data=".$_GET['webid'];
		// copy from Web reservation system. And Get new id.
		$new_id = import_from_reservation($_GET['webid']);
		//echo "<BR><center><a href='../phpMyEdit/p_customers.php?operation=ύX&rec=".$new_id."' TARGET='_blank'>mڍ׏ǉAҏWn</a></center>";
		echo "<BR><center>".$display->PutUpdateLink('mڍ׏ǉAҏWn',$new_id)."</center></BR>";
		$_SESSION['cus_id'] = $new_id;
		//header ("location: ../customers/customer_checkin2.php");
		echo "<form action=\"../customers/customer_checkin_2.php\">";
		echo "<center><input type=\"submit\" value=\"   $lang->gotonext   \"></center>";
		echo "</form>";
		exit();		
	break;

	case 'overwrite':

		//registration:
		$overwrited_id = $_GET['orgid'];

		if( overwrite_from_reservation($overwrited_id,$_GET['webid']) ){
			$_SESSION['cus_id'] = $overwrited_id;
			//echo "<BR><center><a href='../phpMyEdit/p_customers.php?operation=ύX&rec=".$overwrited_id."' TARGET='_blank'>mڍ׏ǉAҏWn</a></center>";
			echo "<BR><center>".$display->PutUpdateLink('mڍ׏ǉAҏWn',$overwrited_id)."</center><BR>";
			//header ("location: ../customers/customer_checkin2.php");
			echo "<form action=\"../customers/customer_checkin_2.php\">";
			echo "<center><input type=\"submit\" value=\"   $lang->gotonext   \"></center>";
			echo "</form>";
			exit();		
		} else {
			echo "<center><B>$lang->problemConnectingToDB<B></center>";
			exit;
		}
	break;

	case 'cancel':
		header ("location: ../customers/customer_checkin.php");
		exit();
	break;
	
	default:
	// display form.
	// *************************************************************************
	// if action was not specified, that means there is already a similar data.
	// *************************************************************************

		//check validity.
		if(!isset($_POST['web_id'])){
			echo "<center><B>$lang->noActionSpecified<B></center>";
			exit;
		}
		
		$web_id = $_POST['web_id'];
		
		//Get Web phone number
		$cus_dao = new CustomerDAO();
		$web_found = $cus_dao->findByID($web_id);
		$web_phonenum = $web_found->GetTel1();
		
		//print $web_phonenum;
		
		//validate check of customer info.
		//check duplication.

		if($dbf->isCustomerRegistered($web_phonenum)){

			//GetOriginal Number.
			$original_id = $dbf->getFieldbyTel($web_phonenum,'id');

			//check validity
			if($original_id == 0){
				echo "<center><B>$lang->youDoNotHaveAnyDataInThe</B></center>";
				exit;
			}

			//Check name and tel. then, if Both are same, show only 'OVERWRITE'.
			$web_found->SetCode('SJIS');
			$temp_web_name1 = $web_found->GetCustName50_1();
			$temp_web_name2 = $web_found->GetCustName50_2();
			$temp_sys_name1 = $cf->GetDB( $dbf->getFieldbyTel($web_phonenum,'last_name_50') );
			$temp_sys_name2 = $cf->GetDB( $dbf->getFieldbyTel($web_phonenum,'first_name_50') );

			if(
				($temp_web_name1 == $temp_sys_name1) && ($temp_web_name2 == $temp_sys_name2)
			){
			
				$same_flag = True;
			} else {
				$same_flag = False;
			}
			
			$cus_dao->FinishDB();
				
			echo "<BR><BR>";
			echo "<center><B>$lang->alreadyRegistered</B></center><BR>";
			echo "<center><B>$lang->reallyregister</B></center><BR>";
?>
<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
</head>
<body>
<table  align='center'>
	<tr>
	<td>
		<form method="GET">
		<input type="hidden" name="act" value="overwrite">
		<input type="hidden" name="orgid" value="<?PHP echo $original_id ?>">
		<input type="hidden" name="webid" value="<?PHP echo $web_id ?>">
		<input type="submit" value="     <?PHP echo $lang->mes_overwrite ?>     ">
		</form>
	</td>
<?PHP
	if($same_flag == False){
?>	
	<td>
		<form method="GET">
		<input type="hidden" name="act" value="newregist">
		<input type="hidden" name="webid" value="<?PHP echo $web_id ?>">
		<input type="submit" value="     <?PHP echo $lang->mes_newregist ?>     ">
		</form>
	</td>
<?PHP
	}
?>	
	<td>
		<form method="GET">
		<input type="hidden" name="act" value="cancel">
		<input type="submit" value="<?PHP echo $lang->mes_cancel ?>">
		</form>
	</td>
	</tr>
</table>
</body>
</html>

<?PHP
		}else{
		//echo "VK̓o^łB";
		// no duplication.
		header ("location: weblist2table.php?act=newregist&webid=".$web_id);
		exit();
		}
	break;
}

?>