<?php
////////////////////////////////////////////////////////////////////////////////
//
// GOLFWEB (for PHP 4.3.X)
// Golf course total maintenance system
// Copyright 
// (C)2004 Communication Business Avenue, Inc.
// All Rights Reserved.
// http://www.cba-japan.com
//
// Created:2004/10/19
// File: reservationDAO_class.php
// Description: \񑀍NX 
// **** DAONX́Cnew reservationDAO CṒCFinishDB()ĂłB
////////////////////////////////////////////////////////////////////////////////

require_once 'dao_class.php';

class Reservation_time {
	var $c_id; //customer id.
	var $rsv_date; //reservation date.
	var $seq; //sequence.
	var $group_id; //group id.
	var $rsv_time; //reservation time.
	var $course; //course.
	
	function GetC_id(){
		return $this->c_id;
	}
	
	function GetRsvDate(){
		return $this->rsv_date;
	}

	function GetSeq(){
		return $this->seq;
	}

	function GetGroupID(){
		return $this->group_id;
	}

	function GetRsvTime(){
		return $this->rsv_time;
	}

	function GetCourse(){
		return $this->course;
	}
}

class ReservationDAO extends DAO {

	var $rsv_tname = 'reservationlist'; //Webf[^x[XCe[u
	var $rsv_time_tname = 'reservationlist_time'; //Webf[^x[XCe[u
	var $rsv_member_tname = 'reservationlist_member'; //Webf[^x[XCe[u
	var $calendar_tname = 'calendar'; //Webf[^x[XCe[u
	var $calendar_time_tname = 'calendar_time'; //Webf[^x[XCe[u
	var $customer_tname = 'customer'; //Webf[^x[XCe[u

	function ReservationDAO() {
		$this->DAO();
	}

	function getDByearbetween(){
	// returns array (MIN_YEAR,MAX_YEAR)

		$query = "SELECT min(CAL_DATE) as minDate FROM $this->calendar_tname ";
		$res = $this->db_object->query($query);

		if (DB::isError($res)){
			echo "<center><B>ERROR(YEAR):".($res->getMessage())."</B></center>";
			echo $query;
			die;
		}
		
		$row = $res->fetchRow(DB_FETCHMODE_ASSOC);
		$min_date = $row['minDate'];

		$min_year = date("Y",strtotime($min_date));

		$query = "SELECT max(CAL_DATE) as maxDate FROM $this->calendar_tname ";
		$res = $this->db_object->query($query);

		if (DB::isError($res)){
			echo "<center><B>ERROR:(YEAR2)".($res->getMessage())."</B></center>";
			die;
		}

		$row = $res->fetchRow(DB_FETCHMODE_ASSOC);
		$max_date = $row['maxDate'];
		$max_year = date("Y",strtotime($max_date));

	    $res_array = array( $min_year, $max_year);
		return $res_array;
	}

	function GetRSVDetail($i_date, $i_time, $i_course){

		$query = "SELECT $this->rsv_tname.CAL_DATE, CAL_TIME, COURSE, $this->customer_tname.C_ID, ";
		$query.= " $this->rsv_tname.SEQ, NAME1, NAME2, NAME50_1, NAME50_2, RECORD1, RECORD2, RECORD3, ";
		$query.= " COMPETITION, P_NAME, PRE_MEMBER, LASTUPD, PARTY_ID, PARTY_COST, PARTY_NUM ";
		$query.= "FROM $this->rsv_tname ";
		$query.= "LEFT JOIN $this->rsv_time_tname ON ($this->rsv_tname.C_ID = $this->rsv_time_tname.C_ID) AND ($this->rsv_tname.CAL_DATE = $this->rsv_time_tname.CAL_DATE) ";
		$query.= "LEFT JOIN $this->customer_tname ON $this->customer_tname.C_ID = $this->rsv_tname.C_ID ";
		$query.= " WHERE $this->rsv_tname.CAL_DATE='$i_date' AND $this->rsv_time_tname.CAL_TIME='$i_time' AND $this->rsv_time_tname.COURSE='$i_course' ";
		
		$res = $this->db_object->query($query);
		
		if (DB::isError($res)){
			echo "<center><B>".($res->getMessage())."</B></center>";
			return -1;
		}

		$row3 = array();
		
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				$row3 = array_merge($row3,$row2);
			}
			//$list[] = $row3;
			$list = $row3;
			$row3 = array();
		}
		return $list;
	}

	function GetRSVList($i_date,$c_id){
		$query = "SELECT COMPETITION, PRE_MEMBER, P_NAME, LASTUPD FROM $this->rsv_tname WHERE CAL_DATE='".$i_date."' AND C_ID='".$c_id."'";
		$res = $this->db_object->query($query);
		//echo $query;
		//die;

		if (DB::isError($res)){
			echo "<center><B>ERROR(RSVList):".($res->getMessage())."</B></center>";
			die;
		}

		$row3 = array();
		
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				/*
				print ".................<BR>";
				print "keyword=";
				print_r($keyword);
				print "<BR>val=";
				print_r($val);
				print "<BR>.................<BR>";
				*/
				$row3 = array_merge($row3,$row2);
			}
			$list[] = $row3;
			$row3 = array();
		}
		return $list;
	}

	function GetRSV_TIMEList($i_date){
		$query = "SELECT CAL_DATE, CAL_TIME,COURSE,C_ID,SEQ FROM $this->rsv_time_tname WHERE CAL_DATE='".$i_date."' ORDER BY CAL_TIME";
		$res = $this->db_object->query($query);
		//echo $query;
		//die;
		
		if (DB::isError($res)){
			echo "<center><B>".($res->getMessage())."</B></center>";
			return -1;
		}

		$row3 = array();
		
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				$row3 = array_merge($row3,$row2);
			}
			$list[] = $row3;
			$row3 = array();
		}
		return $list;
	}
	
	function GetRSV_ALL_List($i_date){
		$query = "SELECT $this->rsv_tname.CAL_DATE, CAL_TIME, COURSE, $this->customer_tname.C_ID, $this->rsv_tname.SEQ, NAME1, NAME2, NAME50_1, NAME50_2, RECORD1, RECORD2, RECORD3, COMPETITION, P_NAME, PRE_MEMBER, LASTUPD, PARTY_ID, PARTY_COST, PARTY_NUM ";
		//$query = "SELECT * ";
		$query.= "FROM $this->rsv_tname ";
		$query.= "LEFT JOIN $this->rsv_time_tname ON ($this->rsv_tname.C_ID = $this->rsv_time_tname.C_ID) AND ($this->rsv_tname.CAL_DATE = $this->rsv_time_tname.CAL_DATE) ";
		$query.= "LEFT JOIN $this->customer_tname ON $this->customer_tname.C_ID = $this->rsv_tname.C_ID WHERE $this->rsv_tname.CAL_DATE='$i_date' ORDER BY CAL_TIME";
		
		//echo $query;
		//die;
		
		$res = $this->db_object->query($query);
		
		if (DB::isError($res)){
			echo "<center><B>".($res->getMessage())."</B></center>";
			return -1;
		}

		$row3 = array();
		
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				$row3 = array_merge($row3,$row2);
			}
			$list[] = $row3;
			$row3 = array();
		}
		return $list;
	}

	function GetRSV_MEMBERList($sql){
		$query = "SELECT * FROM $this->rsv_member_tname ".$sql;
		$res = $this->db_object->query($query);
		//echo $query;
		//die;

		if (DB::isError($res)){
			echo "<center><B>ERROR(MemberList):".($res->getMessage())."</B></center>";
			die;
		}

		$row3 = array();
		$row2 = array();
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				$row3 = array_merge($row3,$row2);
			}
			$list[] = $row3;
			$row3 = array();
		}
		return $list;
	}

	//w񂩂A񕪂̗\񂪈ꏏȂ̂vZB
	function CalGroupNum($idate, $c_id, $seq){

		$sql  = "SELECT GROUP_ID from $this->rsv_time_tname ";
		$sql .= " WHERE CAL_DATE='$idate' AND C_ID = '$c_id' AND SEQ = '$seq' ORDER BY GROUP_ID ";
		$sql .= " DESC LIMIT 1 ";

		$result = $this->db_object->query($sql);

		if (DB::isError($result)){
			echo "<center><B>ERROR(memberlist):".($result->getMessage())."</B></center>";
			die;
		}
		
		$row = $result->fetchRow(DB_FETCHMODE_ASSOC);
		return $row['GROUP_ID'];
	
	}

	function getAllGroupNum($idate){
		$sql  = " SELECT C_ID, SEQ, MAX( GROUP_ID ) as MAX_num ";
		$sql .= " FROM $this->rsv_time_tname ";
		$sql .= " WHERE CAL_DATE = '$idate' ";
		$sql .= " GROUP BY C_ID, SEQ ";

		$result = $this->db_object->query($sql);

		if (DB::isError($result)){
			echo "<center><B>ERROR(memberlist):".($result->getMessage())."</B></center>";
			die;
		}

		$grouplist = array();
		while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)){
			
			$one_array =  array(
				$row['C_ID'],
				$row['SEQ'],
				$row['MAX_num']
			);
			
			array_push($grouplist,$one_array);
		}
		return $grouplist;
	}

	function getAllMember($i_date){
		$member_list = array();
		/*
		$sql  = "SELECT DISTINCT $this->rsv_member_tname.C_ID, NAME from $this->rsv_tname ";
		$sql .= " JOIN $this->rsv_member_tname ON $this->rsv_member_tname.C_ID = $this->rsv_tname.C_ID ";
		$sql .= " WHERE $this->rsv_member_tname.CAL_DATE='$i_date' ORDER BY $this->rsv_member_tname.C_ID ";
		*/
		$sql  = "SELECT C_ID, NAME from $this->rsv_member_tname ";
		$sql .= " WHERE CAL_DATE='$i_date' ORDER BY C_ID ";
		$result = $this->db_object->query($sql);

		if (DB::isError($result)){
			echo "<center><B>ERROR(memberlist):".($result->getMessage())."</B></center>";
			die;
		}
		
		while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)){
			
			$one_array =  array(
				$row['C_ID'],
				mb_convert_encoding($row['NAME'],SCRIPT_CODE, CD_INT)
			);
			
			array_push($member_list,$one_array);
		}
		//print_r($member_list);
		//die;
		return $member_list;
	}

	function getMemberList($date,$reserver_id){
		$member_list = array();
		
		$sql  = "SELECT NAME from $this->rsv_member_tname ";
		$sql .= " WHERE CAL_DATE='$date' ";
		$sql .= " AND C_ID='$reserver_id' ";
		
		$sql .= " ORDER BY MEMBER_ID";
		//print $sql;
		$result = $this->db_object->query($sql);

		if (DB::isError($result)){
			echo "<center><B>ERROR(memberlist):".($result->getMessage())."</B></center>";
			die;
		}
		
		while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)){
			$member_list[] .= mb_convert_encoding($row['NAME'],SCRIPT_CODE, CD_INT);
		}

		return $member_list;
	}

	function GetCompetitionList(){
		$query = "SELECT CAL_DATE, COMPETITION, C_ID, SEQ, PARTY_ID FROM $this->rsv_tname ";
		$query .= " WHERE (TO_DAYS(NOW()) <= TO_DAYS($this->rsv_tname.CAL_DATE)) AND COMPETITION <> '' ";
		$query .= " ORDER BY $this->rsv_tname.CAL_DATE DESC LIMIT 100";
		$res = $this->db_object->query($query);
		//echo $query;
		//die;

		if (DB::isError($res)){
			echo "<center><B>ERROR(RSVList):".($res->getMessage())."</B></center>";
			die;
		}

		$row3 = array();
		
		while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)){
			foreach($row as $keyword => $val){
				$row2 = array($keyword => mb_convert_encoding($val, SCRIPT_CODE, CD_INT));
				/*
				print ".................<BR>";
				print "keyword=";
				print_r($keyword);
				print "<BR>val=";
				print_r($val);
				print "<BR>.................<BR>";
				*/
				$row3 = array_merge($row3,$row2);
			}
			$list[] = $row3;
			$row3 = array();
		}
		return $list;
	}
	
}

?>