<?php 

include ("../set_session.php");
session_start();
// Written by CBA-Japan S.Dozono
// for Okamura Format Printing....
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");
include ("../customers/preflist.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Public',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$cf=new Codefilter();

if(!$sec->isLoggedIn())
{
		header ("location: ../login.php");
		exit();
}

$lockers_table = $cfg_tableprefix."lockers";
$customers_table = $cfg_tableprefix."customers";
$sales_table = $cfg_tableprefix."sales";
$sales_items_table = $cfg_tableprefix."sales_items";
$items_table = $cfg_tableprefix."items";
$brands_table = $cfg_tableprefix."brands";
$categories_table = $cfg_tableprefix."categories";
$suppliers_table = $cfg_tableprefix."suppliers";

//Calcuration.....
$tmp_date = date("Y-m-d",time());
$rep_date = date("YNmd",time());
$rep_time = date("Hi",time());

$tmp_year = date("Y",time());
$tmp_month = date("m",time());
$tmp_day = date("d",time());

//calculate today 0:0 to 24:24
$time_now = time();
$str_date = gmdate("Y/m/d",$time_now+9*3600);
$today_start = strtotime($str_date." "."00:00:01");
$today_end   = strtotime($str_date." "."23:59:59");

$rep_num_checkin = $dbf->getNumOfCheckin();

$link_previous = '';
$link_next = '';
$script_name = basename($_SERVER['PHP_SELF']);

//set period
if(isset($_GET['year'])){
	$tmp_year = $_GET['year'];
}
if(isset($_GET['month'])){
	$tmp_month = $_GET['month'];
}
if(isset($_GET['day'])){
	$tmp_day = $_GET['day'];
}


switch($_GET['act']){

	case 'accountyear':
		$date1 = ($tmp_year-1)."-09-01";
		$date2 = $tmp_year."-08-31";
		$rep_title = $lang->rep_accountyear;
		$rep_span = "{$tmp_year}Nx";
		//for Printing
		$title = "vNx cƔN";
		$for_printing = "";
	break;

	case 'monthly':
		$date1 = $tmp_year."-".$tmp_month."-01";
		//$date2 = $tmp_year."-".$tmp_month."-31";
		$date2 = $dbf->getlastdate($tmp_year,$tmp_month);
		
		$rep_title = $lang->rep_month;
		$rep_span = "{$tmp_year}N{$tmp_month}";
		//for Printing
		$for_printing = "";
	break;
	
	case 'annual':
		$date1 = $tmp_year."-01-01";
		$date2 = $tmp_year."-12-31";
		$rep_title = $lang->rep_year;
		$rep_span = "{$tmp_year}N";
		//for Printing
		$for_printing = "";
	break;
	
	case 'daily':
		$date1 = $tmp_year."-".$tmp_month."-".$tmp_day;
		$date2 = $tmp_year."-".$tmp_month."-".$tmp_day;
		$rep_title = $lang->rep_day;
		$rep_span = "{$tmp_year}N{$tmp_month}{$tmp_day}";
		//for Printing
		$for_printing = "<a href='report_for_printing.php?act=daily&year=".$tmp_year."&month=".$tmp_month."&day=".$tmp_day."'>".$lang->rep_for_printing."<a>";
	break;
	
	default:
		//daily..
		$date1 = $tmp_date;
		$date2 = $tmp_date;
		$rep_title = $lang->rep_day;
		$rep_span = "($tmp_year/$tmp_month/$tmp_day)";
		//for Printing
		$for_printing = "<a href='report_for_printing.php?'".">".$lang->rep_for_printing."<a>";
	break;
}

//C$switchOłȂΕ\BƂKicc
//ύX 2005/3/11.
//ł\B
function my_echo($switch,$mes){
	//if($switch){
	//	echo $mes;
	//}
	echo $mes;
}

// Data OutPut....
//ނςƂ͕\
//ʂςƂ͕\
//vO~Ȃ\Ȃ **** ͕ύX܂B0~ł\B2005/3/11***
//ނςƂ͍v\
//
// AAA 100
// AAA 200
//        << SubTotal}I
// BBB   0   ͕\ȂB*** \! 2005/3/11 ***
// BBB  10

function PutHTML($total_data,$accum_sub_total,$accum_total_cost)
{	
	$last_category = '';
	$last_brand = '';
	$ar_tmp_subtotal = 0;
	$ar_total_tax = 0;
	$atleast_oneitem = 0;

	for($i=0;$i<count($total_data);$i++){
		$one_array = $total_data[$i];
		
		$ar_item_name =		$one_array[0]; //iږ
		$ar_brand =    		$one_array[1]; //
		$ar_category = 		$one_array[2]; //
		$ar_numberPurchased=$one_array[3]; //w
		$ar_unitPrice =		$one_array[4]; //̒li
		$ar_totalForItem =	$one_array[5]; //iڂ̍v
		$ar_itemTax = 		$one_array[6]; //ŋ
		
		//iށCʂŌȂCv\B
		if( ($last_brand != $ar_brand) || ($last_category != $ar_category) ){

			if($atleast_oneitem){
				//put out subTotal....
				echo "<tr>\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
	    		echo '<td width="9%"><div align="right">'.$ar_tmp_subtotal.'</div></td>'."\n";
				echo "</tr>\n";
				$ar_tmp_subtotal = 0;
			}
		}

		$ar_tmp_subtotal = $ar_tmp_subtotal + $ar_totalForItem;
		$ar_total_tax = $ar_total_tax + $ar_itemTax;

		//\Jn **********************
		if($last_category != $ar_category){
			my_echo($ar_totalForItem,'<tr><td colspan="7"><hr></td></tr>');
			my_echo($ar_totalForItem, "<tr>\n");
			my_echo($ar_totalForItem, "<td width='18%'>".$ar_category."</td>\n");
			$last_category = $ar_category;
		} else {
			my_echo($ar_totalForItem, "<tr>\n");
			my_echo($ar_totalForItem, "<td>&nbsp;</td>\n");
		}

		if($last_brand != $ar_brand){
			my_echo($ar_totalForItem, "<td>".$ar_brand."</td>\n");
			$last_brand = $ar_brand;
		} else {
			my_echo($ar_totalForItem, "<td>&nbsp;</td>\n");
		}

		my_echo($ar_totalForItem, "<td>".$ar_item_name."</td>\n");
	    my_echo($ar_totalForItem, '<td width="10%"><div align="right">'.$ar_numberPurchased."</div></td>\n");
	    my_echo($ar_totalForItem, '<td width="9%"><div align="right">'.$ar_unitPrice."</div></td>\n");
	    my_echo($ar_totalForItem, '<td width="9%"><div align="right">'.$ar_totalForItem."</div></td>\n");
	    my_echo($ar_totalForItem, '<td width="9%"><div align="right">&nbsp;</div></td>');
	    my_echo($ar_totalForItem, "</tr>\n");
		if($ar_totalForItem){
			$atleast_oneitem = 1;
		}
		//܂ *******************************
	}

	//last subTotal...
	if(($i != 0) && ($ar_tmp_subtotal != 0) ){
		echo "<tr>\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">'.$ar_tmp_subtotal.'</div></td>'."\n";
		echo "</tr>\n";
		$ar_tmp_subtotal = 0;
	}

	//TAX
		echo '<tr><td colspan="7"><hr></td></tr>';
		echo "<tr>\n";
    		echo '<td width="9%"><div align="right">œ</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">'.$ar_total_tax.'</div></td>'."\n";
		echo "</tr>\n";

	//grand total.
		echo '<tr><td colspan="7"><hr></td></tr>';
		echo "<tr>\n";
    		echo '<td width="9%"><div align="right">v</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">&nbsp;</div></td>'."\n";
    		echo '<td width="9%"><div align="right">'.$accum_total_cost.'</div></td>'."\n";
		echo "</tr>\n";
}

////NEW///////////////////////////

$saled_data = $dbf->makeSaledData($date1,$date2);
$prepared_data = $dbf->makeRowData($saled_data, array(),'1'); //no filtering.

$total_data = array();
for($i=0;$i<count($prepared_data);$i++){
	$one_array = $prepared_data[$i];
	if($one_array[0]==1){
		$item_name = $display->formatData('item_id',$one_array[3],$cfg_tableprefix);
		$temp_category = $display->idToField($categories_table,'category',$display->idToField($items_table,'category_id',$one_array[3]));
		$temp_brand = $display->idToField($brands_table,'brand',$dbf->idToField($items_table,'brand_id',$one_array[3]));
		$item_purchased = $one_array[5];
		$item_unitPrice = $one_array[4];
		$total_cost = $one_array[6];
		$item_tax = $one_array[7];
		
		$total_data[] = array (
			$item_name, //iږ
			$temp_category, //
			$temp_brand, //
			$item_purchased,//w
			$item_unitPrice, //̒li
			$total_cost,//iڂ̍v
			$item_tax  //ŋ
			);
	}
	if($one_array[0]==4){
		$accum_sub_total = $one_array[9];
	}
	if($one_array[0]==6){
		$accum_total_cost =  $one_array[9];
	}
}

//////////////////////////////////
header ('Content-Type: application/vnd.ms-excel');
header ('Content-Disposition: attachment; filename="golf_nippo.xls"');
?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
</head>
<title>p</title>
<body>

<?PHP

////////////////////////////
//Print Out OKAMURA FORMAT
////////////////////////////

?>

<table width="650"  border="1" cellpadding="1" cellspacing="0" bordercolor="#CCCCCC">
  <tr>
    <td colspan="3"><div align="center"><?PHP echo $rep_title ?></div></td>
    <td colspan="4"><div align="right"><?PHP echo $rep_span;?></div></td>
  </tr>
  <tr>
    <td colspan="7"><div align="right">@<?PHP echo $rep_date; ?></div></td>
  </tr>
  <tr>
    <td colspan="7"><hr></td>
  </tr>
  <tr>
    <td></td>
    <td width="17%">e</td>
    <td width="28%">ڍ</td>
    <td><div align="right">̔</div></td>
    <td><div align="right">P</div></td>
    <td><div align="right">v</div></td>
    <td><div align="right">ڌv</div></td>
  </tr>

<?PHP

//HTMLf[^̏o
//var_dump($total_data);
//die;
PutHTML($total_data,$accum_sub_total,$accum_total_cost);

?>
</table>
</body>
</html>


</body>
</html>