<?php 

/*
 pxDocɂA\XNvgB
 yreport_for_svg.php?tax=1 ŁAōݕ\ɐ؂ւz
*/

session_cache_limiter("public");
include ("../set_session.php");
session_start();
// Written by CBA-Japan S.Dozono
// for SVG Format Printing....
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");
include ("../customers/preflist.php");
include ("../classes/pxprint.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Public',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$cf=new Codefilter();

if(!$sec->isLoggedIn())
{
		header ("location: ../login.php");
		exit();
}

Define("SALE_LINES_PAGE1",21); //ŏ̃y[WAiڂ̍s
Define("SALE_LINES_OTHER_PAGE",35);//2y[Wڈȍ~Aiڂ̍s
Define("FIRST_PAGE_Y",370); //ŏ̃y[WAiڕ\̊JnYW
Define("OTHER_PAGE_Y",50); //Qy[Wڈȍ~Aiڕ\̊JnYW

////////////////////////////////
// lWvɎgpID̒`B
////////////////////////////////

//RPɕ\iID.
$c1_array = array(
	126, //WjA(#9000)
	125, //WjA(#9000)
	129, //18Ζ(#9000)
	130, //18Ζ(#9000)
	131, //18Ζ(#9000)
	132, //18Ζ(#9000)
	133, //Q(#9000)
	134, //Q(#9000)
	135, //Q(#9000)
	136  //Q(#9000)
);

$c2_array = array(
	166, //DҌ(#900)
	167, //DҌ(#900)
	168, //DҌ(#0)
	39, //o[(#9000)
	38, //o[(65Έȏ)
	37, //o[(70Έȏ)
	171, //rW^[(#9000)
	170, //rW^[(#9000 65Έȏ)
	169  //rW^[(#9000 70Έȏ)
);

$c3_array = array(
	42, //rW^[i#9000j
	41, //rW^[i#9000 65j
	40, //rW^[i#9000 70j
	45, //rW^[i#9000j
	44, //rW^[i#9000 65j
	43, //rW^[i#9000 70j
	48, //rW^[i#9000j
	47, //rW^[i#9000 65j
	46 //rW^[ i#9000 70j
);

$pref_array = array(
	14, //
	12, //
	15, //_ސ
	13, //t
	16, //
	7,  //V
	10 //Qn
	//̑iȂBjŌɒǉ܂B
);

//ꎋݒ 2005/8
//قȂiIDɊւĂÃ`PbgƂďiŏWv܂B
$alias_array = array(
	"191" => "171",  //Xؗjv[́Ao[ƂďWv
);


////////////////////////////////
// ID̒`(܂ŁBj
////////////////////////////////

//***********************
//
// f[^쐬
//
//***********************

//Calcuration.....
$tmp_date = date("Y-m-d",time());
$rep_date = date("YNmd",time());
$rep_time = date("Hi",time());

$tmp_year = date("Y",time());
$tmp_month = date("m",time());
$tmp_day = date("d",time());

//calculate today 0:0 to 24:24
$time_now = time();
$str_date = gmdate("Y/m/d",$time_now+9*3600);
$today_start = strtotime($str_date." "."00:00:01");
$today_end   = strtotime($str_date." "."23:59:59");

$link_previous = '';
$link_next = '';
$script_name = basename($_SERVER['PHP_SELF']);

//TAX mode..
//ō݂ŕ\tOB
$flag_withtax = 0;
if(isset($_GET['tax'])){
	if($_GET['tax']=='1'){
		$flag_withtax = 1;
	}
}

//set period
if(isset($_GET['year'])){
	$tmp_year = $_GET['year'];
}
if(isset($_GET['month'])){
	$tmp_month = $_GET['month'];
}
if(isset($_GET['day'])){
	$tmp_day = $_GET['day'];
}


switch($_GET['act']){

	case 'accountyear':
		$date1 = ($tmp_year-1)."-09-01";
		$date2 = $tmp_year."-08-31";
		$rep_title = $lang->rep_accountyear;
		$rep_span = "{$tmp_year}Nx";
		//for Printing
		$title = "vNx N";
		$for_printing = "";
	break;

	case 'monthly':
		$date1 = $tmp_year."-".$tmp_month."-01";
		//$date2 = $tmp_year."-".$tmp_month."-31";
		$date2 = $dbf->getlastdate($tmp_year,$tmp_month);
		$rep_title = $lang->rep_month;
		$rep_span = "{$tmp_year}N{$tmp_month}";
		$title = " @@";
		//for Printing
		$for_printing = "";
	break;
	
	case 'annual':
		$date1 = $tmp_year."-01-01";
		$date2 = $tmp_year."-12-31";
		$rep_title = $lang->rep_year;
		$rep_span = "{$tmp_year}N";
		//for Printing
		$title = " @N@";
		$for_printing = "";
	break;
	
	case 'daily':
		$date1 = $tmp_year."-".$tmp_month."-".$tmp_day;
		$date2 = $tmp_year."-".$tmp_month."-".$tmp_day;
		$rep_title = $lang->rep_day;
		$rep_span = "{$tmp_year}N{$tmp_month}{$tmp_day}";
		//for Printing
		$title = " @@";
		$for_printing = "<a href='report_for_printing.php?act=daily&year=".$tmp_year."&month=".$tmp_month."&day=".$tmp_day."'>".$lang->rep_for_printing."<a>";
	break;
	
	default:
		//daily..
		$date1 = $tmp_date;
		$date2 = $tmp_date;
		$rep_title = $lang->rep_day;
		$rep_span = "($tmp_year/$tmp_month/$tmp_day)";
		//for Printing
		$for_printing = "<a href='report_for_printing.php?'".">".$lang->rep_for_printing."<a>";
	break;
}

if($flag_withtax==1){
	$title = $title."iōj";
} else {
	$title = $title."iŔj";
}

//***********************
//
// ʍ쐬
//
//***********************

//֐

//ŏ̐lWv
function PutHead(
	$title, //AANccB
	$pagenum, 
	$pagetotal,
	$date_data, //'2005/5/1'
	$date_print, //'2005/5/1'
	$colum1, //array
	$colum1_total,
	$colum2, //array
	$colum2_total,
	$colum3, //array
	$colum3_total,
	$colum4, //array
	$colum4_total
){
	echo '<text x="555.5px" y="52.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($pagenum).'</text>';
	echo '<text x="587.5px" y="52.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($pagetotal).'</text>';
	echo '<text x="627.5px" y="72.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$date_data.'</text>';
	echo '<text x="627.5px" y="90.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$date_print.'</text>';
	echo '<text x="180.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[0]).'</text>';
	echo '<text x="180.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[1]).'</text>';
	echo '<text x="180.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[2]).'</text>';
	echo '<text x="180.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[3]).'</text>';
	echo '<text x="180.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[4]).'</text>';
	echo '<text x="180.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[5]).'</text>';
	echo '<text x="180.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[6]).'</text>';
	echo '<text x="180.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[7]).'</text>';
	echo '<text x="180.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[8]).'</text>';
	echo '<text x="180.5px" y="318.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1[9]).'</text>';
	echo '<text x="180.5px" y="357.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum1_total).'</text>';
	
	echo '<text x="351.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[0]).'</text>';
	echo '<text x="351.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[1]).'</text>';
	echo '<text x="351.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[2]).'</text>';
	echo '<text x="351.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[3]).'</text>';
	echo '<text x="351.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[4]).'</text>';
	echo '<text x="351.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[5]).'</text>';
	echo '<text x="351.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[6]).'</text>';
	echo '<text x="351.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[7]).'</text>';
	echo '<text x="351.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2[8]).'</text>';
	echo '<text x="351.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum2_total).'</text>';
	
	echo '<text x="529.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[0]).'</text>';
	echo '<text x="529.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[1]).'</text>';
	echo '<text x="529.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[2]).'</text>';
	echo '<text x="529.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[3]).'</text>';
	echo '<text x="529.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[4]).'</text>';
	echo '<text x="529.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[5]).'</text>';
	echo '<text x="529.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[6]).'</text>';
	echo '<text x="529.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[7]).'</text>';
	echo '<text x="529.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3[8]).'</text>';
	echo '<text x="528.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum3_total).'</text>';
	
	echo '<text x="643.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[0]).'</text>';
	echo '<text x="643.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[1]).'</text>';
	echo '<text x="643.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[2]).'</text>';
	echo '<text x="643.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[3]).'</text>';
	echo '<text x="643.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[4]).'</text>';
	echo '<text x="643.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[5]).'</text>';
	echo '<text x="643.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[6]).'</text>';
	echo '<text x="643.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4[7]).'</text>';
	echo '<text x="642.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($colum4_total).'</text>';
	echo '<text x="247.5px" y="71.5px" style="fill:rgb(0,0,0);font-family:MS-Gothic;font-size:14pt;text-anchor:start" xml:space="preserve">'.$title.'</text>';

echo <<<EOD
	<text x="561.5px" y="53.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">/</text>
	<text x="627.5px" y="52.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">y[W</text>
	<text x="500.5px" y="90.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">@</text>
	<line x1="38.5" y1="113.5" x2="646.5" y2="113.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<text x="42.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">WjA  i#9,000j</text>
	<text x="42.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">WjA  i#9,000j</text>
	<text x="42.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">PWΖi#9,000j</text>
	<text x="42.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">PWΖi#9,000j</text>
	<text x="43.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">PWΖi#9,000j</text>
	<text x="43.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">PWΖi#9,000j</text>
	<text x="43.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">Q   i#9,000j</text>
	<text x="43.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">Q   i#9,000j</text>
	<text x="43.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">Q   i#9,000j</text>
	<text x="43.5px" y="318.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">Q   i#9,000j</text>
	<line x1="38.5" y1="133.5" x2="646.5" y2="133.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>
	<line x1="38.5" y1="152.5" x2="646.5" y2="152.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="171.5" x2="646.5" y2="171.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="190.5" x2="646.5" y2="190.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="209.5" x2="646.5" y2="209.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="228.5" x2="646.5" y2="228.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="247.5" x2="646.5" y2="247.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="266.5" x2="646.5" y2="266.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="285.5" x2="646.5" y2="285.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="304.5" x2="646.5" y2="304.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="323.5" x2="646.5" y2="323.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="342.5" x2="646.5" y2="342.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>
	<line x1="130.5" y1="114.5" x2="130.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="183.5" y1="114.5" x2="183.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="305.5" y1="114.5" x2="305.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="355.5" y1="114.5" x2="355.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="471.5" y1="114.5" x2="471.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="532.5" y1="114.5" x2="532.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<text x="189.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">DҌ@(#900)</text>
	<text x="189.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">DҌ@(#900)</text>
	<text x="189.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">DҌ@(#900) </text>
	<text x="189.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">o[i#9,000j</text>
	<text x="189.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">o[i65Έȏj</text>
	<text x="189.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">o[i70Έȏj</text>
	<text x="189.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j</text>
	<text x="189.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000 65Έȏj</text>
	<text x="189.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000 70Έȏj</text>
	<line x1="646.5" y1="114.5" x2="646.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="576.5" y1="114.5" x2="576.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<line x1="38.5" y1="362.5" x2="646.5" y2="362.5"
		style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>
	<text x="82.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:middle" xml:space="preserve">v</text>
	<text x="233.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:middle" xml:space="preserve">v</text>
	<text x="402.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:middle" xml:space="preserve">v</text>
	<text x="561.5px" y="356.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:middle" xml:space="preserve">v</text>
	<text x="539.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">@</text>
	<text x="539.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">@</text>
	<text x="539.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">_ސ</text>
	<text x="539.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">@t</text>
	<text x="539.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">@</text>
	<text x="539.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">V@</text>
	<text x="539.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">Q@n</text>
	<text x="539.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">̑</text>
	<g>
	<rect x="7.5" y="113.5" width="32" height="249"
		style="fill:rgb(255,255,255);stroke:rgb(0,0,0);stroke-width:1"/>
	<text x="24.5px" y="196.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" writing-mode="tb" xml:space="preserve">    </text>
	</g>
	<text x="359.5px" y="147.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j</text>
	<text x="359.5px" y="166.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j65Έȏ</text>
	<text x="359.5px" y="185.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j70Έȏ</text>
	<text x="359.5px" y="204.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j</text>
	<text x="359.5px" y="223.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j65Έȏ</text>
	<text x="359.5px" y="242.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j70Έȏ</text>
	<text x="359.5px" y="261.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j</text>
	<text x="359.5px" y="280.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j65Έȏ</text>
	<text x="359.5px" y="299.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">rW^[i#9,000j70Έȏ</text>
	<text x="155.5px" y="128.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">l</text>
	<text x="326.5px" y="128.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">l</text>
	<text x="501.5px" y="128.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">l</text>
	<text x="537.5px" y="128.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">n</text>
	<text x="613.5px" y="128.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">l</text>
EOD;
}

//ڃ^Cg
function PutTitle($y)
{
	echo '<line x1="7.5"   y1="'.$y.'" x2="646.5" y2="'.$y.     '" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="6.5"   y1="'.$y.'" x2="6.5"   y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="38.5"  y1="'.$y.'" x2="38.5"  y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="116.5" y1="'.$y.'" x2="116.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="266.5" y1="'.$y.'" x2="266.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="323.5" y1="'.$y.'" x2="323.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="388.5" y1="'.$y.'" x2="388.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="467.5" y1="'.$y.'" x2="467.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="551.5" y1="'.$y.'" x2="551.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="646.5" y1="'.$y.'" x2="646.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
	echo '<line x1="7.5"   y1="'.($y+19.5).'" x2="646.5" y2="'.($y+19.5).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>';

	echo '<text x="11.5px"  y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve"></text>';
	echo '<text x="61.5px"  y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@</text>';
	echo '<text x="164.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@@@</text>';
	echo '<text x="280.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@</text>';
	echo '<text x="341.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">P@</text>';
	echo '<text x="412.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@v</text>';
	echo '<text x="486.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@ځ@v</text>';
	echo '<text x="574.5px" y="'.($y+14.5).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@@v</text>';

}

//2y[Wȍ~wb_
function PutPage(
	$page,
	$total_page,
	$date_data,
	$date_print
){
	echo '<text x="115.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($page).'</text>';
	echo '<text x="137.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.disp_number_format($total_page).'</text>';
	echo '<text x="96.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$date_data.'</text>';
	echo '<text x="627.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$date_print.'</text>';
echo <<<EOD
<text x="120.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">/</text>
<text x="180.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">y[W</text>
<text x="500.5px" y="32.5px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">@</text>
EOD;
}

function StartSVG(){
//for a4<svg x="0" y="0" width="21cm" height="29.7cm" viewBox="0 0 780 930">
//for a6<svg x="0" y="0" width="21cm" height="29.7cm" viewBox="0 0 780 978">
echo <<<EOD
<page>
<svg x="0" y="0" width="21cm" height="29.7cm" viewBox="-20 0 700 880">
EOD;
}

function EndSVG(){
echo <<<EOD
</svg>
</page>
EOD;
}

function checkItemID(&$saled_data,$itemID){
//total_dataz񂩂猟
//saled_data = ziID,iAiAvAŋvj

	for($i=0; $i<count($saled_data); $i++){
		$one_ar = $saled_data[$i];
		if($one_ar[0]==$itemID){
			return $one_ar[2]; //item_purchased..
		}
	}
	return 0;
}

function getTotal($d_array){
	$x = 0;
	for($i=0; $i< count($d_array); $i++){
		$x += $d_array[$i];
	}
	return $x;
}

function getSaleNum(&$saled_data,$d_array){
//iڂ̐𐔂ďo͂B
//́F ID̔zB
	$r_array = array();
	for($i=0; $i<count($d_array); $i++){
		$target_id = $d_array[$i];//iID
		$num_sales = checkItemID($saled_data,$target_id);
		$r_array[] = $num_sales;
	}
	return $r_array;
}

function getSaleNumWithAlias(&$saled_data,$d_array,$alias){
//iڂ̐𐔂ďo͂BAliastB
//́F̔f[^AID̔zAꎋׂz
	$r_array = array();
	for($i=0; $i<count($d_array); $i++){
		$target_id = $d_array[$i];//iID
		$num_sales = checkItemID($saled_data,$target_id);

        //Alias check..
		/*
		$idx = array_search($target_id, $alias); //$idx ɂ́AΉCfbNXi=̏iԍjB
		if( $idx != FALSE ){
			$num_sales += checkItemID($saled_data, $idx);//̏iԍ̐vZ
		}
		*/
		//ĂΉł悤ɉB
		reset($alias);
		while(list($key,$var)=each($alias)){
			if($var == $target_id){
				$num_sales += checkItemID($saled_data, $key);//̏iԍ̐vZ
			}
		}
		
		$r_array[] = $num_sales;
	}
	return $r_array;
}

function getPrefNum($preflist,$pref_array){
//$preflist̏񂩂A$pref_arrayŎw肳ꂽ݂̂oB
// array preflist
// = 
//  14(Tokyo) => '10'
//  12(Saitama)=>'12'
//  15(Kanagawa)=>'0'
//  XX(Okinawa)=>'2'
	
	$data_array = array();
	$number_inlist = 0;
	$other_pref = 0;
	
	for($i=0; $i<count($pref_array); $i++){
		$pref = $pref_array[$i];
		$num = 0;
		if(array_key_exists($pref,$preflist)){
			$num = $preflist[$pref];
			$number_inlist += $num;
		}
		$data_array[] = $num;
	}
	//܂łŁAeB
	
	$other_pref = array_sum($preflist) - $number_inlist; 
	
	$data_array[] = $other_pref;
	
	return $data_array;
}

//PutData(f[^, Jns, Is, YW);
function PutData(&$data, $startline, $endline, &$y)
{
	global $display;
	global $cfg_tableprefix;
	$brands_table = $cfg_tableprefix."brands";
	$categories_table = $cfg_tableprefix."categories";
	
// ڂ̏o
	makeOneLineSVG(array(0),$y);
//f[^̏óB
 //@z1=@ʁAJeSAށA[iځAPAʁAvAŋAڌvAv]
 //@ʁF1 =>iڏv܂
 //@ʁF2 =>iڍځiށjv܂
 //@ʁF3 =>v܂ł̕\
 //  ʁF4 =>Ŕv
 //  ʁF5 =>őv
 //  ʁF6 =>ōݑv
 //  ʁF7 =>y[W1{

	$category = 'pxtestwodummy'; //݂̃JeS
	$brand = 'pxtestwodummy'; //݂̎
	$category_y = 0; //JeSpYW
	$brand_y = 0; //ތopYW
	$brand_setflag = FALSE;
	$category_setflag = FALSE;

	for($i=$startline; $i<$endline+1; $i++){

		if(isset($data[$i])){
			$one = $data[$i];
		} else {
			$one = '';
		}
		
		//f[^I蔻B
		if($i+1 > count($data)){
			return;
		}

		/*JeS\*/
		if(($category_setflag == FALSE) && ($one[0]=='1')){//v\邯ǁA܂JeSݒ肳ĂȂB
			$category = $one[1];
			$category_setflag = TRUE;
			$category_y = $y;
		}

		if(($category_setflag == TRUE) && ($one[0]=='3')){//̏I聁B\悤B
			$position_y = $y - floor(($y -$category_y)/4)*3;
			$category = $display->idToField($categories_table,'category',$category);
			print '<text x="23.5px" y="'.$position_y.'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" writing-mode="tb" xml:space="preserve">'.$category.'</text>';
			$category = 'pxtestwodummy';
			$category_setflag = FALSE;
		}
		
		/*ڕ\*/
		////////////////////////////////////////////////////////////////////////

		//ނ̕\
		if(($one[0]=='1') && ($one[2] != $brand)){//vŁAނύXĂ
			$brand = $one[2];
			$brand_y = $y;
			$brand_setflag = TRUE;
		}
		
		if($one[0]=='2' || $one[0]=='3'){//iڌvvɂA
		//ڂ̏IB
			if($brand_setflag == TRUE){
				$brand_name = $display->idToField($brands_table,'brand',$brand);
				$position_y = $y - floor(($y - $brand_y)/2);

				if( abs($position_y - $y) < 15){ //1񂵂ȂꍇYW킹B
					$position_y = $y-5;
				}

				print '<text x="54.5px" y="'.$position_y.'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">'.$brand_name.'</text>';
			}
			$brand = 'pxtestwodummy';
			$brand_setflag = FALSE;
		}
		/////////////////////////////////////////////////////////////////////////
		
		makeOneLineSVG($one,$y);
	}
	
	//[v𔲂i1y[WIƁÃy[W̍Ō̍̕ڂ\Bj

	//ނ̕\
	if($one[0]=='1'){//v܂łłB܂A܂ڕ\ĂȂB
		if($brand_setflag == TRUE){
			$brand_name = $display->idToField($brands_table,'brand',$brand);
			$position_y = $y - floor(($y - $brand_y)/2);

			if( abs($position_y - $y) < 15){ //1񂵂ȂꍇYW킹B
				$position_y = $y-5;
			}
			print '<text x="54.5px" y="'.$position_y.'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" xml:space="preserve">'.$brand_name.'</text>';
		}
	}

	//JeSij̕\
	if($one[0]=='1' || $one[0]=='2'){
		if($category_setflag == TRUE){
			$category = $display->idToField($categories_table,'category',$category);
			$position_y = $y - floor(($y - $category_y)/4)*3;
			print '<text x="23.5px" y="'.$position_y.'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:start" writing-mode="tb" xml:space="preserve">'.$category.'</text>';
		}
	
	}

// y[W
	makeOneLineSVG(array(7),$y);

	

}

function makeOneLineSVG($oneline,&$y)
{
 //@z1=@ʁAJeSAށA[iځAPAʁAvAŋAڌvAv]
 //@ʁF1 =>iڏv܂
 //@ʁF2 =>iڍځiށjv܂
 //@ʁF3 =>v܂ł̕\
 //  ʁF4 =>Ŕv
 //  ʁF5 =>őv
 //  ʁF6 =>ōݑv
 //  ʁF7 =>y[W1{

 	global $display;
	global $cfg_tableprefix;
	global $flag_withtax;
	
	if($flag_withtax=='1'){
		$title_tax = '(ŕ)';
	} else {
		$title_tax = '@@';
	}
	
	$brands_table = $cfg_tableprefix."brands";
	$categories_table = $cfg_tableprefix."categories";
	
	if(count($oneline)<=1){
		$oneline[1] = 0;
		$oneline[2] = 0;
		$oneline[3] = 0;
		$oneline[4] = 0;
		$oneline[5] = 0;
		$oneline[6] = 0;
		$oneline[7] = 0;
		$oneline[8] = 0;
		$oneline[9] = 0;
	}
	
	$oneline[1] = $display->idToField($categories_table,'category',$oneline[1]);
	$oneline[2] = $display->idToField($brands_table,'brand',$oneline[2]);
	$oneline[3] = $display->formatData('item_id',$oneline[3],$cfg_tableprefix);
	
	$oneline[4] = disp_number_format($oneline[4]);
	$oneline[5] = disp_number_format($oneline[5]);
	$oneline[6] = disp_number_format($oneline[6]);
	$oneline[7] = disp_number_format($oneline[7]);
	$oneline[8] = disp_number_format($oneline[8]);
	$oneline[9] = disp_number_format($oneline[9]);
	
	
	$text = '';
	switch($oneline[0]){
	case 0:
		//ڌȍo
		print '<line x1="7.5"    y1="'.$y.'"    x2="646.5" y2="'.$y.'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5"  y1="'.$y.'"    x2="646.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5"  y1="'.$y.'"    x2="116.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5"    y1="'.$y.'"    x2="6.5"   y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5"   y1="'.$y.'"    x2="38.5"  y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5"  y1="'.$y.'"    x2="266.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5"  y1="'.$y.'"    x2="323.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5"  y1="'.$y.'"    x2="388.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5"  y1="'.$y.'"    x2="467.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5"  y1="'.$y.'"    x2="551.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="7.5"    y1="'.($y+19).'" x2="646.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>';
		print '<text x="11.5px"  y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve"></text>';
		print '<text x="61.5px"  y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@</text>';
		print '<text x="164.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@@@</text>';
		print '<text x="280.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@</text>';
		print '<text x="341.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">P@</text>';
		print '<text x="486.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@ځ@v</text>';
		print '<text x="412.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@v</text>';
		print '<text x="574.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:9pt;text-anchor:start" xml:space="preserve">@@v</text>';
		$y = $y + 19;
		break;
	case 1:
		//eiځAv܂ł̕\
		print '<line x1="6.5" y1="'.$y.'" x2="6.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5" y1="'.$y.'" x2="38.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5" y1="'.$y.'" x2="116.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5" y1="'.$y.'" x2="266.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5" y1="'.$y.'" x2="323.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5" y1="'.$y.'" x2="388.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5" y1="'.$y.'" x2="467.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5" y1="'.$y.'" x2="551.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5" y1="'.$y.'" x2="646.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5" y1="'.($y+19).'" x2="467.5" y2="'.($y+19).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<text x="121.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">'.$oneline[3].'</text>';
		print '<text x="320.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[5].'</text>';
		print '<text x="384.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[4].'</text>';
		print '<text x="461.5px" y="'.($y+14).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[6].'</text>';
		$y = $y + 19;
		break;
	case 2:
		//ڌvB
		//ŏ̓d
		print '<line x1="38.5" y1="'.$y.'" x2="551.5" y2="'.$y.'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5" y1="'.($y+3).'" x2="551.5" y2="'.($y+3).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		//c
		print '<line x1="6.5" y1="'.$y.'" x2="6.5" y2="'.($y+24).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5" y1="'.($y+1).'" x2="38.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5" y1="'.($y+3).'" x2="116.5" y2="'.($y+22).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5" y1="'.($y+3).'" x2="266.5" y2="'.($y+22).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5" y1="'.($y+3).'" x2="323.5" y2="'.($y+22).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5" y1="'.($y+3).'" x2="388.5" y2="'.($y+22).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5" y1="'.($y+3).'" x2="467.5" y2="'.($y+22).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5" y1="'.($y+1).'" x2="551.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5" y1="'.($y).'" x2="646.5" y2="'.($y+24).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		//Ō̉
		print '<line x1="38.5" y1="'.($y+24).'" x2="551.5" y2="'.($y+24).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>';
		print '<text x="186.5px" y="'.($y+17).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">v</text>';
		print '	<text x="461.5px" y="'.($y+17).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[6].'</text>';
		print '<text x="548.5px" y="'.($y+17).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[8].'</text>';
		$y = $y + 24;
		break;
	case 3:
		//v
		print '<line x1="38.5" y1="'.$y.'" x2="646.5" y2="'.$y.'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5" y1="'.($y+3).'" x2="646.5" y2="'.($y+3).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5" y1="'.($y).'" x2="38.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5" y1="'.($y).'" x2="6.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5" y1="'.($y+3).'" x2="116.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5" y1="'.($y+4).'" x2="266.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5" y1="'.($y+4).'" x2="323.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5" y1="'.($y+4).'" x2="388.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5" y1="'.($y+4).'" x2="467.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5" y1="'.($y+4).'" x2="551.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5" y1="'.($y+0).'" x2="646.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5" y1="'.($y+23).'" x2="646.5" y2="'.($y+23).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:2;stroke-linecap:round"/>';
		print '<text x="186.5px" y="'.($y+16).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">v</text>';
		print '<text x="461.5px" y="'.($y+16).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[6].'</text>';
		print '<text x="548.5px" y="'.($y+16).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[8].'</text>';
		print '<text x="642.5px" y="'.($y+16).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[9].'</text>';
		$y = $y + 23;
		break;
	case 4:
		//Ŕv
		print '<line x1="6.5"    y1="'.($y+0).'" x2="646.5" y2="'.($y+0).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5"    y1="'.($y+3).'" x2="646.5" y2="'.($y+3).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';

		print '<line x1="6.5"    y1="'.($y+1).'" x2="6.5  " y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5"   y1="'.($y+3).'" x2="38.5"  y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5"  y1="'.($y+3).'" x2="116.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5"  y1="'.($y+3).'" x2="266.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5"  y1="'.($y+3).'" x2="323.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5"  y1="'.($y+3).'" x2="388.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5"  y1="'.($y+3).'" x2="467.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5"  y1="'.($y+3).'" x2="551.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5"  y1="'.($y+1).'" x2="646.5" y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<text x="173.5px" y="'.($y+18).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">    v</text>';
		print '<text x="644.5px" y="'.($y+19).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[9].'</text>';
		$y = $y + 25;
		break;
	case 5:
		//őv
		print '<line x1="6.5"    y1="'.($y+0).'" x2="646.5" y2="'.($y+0).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5"    y1="'.($y+3).'" x2="646.5" y2="'.($y+3).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';

		print '<line x1="6.5"    y1="'.($y+1).'" x2="6.5  " y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5"   y1="'.($y+3).'" x2="38.5"  y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5"  y1="'.($y+3).'" x2="116.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5"  y1="'.($y+3).'" x2="266.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5"  y1="'.($y+3).'" x2="323.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5"  y1="'.($y+3).'" x2="388.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5"  y1="'.($y+3).'" x2="467.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5"  y1="'.($y+3).'" x2="551.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5"  y1="'.($y+1).'" x2="646.5" y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<text x="173.5px" y="'.($y+18).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">'.$title_tax.'</text>';
		print '<text x="644.5px" y="'.($y+19).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[6].'</text>';
		$y = $y + 25;
		break;
	case 6:
		//ōݑv
		print '<line x1="6.5"    y1="'.($y+0).'" x2="646.5" y2="'.($y+0).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5"    y1="'.($y+3).'" x2="646.5" y2="'.($y+3).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';

		print '<line x1="6.5"    y1="'.($y+1).'" x2="6.5  " y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="38.5"   y1="'.($y+3).'" x2="38.5"  y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="116.5"  y1="'.($y+3).'" x2="116.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="266.5"  y1="'.($y+3).'" x2="266.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="323.5"  y1="'.($y+3).'" x2="323.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="388.5"  y1="'.($y+3).'" x2="388.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="467.5"  y1="'.($y+3).'" x2="467.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="551.5"  y1="'.($y+3).'" x2="551.5" y2="'.($y+25).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="646.5"  y1="'.($y+1).'" x2="646.5" y2="'.($y+28).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';

		print '<line x1="6.5"    y1="'.($y+26).'" x2="646.5" y2="'.($y+26).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<line x1="6.5"    y1="'.($y+29).'" x2="646.5" y2="'.($y+29).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		print '<text x="173.5px" y="'.($y+18).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:8pt;text-anchor:start" xml:space="preserve">@@v</text>';
		print '<text x="644.5px" y="'.($y+19).'px" style="fill:rgb(0,0,0);font-family:MS-PGothic;font-size:10pt;text-anchor:end" xml:space="preserve">'.$oneline[9].'</text>';
		$y = $y + 28;
		break;
	case 7:
		//y[W1{
		print '<line x1="6.5"    y1="'.($y+0).'" x2="646.5" y2="'.($y+0).'" style="fill:none;stroke:rgb(0,0,0);stroke-width:1;stroke-linecap:round"/>';
		break;
	default:
		break;

	}

	return $text;

}


///////////////////////////////////////////////////////////////////////
//sF
///////////////////////////////////////////////////////////////////////

$date_data = $rep_span;
$date_print = $rep_date;

//̔ς݃f[^̍쐬(getSaleNumŎgp܂B)
//ziID,iAiAvAŋvj
//$saled_data = makeSaledData($date1, $date2);
$saled_data = $dbf->makeSaledData($date1,$date2);


//\pf[^쐬(̔f[^)
/*
$colum1 = getSaleNum($saled_data,$c1_array);
$colum2 = getSaleNum($saled_data,$c2_array); 
$colum3 = getSaleNum($saled_data,$c3_array);
*/
$colum1 = getSaleNumWithAlias($saled_data,$c1_array,$alias_array);
$colum2 = getSaleNumWithAlias($saled_data,$c2_array,$alias_array); 
$colum3 = getSaleNumWithAlias($saled_data,$c3_array,$alias_array);

$colum1_total = getTotal($colum1);
$colum2_total = getTotal($colum2);
$colum3_total = getTotal($colum3);

//\pf[^쐬(f[^)

//aliasf[^̕iID
$ali_ids = array();
while(list($key,$var)=each($alias_array)){
	array_push($ali_ids, $key);
}

$tmp_itemlist = array_merge($c1_array, $c2_array, $c3_array, $ali_ids);

$preflist = $dbf->getPrefbyItem($date1, $date2, $tmp_itemlist);
$colum4 = getPrefNum($preflist,$pref_array);
$colum4_total = array_sum($preflist);

//ʃf[^쐬I

//x͔グf[^I

//OIDB
$filID = array_merge($c1_array,$c2_array,$c3_array, $ali_ids);

//\pf[^̍쐬B
$dispData = $dbf->makeRowData($saled_data, $filID, $flag_withtax);

//ŁASVGɂȂÕf[^擾B

/*f[^쐬I*/

//SVGo

	$pxDoc = new pxDoc();
	$pxDoc->BeginPxd('A4','|[g','golf_report');

	$num_of_lines = count($dispData);
	$num_of_lines_from_Page2 = $num_of_lines - SALE_LINES_PAGE1;
	//_؂グ
	$num_of_other_pages = ceil( $num_of_lines_from_Page2 / SALE_LINES_OTHER_PAGE ); 

	StartSVG();

	//1y[W
	PutHead(
		$title, //AAN
		1, //$pagenum, 
		$num_of_other_pages + 1, //$pagetotal,
		$date_data, //'2005/5/1'
		$date_print, //'2005/5/1'
		$colum1, //array
		$colum1_total,
		$colum2, //array
		$colum2_total,
		$colum3, //array
		$colum3_total,
		$colum4, //array
		$colum4_total
	);

	//PutData(f[^, Jns, Is, YW);
	$y = FIRST_PAGE_Y;
	PutData($dispData, 0, SALE_LINES_PAGE1, $y);
		
	EndSVG();

	//Qy[Wڈȍ~

	for($i=0; $i<$num_of_other_pages; $i++){

		StartSVG();

		PutPage(
			$i+2, //page
			$num_of_other_pages + 1, //total pages
			$date_data,
			$date_print
		);

		$y = OTHER_PAGE_Y;
		//PutData(f[^, Jns, Is, YW);
		PutData($dispData, SALE_LINES_PAGE1+1+(SALE_LINES_OTHER_PAGE* $i), SALE_LINES_PAGE1+(SALE_LINES_OTHER_PAGE * ($i+1) ) , $y);
		
		EndSVG();
	}
	
	$pxDoc->EndPxd();


?>
