<?php 

include ("../set_session.php");
session_start();
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");

//creates 3 objects needed for this script.
$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);

//checks if user is logged in.
if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit ();
}

?>

<html>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
<head>
	
</head>

<body>
<?php

//variables needed globably in this file.
$tablename="$cfg_tableprefix".'items';
$field_names=null;
$field_data=null;
$id=-1;

	//checks to see if action is delete and an ID is specified. (only delete uses $_GET.)
	if(isset($_GET['action']) and isset($_GET['id']))
	{
		$action=$_GET['action'];
		$id=$_GET['id'];
	}
	//checks to make sure data is comming from form ($action is either delete or update)
	elseif(isset($_POST['item_name']) and isset($_POST['description']) and isset($_POST['item_number']) and isset($_POST['brand_id']) 
	and isset($_POST['category_id']) and isset($_POST['supplier_id']) and isset($_POST['buy_price']) and isset($_POST['unit_price']) and isset($_POST['tax_percent']) 
	and isset($_POST['supplier_catalogue_number']) and isset($_POST['quantity']) and isset($_POST['id']) and isset($_POST['action']) )
	{
		
		$action=$_POST['action'];
		$id = $_POST['id'];
		
		//gets variables entered by user.
		$item_name = $_POST['item_name'];
		$description = $_POST['description'];
		$item_number = $_POST['item_number'];
		$brand_id = $_POST['brand_id'];
		$category_id = $_POST['category_id'];
		$supplier_id = $_POST['supplier_id'];
		$buy_price = my_number_format($_POST['buy_price'],2,'.', '');
		$unit_price = my_number_format($_POST['unit_price'],2,'.', '');
		$tax_percent = $_POST['tax_percent'];
		//$tax_cal_type = $_POST['tax_cal_type'];
		$supplier_catalogue_number = $_POST['supplier_catalogue_number'];
		$quantity = my_number_format($_POST['quantity']);

		//f[^ZbVɎĂB
		$ses_header = 'itemreg_';
		foreach($_POST as $POST_name => $POST_value) {
			$tmp_name = $ses_header.$POST_name;
			$_SESSION[$tmp_name] = $POST_value;
		}
		
		//$unit_priceɂ́Aō݂œĂ悤ɂȂ̂ŁAB
		////
		$tmp_unit_price = floor ($unit_price / ( $tax_percent /100 +1 )); //؎̂ĂŐŔPvZ
		$tmp_unit_tax   = $dbf->tax_calc($tmp_unit_price, $tax_percent, 3); //؎̂ĂŐŋvZ
		
		if( ($tmp_unit_price + $tmp_unit_tax) //A؎̂ĂŒ[oȂȂA
			== $unit_price
		){
			$unit_price = floor ($unit_price / ( $tax_percent /100 +1 ));
			$tax_cal_type = 3;
		
		} else {
			$unit_price = floor ($unit_price / ( $tax_percent /100 +1 ));
			$tax_cal_type = 2; //؂グB
		}
		////
		//insure all fields are filled in.
		if($item_name=='' or $brand_id=='' or $category_id=='' or $supplier_id=='' or $buy_price=='' or $tax_percent=='' or $quantity=='' )
		{
		
			if($item_name==''){
				echo 'iږE';
			}
			if($brand_id==''){
				echo 'ނhcE';
			}
			if($category_id==''){
				echo 'E';
			}
			if($supplier_id==''){
				echo 'dE';
			}
			if($buy_price==''){
				echo 'lE';
			}
			if($unit_price==''){
				echo 'PE';
			}
			if($tax_percent==''){
				echo 'ŗE';
			}
			if($quantity==''){
				echo 'ʁE';
			}
		
			echo "$lang->forgottenFields";
			exit();
		}
		elseif( (!is_numeric($buy_price)) or (!is_numeric($unit_price)) or (!is_numeric($tax_percent)) or (!is_numeric($quantity)))
		{
			echo "$lang->mustEnterNumeric"."<BR>";
			echo "buy_price->".$buy_price.(is_numeric($buy_price)?":OK":":ERROR!")."<BR>";
			echo "unit_price->".$unit_price.(is_numeric($unit_price)?":OK":":ERROR!")."<BR>";
			echo "tax_percent->".$tax_percent.(is_numeric($tax_percent)?":OK":":ERROR!")."<BR>";
			echo "quantity->".$quantity.(is_numeric($quantity)?":OK":":ERROR!")."<BR>";
			
			exit();
		}
		else
		{

			//$total_cost = my_number_format($unit_price*(1+($tax_percent/100)),2,'.', ''); 
			//This is a modification for Japanese Calculation.
			//$total_cost = my_number_format( $unit_price + Round ($unit_price*($tax_percent/100))           ,2,'.', ''); 
			$total_cost = my_number_format( $unit_price + $dbf->tax_calc($unit_price, $tax_percent, $tax_cal_type)           ,2,'.', ''); 
			
			$field_names=array('item_name','description','item_number','brand_id','category_id','supplier_id','buy_price','unit_price','tax_percent','tax_cal_type','supplier_catalogue_number','total_cost','quantity');
			$field_data=array("$item_name","$description","$item_number","$brand_id","$category_id","$supplier_id","$buy_price","$unit_price","$tax_percent","$tax_cal_type","$supplier_catalogue_number","$total_cost","$quantity");	
	
		}
		
	}
	else
	{
		//outputs error message because user did not use form to fill out data.
		echo "$lang->mustUseForm";
		exit();
	}
	


switch ($action)
{
	//finds out what action needs to be taken and preforms it by calling methods from dbf class.
	case $action=="insert":
		//$dbf->insert($field_names,$field_data,$tablename,true);
		//by S.D
		//$next_id = $dbf->GetNext_ItemID();
		$next_id = $id; //Kw肷悤ɂ܂̂ŁccB2005/08
		$dbf->Custom_insert($field_names,$field_data,$tablename,$next_id,true);
		
		//session폜I
		$ses_header = 'itemreg_';
		$ses_headlen = strlen($ses_header);
		foreach($_SESSION as $SESSION_name => $SESSION_value) {
			if(substr($SESSION_name,0,$ses_headlen) == $ses_header){
				unset($_SESSION[$SESSION_name]);
			}
		}
		
	break;
		
	case $action=="update":
		$dbf->update($field_names,$field_data,$tablename,$id,true);
		
	break;
	
	case $action=="delete":
		$dbf->deleteRow($tablename,$id);
	
	break;
	
	default:
		echo "lang->noActionSpecified";
	break;
}
$dbf->closeDBlink();

?>
<br>
<a href="manage_items.php"><?php echo $lang->manageItems ?>--></a>
<br>
<a href="form_items.php?action=insert"><?php echo $lang->createNewItem ?>--></a>
</body>
</html>
