<?php 

include ("../set_session.php");
session_start();
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/display.php");
include ("../classes/form.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
<SCRIPT LANGUAGE="Javascript">
<!---
function decision(message, url)
{
  if(confirm(message) )
  {
    location.href = url;
  }
}
// --->
</SCRIPT> 

</head>

<body>
<?php

$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$display->displayTitle("$lang->manageCustomers");

$f1=new form('manage_customers.php','POST','customers','450',$cfg_theme,$lang);
$f1->createInputField("<b>$lang->searchForCustomer</b>",'text','search','','24','350','1');
$f1->endForm();


$tableheaders=array("$lang->rowID","$lang->play_times","$lang->lastName","$lang->firstName","$lang->in_lastname50","$lang->in_firstname50","$lang->phoneNumber","$lang->email","$lang->streetAddress","$lang->commentsOrOther","$lang->updateCustomer","$lang->deleteCustomer");
$tablefields=array('id','play_times','last_name','first_name','last_name_50','first_name_50','phone_number','email','street_address','comments');

if(isset($_POST['search']))
{
	$search=$_POST['search'];
	echo "<center>$lang->searchedForCustomer: <b>$search</b></center>";
	//$display->displayManageTable("$cfg_tableprefix",'customers',$tableheaders,$tablefields,'first_name',"$search",'first_name');
	$display->displayManageTable("$cfg_tableprefix",'customers',$tableheaders,$tablefields,'last_name_50',"$search",'last_name_50,first_name_50');
}
else
{
	$display->displayManageTable("$cfg_tableprefix",'customers',$tableheaders,$tablefields,'','','last_name_50,first_name_50');
}


$dbf->closeDBlink();


?>
</body>
</html>