<?php
// By SD. CBA-Japan All Rights Reserved for this script.
include ("../set_session.php");
session_start();
include ("../settings.php");
include("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$cf=new Codefilter();

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

function enterandreturn()
{
	global $lang;

	echo <<<EOD
<script type="text/javascript" language="javascript">
function getKeyCode(e) {
   if( (_getKEYCODE(e)==13) ){
		location.href = "customer_totallist.php";
   }
}

//--ꂽL|R[hԂ
function _getKEYCODE(e){
  var ua = navigator.userAgent
  if(ua.search('opera(\ |\/)6')!=-1)  //o6s
    return null
  else if(document.layers)            //n4p
    return  e.which
  else if(document.all)               //e4,e5,e6,o7,s1p
    return  event.keyCode
  else if(document.getElementById)    //n6,n7,mozp
    return  e.which
  else return null                    //LȊO
}

window.document.onkeypress=getKeyCode;
</script>
EOD;
	echo "<br><center><font size=\"2\">".$lang->enter_then_return."</font></center>\n";

}
////////////////////////////////////////////////////////////////////////////////////
?>

<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=<?php echo $lang->CharCode?>">
<?PHP
$customers_table="$cfg_tableprefix".'customers';
$lockers_table="$cfg_tableprefix".'lockers';

$locker = isset($_GET['locker']) ? $_GET['locker']: $_POST['locker'];
$act = $_POST['act'];
$new_locker = $_POST['new_locker'];

?>
<script type="text/javascript" language="javascript">
<!--
function lockerFocus()
{
	document.locker_edit.new_locker.focus();
}

function confirmDelete()
{
  if(confirm('{ɍ폜܂')) {
	document.cus_delete.submit();
  }
}

//-->
</script>
<head>

<?PHP
echo "<html><body onLoad='lockerFocus();'>";

$display->displayTitle("$lang->loc_title");

//locker check.
if(isset($_POST['new_locker'])){
		if($dbf->isLockerUsed($new_locker)){
			echo "<center>$lang->lockernum ($new_locker): <font color = 'RED'><B>".$lang->alreadyUsed."</B></font></center><BR><HR>";
			$act = '';
		}

		if(!is_numeric($new_locker)){
			echo "<center>$lang->lockernum ($new_locker): <font color = 'RED'><B>".$lang->notnumber."</B></font></center><BR><HR>";
			$act = '';
		} 
		
}

if(isset($_POST['new_locker'])){
		if($new_locker == ''){
			echo "<center>$lang->lockernum ($new_locker): <font color = 'RED'><B>".$lang->loc_cannotuse."</B></font></center><BR><HR>";
			$act = '';
		}
}

if(isset($_POST['course'])){
	$new_course = $_POST['course'];
}
if(isset($_POST['in_out'])){
	$new_in_out = $_POST['in_out'];
}

switch($act){

	case 'delete':
	
		$id = $dbf->lockertocustomer_id($locker);
		$count_sales_notyet = $dbf->GetCountNotYetPaid($id);
		
		if($count_sales_notyet){
			echo "<center><font color='RED'><B>$lang->loc_already_bought</B></font></center>";
			enterandreturn();
			die;
		}

		if($dbf->DeleteLocker( $locker )){
			echo "<center>$lang->loc_delete_succeed</center>";
		}
		enterandreturn();
	break;

	case 'change':
		if($dbf->ChangeLockerNumber( $locker, $new_locker)){
			echo "<center>$lang->loc_succeed</center>";
			$headers = array ( "ύXO", "ύX" );
			$data = array ( array($locker,$new_locker) );
			$display->displayTable_horizontal($headers, $data, 100);
			enterandreturn();
		} else {
			echo "<center>$lang->loc_failure</center>";
		};
	break;

	case 'course_change':
		if($dbf->ChangeStartCourse( $locker, $new_course )){
			echo "<center>$lang->loc_succeed</center>";
			$name = $display->GetCourseInfo($new_course, $cfg_course1,$cfg_course2);
			$id = $dbf->lockertocustomer_id($locker);
			$customer_name = $dbf->getCustomerName($id);
			$headers = array ("O","R[X̕ύX" );
			$data = array ( array($customer_name, $name[0]." ".$name[1]) );
			$display->displayTable_horizontal($headers, $data, 300);
			enterandreturn();
		} else {
			echo "<center>$lang->loc_failure</center>";
		};
	break;
	
	default:
		
		$id = $dbf->lockertocustomer_id($locker);
		$customer_name = $dbf->getCustomerName($id);
		$course_num = $dbf->getStartCourse($locker,$id);
		$course_name = $display->GetCourseInfo($course_num,$cfg_course1,$cfg_course2);
		
		echo "<center><table align='center' cellspacing='1' cellpadding='1' bgcolor=$display->table_bgcolor style='border: solid black 1px'>\n";

		echo "<tr bgcolor=$display->rowcolor2><td>".$lang->loc_name.":  ".$customer_name.$lang->sama."</td>\n";
		echo "<td>";
			//echo "<BR><BR><BR><center><table><tr><td>";
			echo "<center><form name='cus_delete' action = 'customer_locker_edit.php' method='POST'>\n";
			echo "<input type='hidden' name='locker' value='".$locker."'>";
			echo "<input type='hidden' name='act' value='delete'>";
			echo "<input type ='button' value = '$lang->loc_delete' onClick='confirmDelete()' >";
			echo "</td></form></center>";
			//echo "</td></tr></table></center>\n";
		echo "</tr>\n";

		echo "<tr bgcolor=$display->rowcolor2><td>".$lang->loc_now_locker.":  ".$locker."</td>\n";
		echo "<td>";
			//creates a form object
			$f1=new form('customer_locker_edit.php','POST','locker_edit','450',$cfg_theme,$lang);
			//creates form parts.
			$f1->createInputField("$lang->loc_new_locker: ",'text','new_locker',"",'24','200','0','0');
			echo "<input type='hidden' name='act' value='change'>";
			echo "<input type='hidden' name='locker' value='".$locker."'>";
			$f1->endForm_noTR();
		echo "</td></tr>\n";

		echo "<tr bgcolor=$display->rowcolor2><td>".$lang->presentCourse.":  ".$course_name[0]." ".$course_name[1]."</td>\n";
		echo "<td>";
			//creates a form object
			$f1=new form('customer_locker_edit.php','POST','locker_edit','450',$cfg_theme,$lang);
	
			//Course
			$course_option_titles = array(
				"$lang->no_courseinfo",
				"$lang->no_courseinfo",
				"$cfg_course1"." OUT",
				"$cfg_course1"." IN",
				"$cfg_course2"." OUT",
				"$cfg_course2"." IN"
			);
	
			$course_option_values = array("0","0","2","1","4","3");
			$course_option_titles[0] = $course_option_titles[$course_num];//course 1
			$course_option_values[0] = $course_num; 
			$f1->createSelectField_NoOrder("$lang->newCourse:",'course',$course_option_values,$course_option_titles,'200','0');
	
			echo "<input type='hidden' name='act' value='course_change'>";
			echo "<input type='hidden' name='locker' value='".$locker."'>";
			$f1->endForm_noTR();
		echo "</td></tr>\n";

		echo "</table></center>\n";
		


		//enterandreturn();

	break;

}

echo "</body></html>\n";


?>