<?php
// By SD. CBA-Japan All Rights Reserved for this script.

include ("../set_session.php");
session_start();
include ("../settings.php");
include("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

//create menu link
function make_search_menu($value)
{
	global $lang;

	$url = '';
	$main_url = 'customer_group_checkout.php';
	$manual = 'm_srch';
	$group = 'g_srch';
	$party = 'p_srch';
	
	switch($value){
		case '0':
			$url = "[$lang->co_manual]";
			$url.= "/<a href='$main_url?act=g_srch'> [$lang->co_grouplist]</a>";
			//$url.= "/<a href='$main_url?act=p_srch'> [$lang->co_partylist]</a>";
		break;
		
		case '1':
			$url = "<a href='$main_url?act=m_srch'>[$lang->co_manual]</a>";
			$url.= "/ [$lang->co_grouplist]";
			//$url.= "/<a href='$main_url?act=p_srch'> [$lang->co_partylist]</a>";
		break;
		
		case '2':
			$url = "<a href='$main_url?act=m_srch'>[$lang->co_manual]</a>";
			$url.= "/<a href='$main_url?act=g_srch'> [$lang->co_grouplist]</a>";
			//$url.= "/ [$lang->co_partylist]";
		break;
		
		default:
			$url = "[$lang->co_manual]";
			$url.= "/<a href='$main_url?act=g_srch'> [$lang->co_grouplist]</a>";
			//$url.= "/<a href='$main_url?act=p_srch'> [$lang->co_partylist]</a>";
		break;
	}
	return $url;
}

//make title
function make_title($value){
	global $lang;

	switch($value){
		case '0':
			$title= "$lang->co_manual";
		break;
		
		case '1':
			$title= "$lang->co_grouplist";
		break;
		
		case '2':
			$title= "$lang->co_partylist";
		break;
		
		default:
			$title= "$lang->co_manual";
		break;
	}
	return $title;
}

//make search form.
function search_form($value){
	
	global $cfg_theme;
	global $lang;
	
	switch($value){
		case '0':
			//$title= "$lang->co_manual";
			$f1=new form('customer_group_checkout.php','POST','customers','400',$cfg_theme,$lang);
			//creates form parts.
			$f1->createInputField("$lang->lockernum: ",'text','locker_num',"",'24','200');
			$f1->createInputField("$lang->customer_name: ",'text','customer_name',"",'24','200','1');
			$f1->createInputField("$lang->customernum: ",'text','customer_num',"",'24','150');
			echo "<input type=\"hidden\" name=\"act\" value = \"cust_search\">";
			$f1->endForm();
		break;
		
		case '1':
			//$title= "$lang->co_grouplist";
			$f1=new form('customer_group_checkout.php','POST','customers','400',$cfg_theme,$lang);
			//creates form parts.
			$f1->createInputField("$lang->co_group: ",'text','name',"",'24','200','1');
			echo "<input type=\"hidden\" name=\"act\" value = \"group_search\">";
			$f1->endForm();
		break;
		
		case '2':
			//$title= "$lang->co_partylist";
			$f1=new form('customer_group_checkout.php','POST','customers','400',$cfg_theme,$lang);
			//creates form parts.
			$f1->createInputField("$lang->co_party: ",'text','name',"",'24','200');
			echo "<input type=\"hidden\" name=\"act\" value = \"party_search\">";
			$f1->endForm();
		break;
		
		default:
			//$title= "$lang->co_manual";
			$f1=new form('customer_group_checkout.php','POST','customers','400',$cfg_theme,$lang);
			//creates form parts.
			$f1->createInputField("$lang->lockernum: ",'text','locker_num',"",'24','200');
			$f1->createInputField("$lang->customer_name: ",'text','customer_name',"",'24','200','1');
			$f1->createInputField("$lang->customernum: ",'text','customer_num',"",'24','150');
			echo "<input type=\"hidden\" name=\"act\" value = \"cust_search\">";
			$f1->endForm();
		break;
	}
}

//list selected members
function putout_members(){
	global $display;
	global $lang;
	global $customers_table;
	global $dbf;
	global $cf;

	$total_array = array();
	$one_array = array();
	//print_r($_SESSION);
	if(isset($_SESSION['co_reg_members'])){
		for($i=0;$i<count($_SESSION['co_reg_members']);$i++){
			
			$cus_id = $_SESSION['co_reg_members'][$i];
			
			if($cus_id!=0){
				$query="SELECT id,birth,last_name_50,first_name_50 FROM $customers_table WHERE id=".$cus_id; 
				//echo $query;
				$result=mysql_query($query,$dbf->conn) or die(mysql_error());//
	
				$row=mysql_fetch_assoc($result);
				$one_array = array();
				//name.
				$temp_full_name = $dbf->getCustomerName($row['id']);
				$one_array[] = $row['id'];
				$one_array[] =  $temp_full_name.$lang->sama;
				$one_array[] =  $cf->GetDB($row['last_name_50']);
				$one_array[] =  $cf->GetDB($row['first_name_50']);
				$one_array[] =  $row['birth'];
				$one_array[] =  "<a href='customer_group_checkout.php?act=delete&id=".$row['id']."'>".$lang->delete_from."</a>";
				array_push($total_array,$one_array);
			}
		}
	}

	$tableheaders = array(
		"ID",
		"$lang->cust_name",
		"$lang->lastName",
		"$lang->firstName",
		"$lang->in_birthdate",
		"$lang->delete_from_list"
	);

	$display->displayTable_horizontal($tableheaders,$total_array,'550','test','POST');
}

//print searched results
function disp_id($cus_array){

	global $dbf;
	global $cf;
	global $lang;
	global $display;
	global $customers_table;
	
	$where = 'id='.$cus_array[0];
	for($i=1;$i<count($cus_array);$i++){
		if($dbf->isValidCustomer($cus_array[$i]) != False){
			$where .= ' OR id='.$cus_array[$i];
		}
	}
	
	$query="SELECT id,birth,last_name_50,first_name_50 FROM $customers_table WHERE ".$where; 
	$result=mysql_query($query,$dbf->conn) or die(mysql_error());//
	
	$total_array = array();
	
	//make detail list....
	while($row=mysql_fetch_assoc($result)){
		$one_array = array();
		//name.
		$temp_full_name = $dbf->getCustomerName($row['id']);
		$one_array[] =  $temp_full_name.$lang->sama;
		$one_array[] =  $cf->GetDB($row['last_name_50']);
		$one_array[] =  $cf->GetDB($row['first_name_50']);
		$one_array[] =  $row['birth'];
		$temp_id = $row['id'];
		$one_array[] =  "<a href='customer_group_checkout.php?act=insert&id=".$temp_id."'>".$lang->add_to."</a>";
		array_push($total_array,$one_array);
	}

	$tableheaders = array(
		"$lang->cust_name",
		"$lang->lastName",
		"$lang->firstName",
		"$lang->in_birthdate",
		"$lang->add_to_list"
	);
	
	$display->displayTable_horizontal($tableheaders,$total_array,'400','names','GET');
}

function disp_locker($locker){

	global $dbf;
	global $lang;

	if($dbf->isLockerUsed($locker) == False){
		echo "$lang->lockernum ".$locker." $lang->isNotUsed";
	} else {
		$cus_array = array($dbf->lockertocustomer_id($locker));
		disp_id($cus_array);
	}
}

function disp_cusname($cus_name){

	global $dbf;
	global $cf;
	global $lang;
	global $display;
	global $customers_table;
	
	$cus_name_euc = $cf->PutDB($cus_name);
	$where = "last_name like \"%$cus_name_euc%\" or first_name like \"%$cus_name_euc%\"  or last_name_50 like \"%$cus_name_euc%\"  or first_name_50 like \"%$cus_name_euc%\" ORDER by last_name";
	$query="SELECT id,last_name_50,first_name_50,birth FROM $customers_table WHERE ".$where; 
	$result=mysql_query($query,$dbf->conn) or die(mysql_error());//
	$total_array = array();
	
	//make detail list....
	while($row=mysql_fetch_assoc($result)){
		$one_array = array();
		//name.
		$temp_full_name = $dbf->getCustomerName($row['id']);
		$one_array[] =  $temp_full_name.$lang->sama;
		$one_array[] =  $cf->GetDB($row['last_name_50']);
		$one_array[] =  $cf->GetDB($row['first_name_50']);
		$one_array[] =  $row['birth'];
		$temp_id = $row['id'];
		$one_array[] =  "<a href='customer_group_checkout.php?act=insert&id=".$temp_id."'>".$lang->add_to."</a>";
		array_push($total_array,$one_array);
	}

	$tableheaders = array(
		"$lang->cust_name",
		"$lang->lastName",
		"$lang->firstName",
		"$lang->in_birthdate",
		"$lang->add_to_list"
	);
	
	$display->displayTable_horizontal($tableheaders,$total_array,'500','names','GET');
}

function put_group($group_name){
	global $dbf;
	global $cf;
	global $lang;
	global $display;
	global $group_table;
	
	$gr_name_euc = $cf->PutDB($group_name);
	$where = "name like \"%$gr_name_euc%\" or name_50 like \"%$gr_name_euc%\" ORDER by name";
	$query="SELECT name,comment,id FROM $group_table WHERE ".$where; 
	//echo $query;
	
	$result=mysql_query($query,$dbf->conn) or die(mysql_error());//
	$total_array = array();
	
	//make detail list....
	while($row=mysql_fetch_assoc($result)){
		$one_array = array();
		//name.
		$one_array[] =  $cf->GetDB($row['name']);
		$one_array[] =  $cf->GetDB($row['comment']);
		$temp_id = $row['id'];
		$one_array[] =  "<a href='customer_group_checkout.php?act=gr_insert&id=".$temp_id."'>".$lang->add_to."</a>";
		array_push($total_array,$one_array);
	}

	$tableheaders = array(
		"$lang->group_name",
		"$lang->group_comment",
		"$lang->add_to_list"
	);
	
	$display->displayTable_horizontal($tableheaders,$total_array,'500','names','GET');
}

function cus_reg_insert($cus_id){

	global $dbf;
	global $lang;
	
	if($dbf->isValidCustomer($cus_id) != False){
		
		$index = FALSE;
		
		if(isset($_SESSION['co_reg_members'])){
			$index = array_search($cus_id,$_SESSION['co_reg_members'],FALSE);
		}
		
		if($index===FALSE){
			$_SESSION['co_reg_members'][] = $cus_id;
		} else {
			echo "$lang->searchBycusID ".$cus_id."$lang->isalreadyregisterd";
		}
	} else {
		echo "$lang->searchBycusID ".$cus_id." $lang->isNotUsed";
	}
}

function array_delete_one($array,$index){
	$temp_array = array();
	for($i=0;$i<count($array);$i++){
		if($i!=$index){
			$temp_array[] = $array[$i];
		}
	}
	return $temp_array;
}

function cus_reg_delete($cus_id){
	$index = array_search($cus_id,$_SESSION['co_reg_members']);
	//echo $index;
	$_SESSION['co_reg_members'] = array_delete_one($_SESSION['co_reg_members'],$index);
}

function focus_control($value){
	if($value==0){
		echo "<html><body onLoad='lockerFocus();'>";
	} else {
		echo "<html><body onLoad='nameFocus();'>";
	}
}

function group_insert($group_id){
	global $dbf;
	global $group_members_table;
	
	$query="SELECT customer_id FROM $group_members_table WHERE group_id=".$group_id; 
	//echo $query;
	
	$result=mysql_query($query,$dbf->conn) or die(mysql_error());//
	$total_array = array();
	
	//make detail list....
	while($row=mysql_fetch_assoc($result)){
		$cust_id = $row['customer_id'];
		//only those who are check in...
		if($dbf->isCheckin($cust_id)){
			$_SESSION['co_reg_members'][] = $cust_id;
		}
	}
}

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$cf=new Codefilter();

$customers_table="$cfg_tableprefix".'customers';
$lockers_table="$cfg_tableprefix".'lockers';
$group_table="$cfg_tableprefix".'groups';
$group_members_table="$cfg_tableprefix".'group_members';

////////////////////////////////////////////////////////////////////////////////////////////
/*
unset($_SESSION['co_reg_members']);
$_SESSION['co_reg_members'][] = 'abcde';
$_SESSION['co_reg_members'][] = '9';
$_SESSION['co_reg_members'][] = '8';
$_SESSION['co_reg_members'][] = '7';
*/

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}

//`FbNAEgZσtO
$_SESSION['checkout_payment'] = 'notyet';

//if process is already undergoing...
if(isset($_SESSION['in_gr_co_process'])){
	if($_SESSION['in_gr_co_process']=='1'){
		header ("location: customer_group_checkout_2.php");
		exit;
	}
}

//cancel
if($_GET['act']=='cancel'){
	unset($_SESSION['co_reg_members']);
	header("location: customer_checkout.php");
	exit;
}

?>
	<script type="text/javascript" language="javascript">
	<!--
	function nameFocus()
	{
		document.customers.customer_name.focus();
	}
	function card_idFocus()
	{
		document.customers.customer_num.focus();
	}
	function lockerFocus()
	{
		document.customers.locker_num.focus();
	}
	function nameFocus()
	{
		document.customers.name.focus();
	}
	//-->
	</script>
<SCRIPT TYPE="text/javascript" SRC="../classes/keynavi_ja.js"></SCRIPT>
<?php

if($_GET['act']=='g_srch' || $_GET['act']=='p_srch'){
	focus_control(1);
} else {
	focus_control(0);
}

// first display
$display->displayTitle("$lang->groupCheckOut");

//cancel
echo "<form action='customer_group_checkout.php' method='GET'><center>\n";
echo "<input type='hidden' name='act' value='cancel'>";
echo "<input type='submit' name='payment' id=kl_click_F1 value='$lang->cancelCheckOut[F1]'>\n";
echo "</center></form>\n";

switch($_GET['act']){
	case 'm_srch': //manual search
		$opt = 0;
	break;
	
	case 'g_srch': //group search
		$opt = 1;
	break;
	
	case 'p_srch': //party search
		$opt = 2;
	break;

	case 'insert':
		if(isset($_GET['id'])){
			cus_reg_insert($_GET['id']);
		}
	break;

	case 'delete':
		if(isset($_GET['id'])){
			cus_reg_delete($_GET['id']);
		}
	break;
	
	case 'gr_insert':
		if(isset($_GET['id'])){
			group_insert($_GET['id']);
		}
	break;
	
	default:
		$opt = 0;
	break;
}

echo "<center><table BORDER='1' WIDTH='95%'><tr>\n";
//LEFT SIDE
echo "<td WIDTH='40%'>";
echo "<BR><center><B>$lang->co_cus_search</B></center><BR>";
echo "<center><font size='2'>".make_search_menu($opt)."</font></center>";
echo "<HR>\n";

//title
echo "<center><B>".make_title($opt)."</B><center>";
//search_form
search_form($opt);

//search result
switch($_POST['act']){
	case 'cust_search';

		if(isset($_POST['customer_num']) && (strlen(trim($_POST['customer_num']))<>0)){
			//$cus_array = array($_POST['customer_num']);
			//disp_id($cus_array);
			cus_reg_insert($_POST['customer_num']);
		}	
	
		if(isset($_POST['locker_num']) && (strlen(trim($_POST['locker_num']))<>0)){
			$locker  = $_POST['locker_num'];
			//disp_locker($locker);
			if($dbf->isLockerUsed($locker) == False){
				echo "$lang->lockernum ".$locker." $lang->isNotUsed";
			} else {
				$cus_id = $dbf->lockertocustomer_id($locker);
				cus_reg_insert($cus_id);
			}
		}
	
		if(isset($_POST['customer_name']) && (strlen(trim($_POST['customer_name']))<>0)){
			$cus_name = $_POST['customer_name'];
			disp_cusname($cus_name);
		}
	break;
	
	case 'group_search':
		$group_name = $_POST['name'];
		if(strlen($group_name)<>0){
			put_group($group_name);
		}
	break;
	
	case 'party_search':
		echo "party search.";
	break;

}

echo "</td>";
//RIGHT SIDE
echo "<td WIDTH='60%' VALIGN='top'>";
echo "<BR><center><B>$lang->namelist_checkout</B></center><BR>";
putout_members();

//Start Checkout
//cancel
if(count($_SESSION['co_reg_members'])){
	echo "<form action='customer_group_checkout_2.php' method='GET'><center>\n";
	echo "<input type='hidden' name='act' value='checkout'>";
	echo "<input type='submit' name='payment' id=kl_click_F2 value='$lang->start_gr_checkout[F2]'>\n";
	echo "</center></form>\n";
}

echo "</td>";

echo "</tr></table></center>\n";

?>
