<?PHP
// SVG table Class. (C)2005 S.Dozono
// Usage:
/*
	require_once("svg_table.php");
	$sample_headers = array (
		"HEADER1","HEADER2","HEADER3","HEADER4"
	);
	$sample_data = array(
		array ("Data1","Data2","Data3","Data4"),
		array ("Data2-1","Data2-2","Data2-3","Data2-4"),
	);
	
	$px = new SVGtable('TITLE',$sample_headers,$sample_data,X,Y,WIDTH,HEIGHT);

	//$px->SVGView();
	or
	$px->pxDoc();
*/

//
//rƕ̊Ԃ̋
define ("HEADER_WIDTH_GAP","20");
define ("HEADER__HEIGHT_GAP","55");
define ("DATA_WIDTH_GAP","20");
define ("DATA_HEIGHT_GAP","55");

class SVGtable {

	var $title;
	var $header_array;
	var $data_array;
	var $init_x;
	var $init_y;
	var $td_height;
	var $td_width;

	function SVGtable($title,$tableheaders,$data,$x,$y,$td_width,$td_height){
	
		$this->title = $title;
		$this->header_array = $tableheaders;
		$this->data_array = $data;
		$this->init_x = $x;
		$this->init_y = $y;
		$this->td_height = $td_height;
		$this->td_width = $td_width;
	}

	function DeclareXML(){

		echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	}

	function PutTitle(){

		if(!empty($this->title)){
			$temp_title = mb_convert_encoding($this->title,"UTF-8","auto");
			echo "<text x=\"50%\" y=\"160\" font-size=\"80\" text-anchor=\"middle\" letter-spacing=\"20\">$temp_title</text>\n"; 
		}
	}

	function MakeSVG(){

		echo "\n<svg width=\"210mm\" height=\"297mm\" viewBox=\"0 0 2100 2970\" preserveAspectRatio=\"xMidYMid meet\">\n";
		echo "\n";
		$this->PutTitle();

		//table headers
		for($i=0;$i< count($this->header_array); $i++)
		{
			$temp_x = $this->init_x + $this->td_width * $i;
			$temp_y = $this->init_y;
			$temp_x2 = $this->init_x + $this->td_width * $i + HEADER_WIDTH_GAP;
			$temp_y2 = $this->init_y+ HEADER__HEIGHT_GAP;
			$temp_header = mb_convert_encoding($this->header_array[$i],"UTF-8","auto"); 
			echo "<g>\n";
			echo "<rect x=\"$temp_x\" y=\"$temp_y\" width=\"$this->td_width\" height=\"$this->td_height\" style=\"fill:rgb(192,192,192);stroke:rgb(0,0,0);stroke-width:1\"/>\n";
			echo "<text x=\"$temp_x2\" y=\"$temp_y2\" style=\"fill:rgb(0,0,0);font-family:MS-PGothic;font-size:40;text-anchor:start\" xml:space=\"preserve\">$temp_header</text>\n";
			echo "</g>\n";
		}
		
		//data
		for($i=0;$i< count($this->data_array); $i++)
		{
			$values_array = $this->data_array[$i];
			$temp_y = $this->init_y + $this->td_height * ($i+1);
			$temp_y2 = $this->init_y + $this->td_height * ($i+1) + DATA_HEIGHT_GAP;
			for($k=0;$k< count($values_array); $k++)
			{
				$temp_x = $this->init_x + $this->td_width * $k;
				$temp_x2 = $this->init_x + $this->td_width * $k + DATA_WIDTH_GAP;
				$temp_data = mb_convert_encoding($values_array[$k],"UTF-8","auto"); 
				echo "<g>\n";
				echo "<rect x=\"$temp_x\" y=\"$temp_y\" width=\"$this->td_width\" height=\"$this->td_height\" style=\"fill:rgb(255,255,255);stroke:rgb(0,0,0);stroke-width:1\"/>\n";
				echo "<text x=\"$temp_x2\" y=\"$temp_y2\" style=\"fill:rgb(0,0,0);font-family:MS-PGothic;font-size:40;text-anchor:start\" xml:space=\"preserve\">$temp_data</text>\n";
				echo "</g>\n";
			}
		}
		
		echo "<pages>\n";
		echo "<page num=\"1\" title=\"New Page\"/>\n";
		echo "</pages>\n";
		echo "</svg>\n";
	}

	function SVGView(){

		header ("Content-type: image/svg-xml\n\n");
		$this->DeclareXML();
		$this->MakeSVG();
	}

	function pxDoc(){

		header("Content-type: application/pxd; charset=\"UTF-8\"");
		header("Content-Disposition:inline;filename=\"chart.pxd\"");
		$this->DeclareXML();
		echo "<pxd paper-type=\"a4\" name=\"TestPxd\">";
		echo "<page>";
		$this->MakeSVG();
		echo "</page></pxd>";
	}

}

/*
	//Tv
	$sample_headers = array (
		"i",
		"",
		"Tv",
		"li"
	);
	$sample_data = array(
		array ("pxDoc","D.Kuroda","Web\[V",""),
		array ("SVG r[A","adobe","SVG̉ʕ\",""),
		array ("Apache","ASF","T[o",""),
		array ("MYSQL","MySQL AB","f[^x[X",""),
		array ("PHP","Zend","XNvg","")
	);
	$px = new SVGtable('WebJc[',$sample_headers,$sample_data,90,250,450,80);

	//ŉʕ\
	//$px->SVGView();
	//pxDocɂ
	$px->pxDoc();

*/
?>
