<?php

class security_functions
{	
	var $conn;
	var $lang;
	var $tblprefix;
	
	function clean_null($array){
		while (list($key, $val) = each($array)) {
	    	$array[$key] = str_replace( "\0", "", $val) ;
		}
		return $array;
	}
	
	//defalt constructor which first checks if page is accessable.
	function security_functions($dbf,$page_type,$language)
	{
		//Security
        if (! empty($array['_SESSION'])|| ! empty($array['_COOKIE'])
		 || ! empty($array['_SERVER']) || ! empty($array['_ENV'])
		 || ! empty($array['_FILES'])  || ! empty($array['GLOBALS']) 
		) exit ;
		
		$_POST = & $this->clean_null($_POST);
		$_GET  = & $this->clean_null($_GET);
		$_COOKIE = & $this->clean_null($_COOKIE);
	
		$_SERVER['PHP_SELF'] = strtr( @$_SERVER['PHP_SELF'] , array('<'=>'%3C','>'=>'%3E',"'"=>'%27','"'=>'%22' , "\r" => '' , "\n" => '' ) ) ;
		$_SERVER['PATH_INFO'] = strtr( @$_SERVER['PATH_INFO'] , array('<'=>'%3C','>'=>'%3E',"'"=>'%27','"'=>'%22' , "\r" => '' , "\n" => '' ) ) ;
	
		//pre: $dbf must be a db_functions object and $page_type must be a string
		//post: denies access to page and stops php processing
		
		//$page_type will be either: Public, Admin, Sales Clerk or Report Viewer.
		//$usertype will be either: Admin, Sales Clerk or Report Viewer.
		//Their must be a session present in order to execute authoization.
		
		//sets class variables.
		$this->conn=$dbf->conn;
		$this->lang=$language;
		$this->tblprefix=$dbf->tblprefix;
		
		if(isset($_SESSION['session_user_id']))
		{
			$user_id=$_SESSION['session_user_id'];
			
			$tablename="$this->tblprefix".'users';
			$result = mysql_query ("SELECT * FROM $tablename WHERE id=\"$user_id\"",$this->conn) or die(mysql_error());//
			$row = mysql_fetch_assoc($result);
			$usertype= $row['type'];
			
			
			//If the page is not public or the user is not an Admin, investigation must continue.
			if($page_type!='Public' or $usertype!='Admin')
			{
				if($usertype!='Admin' and $usertype!='Sales Clerk' and $usertype!='Report Viewer')
				{
					//makes sure $usertype is not anything but Admin, Sales Clerk, Report Viewer

					echo "{$this->lang->attemptedSecurityBreech}";
					exit();
				}
				elseif($page_type!='Public' and $page_type!='Admin' and $page_type!='Sales Clerk' and $page_type!='Report Viewer')
				{
					//makes sure $page_type is not anything but Public, Admin, Sales Clerk or Report Viewer.

					echo "{$this->lang->attemptedSecurityBreech}";				
					exit();
				
				}
				elseif($usertype!='Admin' and $page_type=='Admin')
				{
					//if page is only intented for Admins but the user is not an admin, access is denied.

					echo "{$this->lang->mustBeAdmin}";				
					exit();	
				}
				elseif(($usertype=='Sales Clerk') and $page_type =='Report Viewer')
				{
					//Page is only intented for Report Viewers and Admins.
					
					echo "{$this->lang->mustBeReportOrAdmin}";				
					exit();
				}
				elseif(($usertype=='Report Viewer') and $page_type =='Sales Clerk')
				{
					//Page is only intented for Sales Clerks and Admins.
					
					echo "{$this->lang->mustBeSalesClerkOrAdmin}";				
					exit();
				}
			}
		}
	}
	
	//by S.Dozono 2005
	function IP_check()
	{
		global $cfg_iplist;
	
		$ip_addr = $_SERVER['REMOTE_ADDR'];
		$host = gethostbyaddr($ip_addr);

		$line = explode("\n", trim($cfg_iplist));
		$check_ok = False;
		
		if(strlen($cfg_iplist)==0){
			//no lists, so it will accept all domains.
			return True;
		}

		for($i=0; $i< count($line); $i++){
			$data_pair = explode(":", $line[$i]);

			if(strpos($host, trim($data_pair[1])) !== false){
				$check_ok = True;
				break;
			}
		}

		if($check_ok){
			//echo "************* check OK. *********************";
			//die;
			return True;
		} else {
			//echo "************* check failed ******************";
			//die;
			return False;
		}
	}	

	function forcedJump($url)
	{
		//Wvw
		$_SESSION['FORCED_JUMP_URL'] = 
			"http://"
			.$_SERVER['HTTP_HOST']
			.dirname($_SERVER['PHP_SELF'])
			."/".$url;
		//echo $_SESSION['FORCED_JUMP_URL'];
		//die;
	}

	function cancelforcedJump()
	{
		//Wv̉
		unset($_SESSION['FORCED_JUMP_URL']);
	}

	function isLoggedIn($forcedjump='1')
	{
		//returns boolean based on if user is logged in.
		if(isset($_SESSION['session_user_id']))
		{
			$user_id=$_SESSION['session_user_id'];
			$tablename="$this->tblprefix".'users';
			$result = mysql_query ("SELECT * FROM $tablename WHERE id=\"$user_id\"",$this->conn) or die(mysql_error());//
			$num = @mysql_num_rows($result);
			if($num> 0)
			{
				//Wv
				if( ($forcedjump==1) && (isset($_SESSION['FORCED_JUMP_URL'])) ){
					header ("location: ".$_SESSION['FORCED_JUMP_URL']);
					die;
					//header ("location: http://localhost/pos/customers/".$_SESSION['FORCED_JUMP_URL']);
					//die;
				}
				return true;
			}
			else
			{
				return false;
			}
		}
		return false;
	}
	
	function checkLogin($username,$password)
	{
		//pre: $username and $password must be strings. ($password is encrypted)
		//post: returns boolean based on if their login was succesfull.
		
		$tablename="$this->tblprefix".'users';
		$result = mysql_query ("SELECT * FROM $tablename WHERE username=\"$username\" and password=\"$password\"",$this->conn) or die(mysql_error());//	
		$num = @mysql_num_rows($result);
		
		if($num > 0)
		{
			//IP check added.....
			if($this->IP_check()){
				return true;
			}
		}
		
		return false;
	}

	function closeSale()
	{
		//deletes sessions vars 
		
		unset($_SESSION['current_sale_customer_id']);
		unset($_SESSION['items_in_sale']);
		unset($_SESSION['current_item_search']);
		unset($_SESSION['current_customer_search']);

	}
}

?>