<?PHP

// Printing by pxDoc (c)2004 CBA-Japan All Rights Reserved.
// by S.Dozono
class pxDoc {

	function pxDoc($charset="shift-jis",$filename="golf.pxd"){
		// wb_o
		header("Content-type: application/pxd; charset=$charset");
		header("Content-Disposition:inline;filename=\"$filename\"");
		
		echo "<?xml version=\"1.0\" encoding=\"$charset\"?>\n\n";
		// ̉̋s͕KĂB
	}
	
	function BeginPxd($paper_type,$title,$name_for_printer,$orientation='portrait'){
		echo "<pxd paper-type=\"$paper_type\" title=\"$title\" orientation=\"$orientation\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"".$name_for_printer."\" >\n";
	
	}

	function EndPxd(){
		echo "</pxd>\n";
	}

	function BeginSVG($x,$y,$width,$height,$v1,$v2,$v3,$v4){
		//<!-- ȉA̒210021cmɑΉc̒297029.7cmɑΉB -->
		//<!-- y="10"1mm̈ӖɂȂ -->
		//<svg x="0" y="0" width="21cm" height="29.7cm" viewBox="0 0 2100 2970">
		echo "<svg x=\"$x\" y=\"$y\" width=\"$width\" height=\"$height\" viewBox=\"$v1 $v2 $v3 $v4\">\n";
	}

	function EndSVG(){
		echo "</svg>\n";
	}

	function BeginPage(){
		echo "<page>\n";	
	}
	
	function EndPage(){
		echo "</page>\n";
	}
	
	function StartText($y,$fontsize){
		echo "<text y=\"$y\" font-size=\"$fontsize\">\n";

	}
	
	function EndText(){
		echo "</text>\n";
	
	}
	
	function BeginBackGroundPage($name){
	//<!-- wi`߂̃y[WƂėpBۂɂ̃y[W\Ȃ悤hiddenݒ -->
		echo "<page type=\"hidden\" id=\"$name\">\n";	
	}
	
	function EndBackGroundPage(){
		echo "</page>\n";
	}

	function UseBackGround($name){
	//	<!-- wi𗘗p -->
	echo "<background id=\"$name\"/>\n";
	}


}

class Receipt extends pxDoc {
	
	////////////////////////////////////

	//V[gɕKvȃf[^
	var $p_title; //
	var $p_doc_no;
	var $p_year;
	var $p_month;
	var $p_day;
	var $p_zip;
	var $p_address1;
	var $p_address2;
	var $p_name1;
	var $p_name2;
	var $p_name3;
	var $p_fname1;
	var $p_fname2;
	var $p_fname3;
	var $p_fzip;
	var $p_faddress;
	var $p_tel;
	var $p_fax;
	var $p_total;

	var $p_sub_total;
	var $p_tax;
	var $p_grand_total;
	var $p_check;
	var $p_change;
		
	var $p_data_array; //[4]

	///////////////////////////////////

	function MakeHeader(){

		//<!-- wb_ -->
		//<text x="50%" y="160" font-size="80" text-anchor="middle" letter-spacing="20">$title</text>
		//<g x="95%" font-size="40" text-anchor="end">
		//	<text y="120">No. 71000005178</text>
		//	<text y="160">s 2004N 4 20</text>
		//</g>
		echo "<text x=\"45%\" y=\"160\" font-size=\"80\" text-anchor=\"middle\" letter-spacing=\"20\">$this->p_title</text>\n";
		echo "<g x=\"90%\" font-size=\"40\" text-anchor=\"end\">\n";
		echo "<text y=\"150\">No. ".$this->p_doc_no."</text>\n";
		echo "<text x=\"45%\" y=\"300\" text-anchor=\"middle\">s ".$this->p_year."N".$this->p_month."".$this->p_day."</text>\n";
		echo "</g>\n";

	}

	function MakeDeliveryAddress(){
		//<!-- t -->
		//<text x="5%" y="240" font-size="40">
		//	<tspan>PTQ|XXXX</tspan>
		//	<tspan x="5%" dy="50">sڍ恛PԂQ</tspan>
		//	<tspan x="5%" dy="50">^[QTK</tspan>
		//	<tspan x="5%" dy="75"></tspan>
		//	<tspan x="5%" dy="50"></tspan>
		//	<tspan x="5%" dy="50">@@l</tspan>
		//</text>
		echo "<text x=\"55%\" y=\"300\" font-size=\"40\">\n";
		echo "<tspan>$this->p_zip</tspan>\n";
		echo "<tspan x=\"5%\" dy=\"50\">$this->p_address1</tspan>\n";
		echo "<tspan x=\"5%\" dy=\"50\">$this->p_address2</tspan>\n";
		echo "<tspan x=\"5%\" dy=\"75\">$this->p_name1</tspan>\n";
		echo "<tspan x=\"5%\" dy=\"50\">$this->p_name2</tspan>\n";
		echo "<tspan x=\"5%\" dy=\"50\">$this->p_name3</tspan>\n";
		echo "</text>\n";
	}

	function MakeMyAddress(){

		//<!-- t -->
		//<text x="60%" y="350" font-size="40">
		//	<tspan></tspan>
		//	<tspan x="60%" dy="50">cƕ</tspan>
		//	<tspan x="60%" dy="50">S@@</tspan>
		//	<tspan x="60%" dy="75">WPO|XXXX</tspan>
		//	<tspan x="60%" dy="50">s恢PڂQ</tspan>
		//	<tspan x="60%" dy="50">TEL@092-000-0000</tspan>
		//	<tspan x="60%" dy="50">FAX@092-000-0001</tspan>
		//</text>
		echo "<text x=\"35%\" y=\"430\" font-size=\"40\" text-anchor=\"middle\" >\n";
		echo "<tspan>$this->p_fname1</tspan>\n";
		echo "<tspan x=\"35%\" dy=\"50\">$this->p_fname2</tspan>\n";
		echo "<tspan x=\"35%\" dy=\"50\">$this->p_fname3</tspan>\n";
		echo "</text>\n";
		echo "<text x=\"85%\" y=\"350\" font-size=\"40\" text-anchor=\"end\" >\n";
		echo "<tspan x=\"85%\" dy=\"75\">$this->p_fzip</tspan>\n";
		echo "<tspan x=\"85%\" dy=\"50\">$this->p_faddress</tspan>\n";
		echo "<tspan x=\"85%\" dy=\"50\">TEL@$this->p_tel</tspan>\n";
		echo "<tspan x=\"85%\" dy=\"50\">FAX@$this->p_fax</tspan>\n";
		echo "</text>\n";

	}

	function MakeTotal(){
		//<!-- vz -->
		//<text x="30%" y="770" font-size="60">vz</text>
		//<text x="50%" y="770" font-size="60" font-family="'lr oSVbN'">\303,500,000-</text>
		//echo "<text x=\"30%\" y=\"770\" font-size=\"60\"></text>\n";
		echo "<text x=\"50%\" y=\"770\" font-size=\"60\" text-anchor=\"middle\" font-family=\"'lr oSVbN'\">$this->p_total</text>\n";
	}

	function MakeColumTitle(){
		//<!-- ^Cg -->
		//<g y="845" font-size="40" text-anchor="middle">
		//	<text x="550" textlength="300" >i</text>
		//	<text x="1150" textlength="200">P</text>
		//	<text x="1400" textlength="100"></text>
		//	<text x="1750" textlength="200">z</text>
		//</g>
		echo "<g y=\"845\" font-size=\"40\" text-anchor=\"middle\">\n";
		echo "<text x=\"550\" textlength=\"300\" >i</text>\n";
		echo "<text x=\"1150\" textlength=\"200\">P</text>\n";
		echo "<text x=\"1400\" textlength=\"100\"></text>\n";
		echo "<text x=\"1750\" textlength=\"200\">z</text>\n";
		echo "</g>\n";

	}

	function MakeDataStyle(){
		//<!-- f[^ -->
		//<style type="text/css"><![CDATA[
		//  .row1 { x:110; dy:50;}
		//  .row2 { x:1290; text-anchor:end;}
		//  .row3 { x:1490; text-anchor:end;}
		//  .row4 { x:1990; text-anchor:end;}
		//]]></style>
		echo "<style type=\"text/css\"><![CDATA[\n";
		echo "  .row1 { x:110; dy:50;}\n";
		echo "  .row2 { x:1290; text-anchor:end;}\n";
		echo "  .row3 { x:1490; text-anchor:end;}\n";
		echo "  .row4 { x:1990; text-anchor:end;}\n";
		echo "  .row5 { x:1520; dy:50; }\n";
		echo "  .row6 { x:1520; dy:52; font-size:50;}\n";
		echo "  .row7 { x:1900; dy:80; text-anchor:end;}\n";
		echo "]]></style>\n";
	}

	function MakeOneData($key){
		echo "<tspan class=\"row1\">$key[0]</tspan>\n";
		echo "<tspan class=\"row2\">$key[1]</tspan>\n";
		echo "<tspan class=\"row3\">$key[2]</tspan>\n";
		echo "<tspan class=\"row4\">$key[3]</tspan>\n";
	}

	function MakeCashInfo(){
//		echo "<text x=\"35%\" y=\"430\" font-size=\"40\" text-anchor=\"middle\" >\n";
		echo "<tspan class=\"row7\"> ----------------------------</tspan>\n";
		echo "<tspan class=\"row5\"> vF$this->p_sub_total </tspan>\n";
		echo "<tspan class=\"row5\"> [œ $this->p_tax] </tspan>\n";
		echo "<tspan class=\"row6\"> vF$this->p_grand_total </tspan>\n";
		echo "<tspan class=\"row6\"> aF$this->p_check </tspan>\n";
		echo "<tspan class=\"row6\"> ނF$this->p_change </tspan>\n";
//		echo "</text>";
	}

	function MakePage(){
		$this->BeginPxd("A4","̎","golf");

			$this->MakeMitumori();
			
			$this->BeginPage();
				$this->UseBackGround("b1");

				$this->BeginSVG(0,0,"21cm","29.7cm",0,0,2100,2970);

					$this->MakeHeader();
					$this->MakeDeliveryAddress();
					$this->MakeMyAddress();
					$this->MakeTotal();
					$this->MakeColumTitle();
					$this->MakeDataStyle();
					$this->StartText(854,40);
						for($i=0;$i<count($this->p_data_array);$i++){
							$this->MakeOneData($this->p_data_array[$i]);
						}
						$this->MakeCashInfo();
					$this->EndText();
				$this->EndSVG();
			$this->EndPage();
			
		$this->EndPxd();
	}

	function MakeMitumori(){

echo <<<EOD
	<page type="hidden" id="b1">
		<!-- ȉA̒210021cmɑΉc̒297029.7cmɑΉB -->
		<!-- y="10"1mm̈ӖɂȂ -->
		<svg x="0" y="0" width="21cm" height="29.7cm" viewBox="0 0 2100 2970">
			<!-- \̐쐬 -->
			<g stroke="none" fill="whitesmoke">
				<rect x="101" y="850" width="1897" height="50"/>
				<rect x="101" y="950" width="1897" height="50"/>
				<rect x="101" y="1050" width="1897" height="50"/>
				<rect x="101" y="1150" width="1897" height="50"/>
				<rect x="101" y="1250" width="1897" height="50"/>
				<rect x="101" y="1350" width="1897" height="50"/>
				<rect x="101" y="1450" width="1897" height="50"/>
				<rect x="101" y="1550" width="1897" height="50"/>
				<rect x="101" y="1650" width="1897" height="50"/>
				<rect x="101" y="1750" width="1897" height="50"/>
				<rect x="101" y="1850" width="1897" height="50"/>
				<rect x="101" y="1950" width="1897" height="50"/>
				<rect x="101" y="2050" width="1897" height="50"/>
				<rect x="101" y="2150" width="1897" height="50"/>
				<rect x="101" y="2250" width="1897" height="50"/>
				<rect x="101" y="2350" width="1897" height="50"/>
				<rect x="101" y="2450" width="1897" height="50"/>
				<rect x="101" y="2550" width="1897" height="50"/>
				<rect x="101" y="2650" width="1897" height="50"/>
			</g>
			<g stroke="black" fill="none" stroke-width="1">
				<!-- rx="20"ݒ肷邱ƂŁAlp̊pɊۂ݂ł -->
				<rect x="100" y="700" width="1900" height="80" rx="20"/>
				<rect x="100" y="800" width="1900" height="1950" rx="20"/>
				<g y1="800" y2="2750">
					<line x1="1000" x2="1000" />
					<line x1="1300" x2="1300" />
					<line x1="1500" x2="1500" />
				</g>
				<line x1="100" x2="2000" y1="850" y2="850"/>
			</g>
		</svg>
	</page>
EOD;
echo "\n";
	}
}
?>