// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Daniel Grunwald" email="daniel@danielgrunwald.de"/>
//     <version>$Revision: 1663 $</version>
// </file>

using System;
using System.Xml;
using ICSharpCode.SharpDevelop.Dom;
using ICSharpCode.SharpDevelop.Internal.Templates;
using ICSharpCode.SharpDevelop.Project;

namespace Grunwald.BooBinding
{
	public class BooLanguageBinding : ILanguageBinding
	{
		public const string LanguageName = "Boo";
		
		public string Language {
			get {
				return LanguageName;
			}
		}
		
		public IProject LoadProject(string fileName, string projectName)
		{
			return new BooProject(fileName, projectName);
		}
		
		public IProject CreateProject(ProjectCreateInformation info, XmlElement projectOptions)
		{
			BooProject p = new BooProject(info);
			if (projectOptions != null)
				p.ImportOptions(projectOptions.Attributes);
			return p;
		}
		
		public LanguageProperties LanguageProperties {
			get {
				return BooLanguageProperties.Instance;
			}
		}
	}
}
