package sharin.unlinq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BasicEnumerableList<TSource> implements EnumerableList<TSource> {

    private final List<TSource> list;

    public BasicEnumerableList() {
        this(null);
    }

    public BasicEnumerableList(List<TSource> list) {

        if (list == null) {
            list = new ArrayList<TSource>();
        }

        this.list = list;
    }

    private Enumerable<TSource> getEnumerable() {
        return new BasicEnumerable<TSource>(list);
    }

    @Override
    public String toString() {
        return list.toString();
    }

    public void add(int index, TSource element) {
        list.add(index, element);
    }

    public boolean add(TSource o) {
        return list.add(o);
    }

    public boolean addAll(Collection<? extends TSource> c) {
        return list.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends TSource> c) {
        return list.addAll(index, c);
    }

    public void clear() {
        list.clear();
    }

    public boolean contains(Object o) {
        return list.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return list.equals(o);
    }

    public TSource get(int index) {
        return list.get(index);
    }

    @Override
    public int hashCode() {
        return list.hashCode();
    }

    public int indexOf(Object o) {
        return list.indexOf(o);
    }

    public boolean isEmpty() {
        return list.isEmpty();
    }

    public Iterator<TSource> iterator() {
        return list.iterator();
    }

    public int lastIndexOf(Object o) {
        return list.lastIndexOf(o);
    }

    public ListIterator<TSource> listIterator() {
        return list.listIterator();
    }

    public ListIterator<TSource> listIterator(int index) {
        return list.listIterator(index);
    }

    public TSource remove(int index) {
        return list.remove(index);
    }

    public boolean remove(Object o) {
        return list.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return list.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return list.retainAll(c);
    }

    public TSource set(int index, TSource element) {
        return list.set(index, element);
    }

    public int size() {
        return list.size();
    }

    public List<TSource> subList(int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return list.toArray();
    }

    public <R> R[] toArray(R[] a) {
        return list.toArray(a);
    }

    public <A, R> R aggregate(A seed, Func2<A, TSource, A> func,
            Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, TSource, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public TSource aggregate(Func2<TSource, TSource, TSource> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<TSource, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<TSource, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<TSource, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<TSource, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<TSource, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<TSource, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<TSource> concat(Enumerable<TSource> second) {
        return getEnumerable().concat(second);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<TSource, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<TSource> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<TSource> defaultIfEmpty(TSource defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<TSource> distinct() {
        return getEnumerable().distinct();
    }

    public TSource elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public TSource elementAtOrDefault(int index, TSource defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public TSource elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<TSource> except(Enumerable<TSource> second) {
        return getEnumerable().except(second);
    }

    public TSource first() {
        return getEnumerable().first();
    }

    public TSource first(Func<TSource, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public TSource firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public TSource firstOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public TSource firstOrDefault(Func<TSource, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public TSource firstOrDefault(TSource defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public <K, E, R> Enumerable<R> groupBy(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(Func<TSource, K> keySelector,
            Func2<K, Enumerable<TSource>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, TSource>> groupBy(
            Func<TSource, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<TSource, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<TSource> intersect(Enumerable<TSource> second) {
        return getEnumerable().intersect(second);
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<TSource, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public TSource last() {
        return getEnumerable().last();
    }

    public TSource last(Func<TSource, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public TSource lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public TSource lastOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public TSource lastOrDefault(Func<TSource, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public TSource lastOrDefault(TSource defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<TSource, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public TSource max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(Func<TSource, R> selector) {
        return getEnumerable().max(selector);
    }

    public TSource min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(Func<TSource, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<TSource> orderBy(Func<TSource, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<TSource> orderBy(Func<TSource, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<TSource> orderByDescending(
            Func<TSource, K> keySelector, Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<TSource> orderByDescending(
            Func<TSource, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<TSource> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<TSource, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(Func2<TSource, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<TSource, Enumerable<C>> collectionSelector,
            Func2<TSource, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(Func<TSource, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<TSource, Integer, Enumerable<C>> collectionSelector,
            Func2<TSource, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<TSource, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<TSource> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public TSource single() {
        return getEnumerable().single();
    }

    public TSource single(Func<TSource, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public TSource singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public TSource singleOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public TSource singleOrDefault(Func<TSource, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public TSource singleOrDefault(TSource defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Enumerable<TSource> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<TSource> skipWhile(Func<TSource, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<TSource> skipWhile(
            Func2<TSource, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<TSource, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<TSource, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<TSource, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<TSource, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<TSource> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<TSource> takeWhile(Func<TSource, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<TSource> takeWhile(
            Func2<TSource, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, TSource> toDictionary(Func<TSource, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public List<TSource> toList() {
        return getEnumerable().toList();
    }

    public EnumerableList<TSource> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public <K> Map<K, List<TSource>> toListMap(Func<TSource, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Map<K, List<E>> toListMap(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K, E> Lookup<K, E> toLookup(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, TSource> toLookup(Func<TSource, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public Enumerable<TSource> union(Enumerable<TSource> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<TSource> where(Func<TSource, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<TSource> where(Func2<TSource, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public <K> Map<K, TSource> toMap(Func<TSource, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }

    public Enumerable<TSource> asEnumerable() {
        return getEnumerable().asEnumerable();
    }
}
