package sharin.sql;

import java.util.Arrays;

public class Sql {

    private String text;

    private Object[] params;

    public Sql(String text, Object... params) {
        this.text = text;
        this.params = params;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(text);

        if (params != null && params.length > 0) {
            builder.append(' ');
            builder.append(Arrays.toString(params));
        }

        return builder.toString();
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object[] getParams() {
        return params;
    }

    public void setParams(Object... params) {
        this.params = params;
    }
}
