package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;

import sharin.unlinq.Func;
import sharin.unlinq.QueuedIterator;

public class SkipWhileIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;

    private final Func<T, Boolean> predicate;

    public SkipWhileIterable(Iterable<T> iterable, Func<T, Boolean> predicate) {
        this.iterable = iterable;
        this.predicate = predicate;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(iterable.iterator()) {

            private boolean skipped;

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (!skipped) {

                    if (predicate.call(t)) {
                        return;
                    }

                    skipped = true;
                }

                queue.add(t);
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
